/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.dataconnect;

import com.belenus.util.Configurator;
import java.io.File;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

abstract class DatabaseConnector
implements Runnable {
    private static final Logger logger = Logger.getLogger((Class)(class$com$belenus$dataconnect$DatabaseConnector == null ? (class$com$belenus$dataconnect$DatabaseConnector = DatabaseConnector.class$("com.belenus.dataconnect.DatabaseConnector")) : class$com$belenus$dataconnect$DatabaseConnector));
    private LinkedList m_connections = new LinkedList();
    private LinkedList m_availableConnections = new LinkedList();
    private LinkedList m_usedConnections = new LinkedList();
    private HashMap m_preparedStatementCollectionMap = new HashMap();
    private Configurator m_configurator;
    private Driver m_driver;
    private String m_databaseDriver;
    private String m_databaseUrl;
    private String m_databaseUrlPostfix;
    private String m_databaseUrlAssembled;
    private String m_databaseUser;
    private String m_databasePassword;
    private int m_databasePoolMax;
    private int m_databasePoolMaxFree;
    private boolean m_databaseLog;
    private Properties m_databaseProperties;
    private DataSource m_dataSource;
    private String m_initialContextFactoryName;
    private String m_jndiName;
    private boolean m_prepared;
    private boolean m_autocommit;
    private int m_isolationlevel;
    private String[] m_initialQuery;
    static /* synthetic */ Class class$com$belenus$dataconnect$DatabaseConnector;

    private void assertEqual(Object object1, Object object2) throws Exception {
        if (object1 == null && object2 == null) {
            return;
        }
        if (object1 == null || object2 == null) {
            throw new Exception();
        }
        if (!object1.equals(object2) || !object2.equals(object1)) {
            throw new Exception();
        }
    }

    private void assertEqual(Object[] object1, Object[] object2) throws Exception {
        if (object1 == null && object2 == null) {
            return;
        }
        if (object1 == null || object2 == null) {
            throw new Exception();
        }
        if (object1.length != object2.length) {
            throw new Exception();
        }
        for (int object1Index = 0; object1Index < object1.length; ++object1Index) {
            if (object1[object1Index].equals(object2[object1Index]) && object2[object1Index].equals(object1[object1Index])) continue;
            throw new Exception();
        }
    }

    public boolean equals(Object object) {
        if (object instanceof DatabaseConnector) {
            DatabaseConnector databaseConnector = (DatabaseConnector)object;
            try {
                this.assertEqual(this.m_initialContextFactoryName, databaseConnector.m_initialContextFactoryName);
                this.assertEqual(this.m_jndiName, databaseConnector.m_jndiName);
                this.assertEqual(this.m_databaseDriver, databaseConnector.m_databaseDriver);
                this.assertEqual(this.m_databaseUrlAssembled, databaseConnector.m_databaseUrlAssembled);
                this.assertEqual(this.m_databaseUser, databaseConnector.m_databaseUser);
                this.assertEqual(this.m_databasePassword, databaseConnector.m_databasePassword);
                this.assertEqual(new Boolean(this.m_databaseLog), new Boolean(databaseConnector.m_databaseLog));
                this.assertEqual(this.m_databaseProperties, databaseConnector.m_databaseProperties);
                this.assertEqual(new Integer(this.m_databasePoolMax), new Integer(databaseConnector.m_databasePoolMax));
                this.assertEqual(new Integer(this.m_databasePoolMaxFree), new Integer(databaseConnector.m_databasePoolMaxFree));
                this.assertEqual(new Boolean(this.m_prepared), new Boolean(databaseConnector.m_prepared));
                this.assertEqual(new Boolean(this.m_autocommit), new Boolean(databaseConnector.m_autocommit));
                this.assertEqual(new Integer(this.m_isolationlevel), new Integer(databaseConnector.m_isolationlevel));
                this.assertEqual(this.m_initialQuery, databaseConnector.m_initialQuery);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    protected DatabaseConnector(Configurator configurator, File workingDirectoryPath) throws IllegalAccessException, InstantiationException, NamingException, SQLException {
        this.m_configurator = configurator;
        this.m_configurator.setScope("JNDI");
        this.m_initialContextFactoryName = this.m_configurator.getString("database.jndifactory", null);
        this.m_jndiName = this.m_configurator.getString("database.jndiname", null);
        this.m_configurator.setScope("JDBC");
        this.m_databaseDriver = this.m_configurator.getString("database.driver", null);
        this.m_databaseUrl = this.m_configurator.getString("database.url", null);
        this.m_databaseUrlPostfix = this.m_configurator.getString("database.urlpostfix", null);
        if (this.m_databaseUrl != null) {
            this.m_databaseUrlAssembled = this.m_databaseUrlPostfix == null || this.m_databaseUrlPostfix.equals("") ? this.m_databaseUrl : this.m_databaseUrl + workingDirectoryPath + this.m_databaseUrlPostfix;
            logger.info((Object)("Using Databese URL " + this.m_databaseUrlAssembled));
        }
        this.m_configurator.setScope("Database");
        this.m_configurator.addPasswordName("database.password");
        this.m_databaseUser = this.m_configurator.getString("database.user", null);
        this.m_databasePassword = this.m_configurator.getString("database.password", null);
        this.m_databaseLog = this.m_configurator.getBoolean("database.log", "false");
        this.m_databaseProperties = this.m_configurator.filterProperties("database");
        if (this.m_initialContextFactoryName != null && this.m_jndiName != null && !"".equals(this.m_initialContextFactoryName) && !"".equals(this.m_jndiName)) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.factory.initial", this.m_initialContextFactoryName);
            InitialContext initialContext = new InitialContext(hashtable);
            this.m_dataSource = (DataSource)initialContext.lookup(this.m_jndiName);
            if (this.m_dataSource == null) {
                throw new RuntimeException("DataSource " + this.m_jndiName + " not found for JNDI Context " + this.m_initialContextFactoryName);
            }
            this.m_databasePoolMax = 255;
            this.m_databasePoolMaxFree = 0;
        }
        if (this.m_databaseDriver != null && this.m_databaseUrlAssembled != null && !"".equals(this.m_databaseDriver) && !"".equals(this.m_databaseUrlAssembled)) {
            try {
                Class.forName(this.m_databaseDriver).newInstance();
            }
            catch (ClassNotFoundException exc) {
                throw new RuntimeException("Database driver class '" + this.m_databaseDriver + "' not found.");
            }
            this.m_driver = DriverManager.getDriver(this.m_databaseUrlAssembled);
            this.m_databasePoolMax = 16;
            this.m_databasePoolMaxFree = 2;
        }
        this.m_databasePoolMax = configurator.getInteger("database.poolmax", Integer.toString(this.m_databasePoolMax));
        this.m_databasePoolMaxFree = configurator.getInteger("database.poolmaxfree", Integer.toString(this.m_databasePoolMaxFree));
        this.m_prepared = configurator.getBoolean("database.prepared", "false");
        this.m_autocommit = configurator.getBoolean("database.autocommit", "false");
        this.m_isolationlevel = configurator.getInteger("database.isolationlevel", "0");
        this.m_initialQuery = configurator.getArray("database.initialquery");
        if (this.m_databaseUser == null) {
            throw new RuntimeException("Database user not given.");
        }
        if (this.m_databasePassword == null) {
            throw new RuntimeException("Database password not given.");
        }
        if (this.m_configurator.getBoolean("database.invalidateconnectionsrandomly", "false")) {
            this.invalidateConnectionsRandomly();
        }
        if (this.m_dataSource == null && this.m_driver == null) {
            throw new RuntimeException("Neither JNDI Datasource nor JDBC Datasource defined correctly");
        }
    }

    private void invalidateConnectionsRandomly() {
        logger.warn((Object)"Test-Mode: connections are invalidated randomly. Disable database.invalidateconnectionsrandomly for production.");
        Thread thread = new Thread((Runnable)this, "Connection Invalidater (only for testing purposes)");
        thread.setPriority(10);
        thread.setDaemon(true);
        thread.start();
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep((long)Math.floor(Math.random() * 1000.0 * 60.0));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                int pos = (int)Math.floor(Math.random() * (double)this.m_connections.size());
                Iterator connectionsIterator = this.m_connections.iterator();
                for (int connectionsIteratorIndex = 0; connectionsIteratorIndex < pos; ++connectionsIteratorIndex) {
                    connectionsIterator.next();
                }
                Connection connection = (Connection)connectionsIterator.next();
                connection.close();
            }
            catch (Exception exception) {
            }
        }
    }

    public boolean usePreparedStatements() {
        return this.m_prepared;
    }

    public Properties getDatabaseProperties() {
        return this.m_databaseProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector getPreparedStatementCollection(Connection connection) {
        LinkedList linkedList = this.m_connections;
        synchronized (linkedList) {
            return (Vector)this.m_preparedStatementCollectionMap.get(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(Connection connection) {
        try {
            LinkedList linkedList = this.m_connections;
            synchronized (linkedList) {
                logger.debug((Object)"================================= close connection =================================");
                this.m_connections.remove(connection);
                this.m_availableConnections.remove(connection);
                this.m_usedConnections.remove(connection);
                this.m_preparedStatementCollectionMap.remove(connection);
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        LinkedList linkedList = this.m_connections;
        synchronized (linkedList) {
            Iterator connectionsIterator = this.m_connections.iterator();
            while (connectionsIterator.hasNext()) {
                Connection connection = (Connection)connectionsIterator.next();
                this.closeConnection(connection);
            }
            this.m_connections = null;
            this.m_availableConnections = null;
            this.m_usedConnections = null;
            this.m_preparedStatementCollectionMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseBadConnection(Connection connection) {
        LinkedList linkedList = this.m_connections;
        synchronized (linkedList) {
            logger.debug((Object)("Connections: " + this.m_connections.size() + "   used: " + this.m_usedConnections.size() + "   free: " + this.m_availableConnections.size()));
            this.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseConnection(Connection connection) {
        LinkedList linkedList = this.m_connections;
        synchronized (linkedList) {
            logger.debug((Object)("Connections: " + this.m_connections.size() + "   used: " + this.m_usedConnections.size() + "   free: " + this.m_availableConnections.size()));
            if (this.m_connections.contains(connection)) {
                if (this.m_availableConnections.size() < this.m_databasePoolMaxFree) {
                    this.m_usedConnections.remove(connection);
                    this.m_availableConnections.add(connection);
                } else {
                    this.closeConnection(connection);
                }
            } else {
                this.closeConnection(connection);
            }
        }
    }

    private void initConnection(Connection connection) throws SQLException {
        connection.setAutoCommit(this.m_autocommit);
        if (this.m_isolationlevel != 0) {
            connection.setTransactionIsolation(this.m_isolationlevel);
        }
        for (int initialQueryIndex = 0; initialQueryIndex < this.m_initialQuery.length; ++initialQueryIndex) {
            String query = this.m_initialQuery[initialQueryIndex];
            Statement statement = connection.createStatement();
            statement.execute(query);
        }
    }

    private Connection obtainConnection() throws SQLException {
        LinkedList linkedList = this.m_connections;
        synchronized (linkedList) {
            logger.debug((Object)"================================= new connection =================================");
            if (this.m_dataSource != null) {
                Connection connection = this.m_dataSource.getConnection(this.m_databaseUser, this.m_databasePassword);
                this.initConnection(connection);
                return connection;
            }
            if (this.m_driver != null) {
                Connection connection = this.m_driver.connect(this.m_databaseUrlAssembled, this.m_databaseProperties);
                this.initConnection(connection);
                return connection;
            }
            throw new RuntimeException("Neither JNDI nor JDBC configured");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection provideConnection() throws SQLException {
        LinkedList linkedList = this.m_connections;
        synchronized (linkedList) {
            Connection connection;
            logger.debug((Object)("Connections: " + this.m_connections.size() + "   used: " + this.m_usedConnections.size() + "   free: " + this.m_availableConnections.size()));
            if (this.m_availableConnections.size() == 0) {
                if (this.m_usedConnections.size() >= this.m_databasePoolMax) {
                    logger.info((Object)"================================= close longest USED connection =================================");
                    this.closeConnection((Connection)this.m_usedConnections.getFirst());
                }
                connection = this.obtainConnection();
                this.m_connections.add(connection);
                this.m_preparedStatementCollectionMap.put(connection, new Vector());
            } else {
                Iterator availableConnectionsIterator = this.m_availableConnections.iterator();
                connection = (Connection)availableConnectionsIterator.next();
                availableConnectionsIterator.remove();
            }
            this.m_usedConnections.add(connection);
            return connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection provideTestedConnection() throws SQLException {
        LinkedList linkedList = this.m_connections;
        synchronized (linkedList) {
            Connection connection;
            logger.debug((Object)("Connections: " + this.m_connections.size() + "   used: " + this.m_usedConnections.size() + "   free: " + this.m_availableConnections.size()));
            while (this.m_availableConnections.size() > 0) {
                connection = this.provideConnection();
                try {
                    connection.setAutoCommit(!this.m_autocommit);
                    connection.setAutoCommit(this.m_autocommit);
                }
                catch (SQLException sqlException) {
                    this.releaseBadConnection(connection);
                    continue;
                }
                return connection;
            }
            connection = this.provideConnection();
            return connection;
        }
    }

    public boolean isLogged() {
        return this.m_databaseLog && logger.isInfoEnabled();
    }

    public void log(String string) {
        if (this.m_databaseLog && logger.isInfoEnabled()) {
            logger.info((Object)string);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

