/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.dataconnect;

import com.belenus.util.CharArray;
import com.belenus.util.StringUtil;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;

public class MethodFactory {
    private static final char[][][] ESCAPE_LIKE = new char[][][]{new char[][]{"\\".toCharArray(), "\\\\".toCharArray()}, new char[][]{"_".toCharArray(), "\\_".toCharArray()}, new char[][]{"%".toCharArray(), "\\%".toCharArray()}, new char[][]{"?".toCharArray(), "_".toCharArray()}, new char[][]{"*".toCharArray(), "%".toCharArray()}, new char[][]{"'".toCharArray(), "''".toCharArray()}};
    private static final char[][][] TEST_LIKE = new char[][][]{new char[][]{"\\*".toCharArray(), "X".toCharArray()}, new char[][]{"\\?".toCharArray(), "X".toCharArray()}};
    private Method[] m_methods = new Method[]{new LiteralMethod(), new StringMethod(), new MaskStringMethod(), new LikeMethod(), new NumberMethod(), new ChoiceMethod(), new DelimeteredStringMethod(), new DelimeteredLikeMethod(), new DelimeteredNumberMethod(), new SplitStringMethod(), new SplitNumberMethod(), new SplitChoiceMethod(), new SubStringMethod(), new SubChoiceMethod(), new IsLikeOrEqualMethod(), new XmlMethod()};
    private HashMap m_methodMap = new HashMap();

    public MethodFactory() {
        for (int methodsIndex = 0; methodsIndex < this.m_methods.length; ++methodsIndex) {
            Method method = this.m_methods[methodsIndex];
            this.m_methodMap.put(method.identifier(), method);
        }
    }

    public Method create(String methodIdentifier, Object[] input) {
        Method method = (Method)this.m_methodMap.get(methodIdentifier);
        if (method != null) {
            return method;
        }
        throw new IllegalArgumentException("Unknown Method: " + methodIdentifier);
    }

    static String getStringAtIndex(String parameter, String delimeter, String index) {
        String[] delimeteredRequest = StringUtil.split(parameter, delimeter);
        int indexInt = MethodFactory.getInteger(index, 0);
        if (indexInt >= 0 && indexInt < delimeteredRequest.length) {
            return delimeteredRequest[indexInt];
        }
        return "";
    }

    static String getString(Object input) {
        if (input != null) {
            return input.toString();
        }
        return "";
    }

    static int getInteger(String input, int defaultInteger) {
        if (input != null) {
            try {
                return Integer.parseInt(input);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultInteger;
    }

    static int bound(int value, int min, int max) {
        value = Math.max(value, min);
        value = Math.min(value, max);
        return value;
    }

    static String convertString(Object input) {
        return "'" + StringUtil.replaceAll(MethodFactory.getString(input), "'", "''") + "'";
    }

    static String convertLike(Object input) {
        return "'" + new String(CharArray.replaceAll(MethodFactory.getString(input).toCharArray(), ESCAPE_LIKE)) + "'";
    }

    static String convertNumber(Object input) {
        if ("".equals(MethodFactory.getString(input).trim())) {
            return "0";
        }
        BigDecimal bigDecimal = new BigDecimal(MethodFactory.getString(input).trim().replace(',', '.'));
        return bigDecimal.toString();
    }

    class XmlMethod
    implements Method {
        XmlMethod() {
        }

        public String identifier() {
            return "Xml";
        }

        private void test(Object[] input) {
            if (input.length != 1) {
                throw new IllegalArgumentException("Requires exactly one parameter: {Xml:parameter} - given " + input.length);
            }
        }

        public String applyDirectly(Object[] input) {
            this.test(input);
            if (input != null) {
                return StringUtil.encodeForSGML(MethodFactory.getString(input[0]));
            }
            return "";
        }

        public String preparePreparedStatement(Object[] input) {
            return this.applyDirectly(input);
        }

        public int applyPreparedStatement(PreparedStatement preparedStatement, int parameterIndex, Object[] input) {
            return parameterIndex;
        }
    }

    class IsLikeOrEqualMethod
    implements Method {
        IsLikeOrEqualMethod() {
        }

        public String identifier() {
            return "IsLikeOrEqual";
        }

        private void test(Object[] input) {
            if (input.length < 1 || input.length > 3) {
                throw new IllegalArgumentException("Requires one to three parameters: {IsLikeOrEqual:parameter[,prefix[,postfix]]} - given " + input.length);
            }
        }

        public String applyDirectly(Object[] input) {
            String test;
            this.test(input);
            String parameter = MethodFactory.getString(input[0]);
            String prefix = "";
            String postfix = "";
            if (input.length >= 2) {
                prefix = (String)input[1];
            }
            if (input.length == 3) {
                postfix = (String)input[2];
            }
            if ((test = new String(CharArray.replaceAll(parameter.toCharArray(), TEST_LIKE))).indexOf(63) == -1 && test.indexOf(42) == -1) {
                return "=" + prefix + MethodFactory.convertString(parameter) + postfix;
            }
            return " LIKE " + prefix + MethodFactory.convertLike(parameter) + postfix + " ESCAPE '\\' ";
        }

        public String preparePreparedStatement(Object[] input) {
            return this.applyDirectly(input);
        }

        public int applyPreparedStatement(PreparedStatement preparedStatement, int parameterIndex, Object[] input) {
            return parameterIndex;
        }
    }

    class SubChoiceMethod
    implements Method {
        SubChoiceMethod() {
        }

        public String identifier() {
            return "SubChoice";
        }

        private void test(Object[] input) {
            if (input.length <= 3) {
                throw new IllegalArgumentException("Requires four or more parameters: {SubChoice:paramter,startindex,endindex,choice1,choice2,choice3...} - given " + input.length);
            }
        }

        public String applyDirectly(Object[] input) {
            this.test(input);
            String parameter = MethodFactory.getString(input[0]);
            String startindex = MethodFactory.getString(input[1]);
            String endindex = MethodFactory.getString(input[2]);
            int start = MethodFactory.getInteger(startindex, 0);
            start = MethodFactory.bound(start, 0, parameter.length());
            int end = MethodFactory.getInteger(endindex, parameter.length());
            end = MethodFactory.bound(end, 0, parameter.length());
            String request = parameter.substring(start, end);
            for (int inputIndex = 1; inputIndex < input.length; ++inputIndex) {
                String choice = MethodFactory.getString(input[inputIndex]);
                if (!choice.equals(request)) continue;
                return choice;
            }
            throw new IllegalArgumentException("Not in choice: \"" + request + "\"");
        }

        public String preparePreparedStatement(Object[] input) {
            return this.applyDirectly(input);
        }

        public int applyPreparedStatement(PreparedStatement preparedStatement, int parameterIndex, Object[] input) {
            return parameterIndex;
        }
    }

    class SubStringMethod
    implements Method {
        SubStringMethod() {
        }

        public String identifier() {
            return "SubString";
        }

        private void test(Object[] input) {
            if (input.length != 2 && input.length != 3) {
                throw new IllegalArgumentException("Requires two or three parameters: {SubString:paramter,startindex[,endindex]} - given " + input.length);
            }
        }

        public String applyDirectly(Object[] input) {
            String request;
            this.test(input);
            String parameter = MethodFactory.getString(input[0]);
            String startindex = MethodFactory.getString(input[1]);
            if (input.length == 2) {
                request = parameter.substring(MethodFactory.getInteger(startindex, 0));
            } else {
                String endindex = MethodFactory.getString(input[2]);
                request = parameter.substring(MethodFactory.getInteger(startindex, 0), MethodFactory.getInteger(endindex, parameter.length()));
            }
            return MethodFactory.convertString(request);
        }

        public String preparePreparedStatement(Object[] input) {
            return this.applyDirectly(input);
        }

        public int applyPreparedStatement(PreparedStatement preparedStatement, int parameterIndex, Object[] input) {
            return parameterIndex;
        }
    }

    class SplitChoiceMethod
    implements Method {
        SplitChoiceMethod() {
        }

        public String identifier() {
            return "SplitChoice";
        }

        private void test(Object[] input) {
            if (input.length <= 3) {
                throw new IllegalArgumentException("Requires four or more parameters: {SplitChoice:paramter,delimeter,index,choice1,choice2,choice3...} - given " + input.length);
            }
        }

        public String applyDirectly(Object[] input) {
            this.test(input);
            String parameter = MethodFactory.getString(input[0]);
            String delimeter = MethodFactory.getString(input[1]);
            String index = MethodFactory.getString(input[0]);
            String request = MethodFactory.getStringAtIndex(parameter, delimeter, index);
            for (int inputIndex = 1; inputIndex < input.length; ++inputIndex) {
                String choice = MethodFactory.getString(input[inputIndex]);
                if (!choice.equals(request)) continue;
                return choice;
            }
            throw new IllegalArgumentException("Not in choice: \"" + request + "\"");
        }

        public String preparePreparedStatement(Object[] input) {
            return this.applyDirectly(input);
        }

        public int applyPreparedStatement(PreparedStatement preparedStatement, int parameterIndex, Object[] input) {
            return parameterIndex;
        }
    }

    class SplitNumberMethod
    implements Method {
        SplitNumberMethod() {
        }

        public String identifier() {
            return "SplitNumber";
        }

        private void test(Object[] input) {
            if (input.length != 3) {
                throw new IllegalArgumentException("Requires exactly three parameters: {SplitNumber:paramter,delimeter,index} - given " + input.length);
            }
        }

        public String applyDirectly(Object[] input) {
            this.test(input);
            String parameter = MethodFactory.getString(input[0]);
            String delimeter = MethodFactory.getString(input[1]);
            String index = MethodFactory.getString(input[2]);
            String request = MethodFactory.getStringAtIndex(parameter, delimeter, index);
            return MethodFactory.convertNumber(request);
        }

        public String preparePreparedStatement(Object[] input) {
            return this.applyDirectly(input);
        }

        public int applyPreparedStatement(PreparedStatement preparedStatement, int parameterIndex, Object[] input) {
            return parameterIndex;
        }
    }

    class SplitStringMethod
    implements Method {
        SplitStringMethod() {
        }

        public String identifier() {
            return "SplitString";
        }

        private void test(Object[] input) {
            if (input.length != 3) {
                throw new IllegalArgumentException("Requires exactly three parameters: {SplitString:paramter,delimeter,index} - given " + input.length);
            }
        }

        public String applyDirectly(Object[] input) {
            this.test(input);
            String parameter = MethodFactory.getString(input[0]);
            String delimeter = MethodFactory.getString(input[1]);
            String index = MethodFactory.getString(input[2]);
            String request = MethodFactory.getStringAtIndex(parameter, delimeter, index);
            return MethodFactory.convertString(request);
        }

        public String preparePreparedStatement(Object[] input) {
            return this.applyDirectly(input);
        }

        public int applyPreparedStatement(PreparedStatement preparedStatement, int parameterIndex, Object[] input) {
            return parameterIndex;
        }
    }

    class DelimeteredNumberMethod
    implements Method {
        DelimeteredNumberMethod() {
        }

        public String identifier() {
            return "DelimeteredNumber";
        }

        private void test(Object[] input) {
            if (input.length != 5) {
                throw new IllegalArgumentException("Requires exactly five parameters: {DelimeteredNumber:paramter,delimeter,leadin,connector,leadout} - given " + input.length);
            }
        }

        public String applyDirectly(Object[] input) {
            this.test(input);
            String parameter = MethodFactory.getString(input[0]);
            String delimeter = MethodFactory.getString(input[1]);
            String leadin = MethodFactory.getString(input[2]);
            String connector = MethodFactory.getString(input[3]);
            String leadout = MethodFactory.getString(input[4]);
            String[] splittedParameters = StringUtil.split(parameter, delimeter);
            String result = leadin;
            for (int splittedParametersIndex = 0; splittedParametersIndex < splittedParameters.length; ++splittedParametersIndex) {
                if (splittedParametersIndex > 0) {
                    result = result + connector;
                }
                String splittedParameter = splittedParameters[splittedParametersIndex];
                result = result + MethodFactory.convertNumber(splittedParameter);
            }
            result = result + leadout;
            return result;
        }

        public String preparePreparedStatement(Object[] input) {
            return this.applyDirectly(input);
        }

        public int applyPreparedStatement(PreparedStatement preparedStatement, int parameterIndex, Object[] input) {
            return parameterIndex;
        }
    }

    class DelimeteredLikeMethod
    implements Method {
        DelimeteredLikeMethod() {
        }

        public String identifier() {
            return "DelimeteredLike";
        }

        private void test(Object[] input) {
            if (input.length != 5) {
                throw new IllegalArgumentException("Requires exactly five parameters: {DelimeteredLike:paramter,delimeter,leadin,connector,leadout} - given " + input.length);
            }
        }

        public String applyDirectly(Object[] input) {
            this.test(input);
            String parameter = MethodFactory.getString(input[0]);
            String delimeter = MethodFactory.getString(input[1]);
            String leadin = MethodFactory.getString(input[2]);
            String connector = MethodFactory.getString(input[3]);
            String leadout = MethodFactory.getString(input[4]);
            String[] splittedParameters = StringUtil.split(parameter, delimeter);
            String result = leadin;
            for (int splittedParametersIndex = 0; splittedParametersIndex < splittedParameters.length; ++splittedParametersIndex) {
                if (splittedParametersIndex > 0) {
                    result = result + connector;
                }
                String splittedParameter = splittedParameters[splittedParametersIndex];
                result = result + MethodFactory.convertLike(splittedParameter);
            }
            result = result + leadout;
            return result;
        }

        public String preparePreparedStatement(Object[] input) {
            return this.applyDirectly(input);
        }

        public int applyPreparedStatement(PreparedStatement preparedStatement, int parameterIndex, Object[] input) {
            return parameterIndex;
        }
    }

    class DelimeteredStringMethod
    implements Method {
        DelimeteredStringMethod() {
        }

        public String identifier() {
            return "DelimeteredString";
        }

        private void test(Object[] input) {
            if (input.length != 5) {
                throw new IllegalArgumentException("Requires exactly five parameters: {DelimeteredString:paramter,delimeter,leadin,connector,leadout} - given " + input.length);
            }
        }

        public String applyDirectly(Object[] input) {
            this.test(input);
            String parameter = MethodFactory.getString(input[0]);
            String delimeter = MethodFactory.getString(input[1]);
            String leadin = MethodFactory.getString(input[2]);
            String connector = MethodFactory.getString(input[3]);
            String leadout = MethodFactory.getString(input[4]);
            String[] splittedParameters = StringUtil.split(parameter, delimeter);
            String result = leadin;
            for (int splittedParametersIndex = 0; splittedParametersIndex < splittedParameters.length; ++splittedParametersIndex) {
                if (splittedParametersIndex > 0) {
                    result = result + connector;
                }
                String splittedParameter = splittedParameters[splittedParametersIndex];
                result = result + MethodFactory.convertString(splittedParameter);
            }
            result = result + leadout;
            return result;
        }

        public String preparePreparedStatement(Object[] input) {
            return this.applyDirectly(input);
        }

        public int applyPreparedStatement(PreparedStatement preparedStatement, int parameterIndex, Object[] input) {
            return parameterIndex;
        }
    }

    class ChoiceMethod
    implements Method {
        ChoiceMethod() {
        }

        public String identifier() {
            return "Choice";
        }

        private void test(Object[] input) {
            if (input.length <= 1) {
                throw new IllegalArgumentException("Requires at least two parameters: {Choice:paramter,choice1,choice2,choice3...} - given " + input.length);
            }
        }

        public String applyDirectly(Object[] input) {
            String request = MethodFactory.getString(input[0]);
            for (int inputIndex = 1; inputIndex < input.length; ++inputIndex) {
                String choice = MethodFactory.getString(input[inputIndex]);
                if (!choice.equals(request)) continue;
                return choice;
            }
            throw new IllegalArgumentException("Not in choice: \"" + request + "\"");
        }

        public String preparePreparedStatement(Object[] input) {
            this.test(input);
            return this.applyDirectly(input);
        }

        public int applyPreparedStatement(PreparedStatement preparedStatement, int parameterIndex, Object[] input) {
            this.test(input);
            return parameterIndex;
        }
    }

    class NumberMethod
    implements Method {
        NumberMethod() {
        }

        public String identifier() {
            return "Number";
        }

        private void test(Object[] input) {
            if (input.length != 1) {
                throw new IllegalArgumentException("Requires exactly one parameter: {Number:parameter} - given " + input.length);
            }
        }

        public String applyDirectly(Object[] input) {
            this.test(input);
            return MethodFactory.convertNumber(input[0]);
        }

        public String preparePreparedStatement(Object[] input) {
            this.test(input);
            return "?";
        }

        public int applyPreparedStatement(PreparedStatement preparedStatement, int parameterIndex, Object[] input) throws SQLException {
            this.test(input);
            preparedStatement.setBigDecimal(parameterIndex, new BigDecimal(MethodFactory.convertNumber(input[0])));
            return parameterIndex + 1;
        }
    }

    class LikeMethod
    implements Method {
        LikeMethod() {
        }

        public String identifier() {
            return "Like";
        }

        private void test(Object[] input) {
            if (input.length != 1) {
                throw new IllegalArgumentException("Requires exactly one parameter: {Like:parameter} - given " + input.length);
            }
        }

        public String applyDirectly(Object[] input) {
            this.test(input);
            return MethodFactory.convertLike(input[0]);
        }

        public String preparePreparedStatement(Object[] input) {
            this.test(input);
            return "?";
        }

        public int applyPreparedStatement(PreparedStatement preparedStatement, int parameterIndex, Object[] input) throws SQLException {
            this.test(input);
            preparedStatement.setString(parameterIndex, new String(CharArray.replaceAll(MethodFactory.getString(input[0]).toCharArray(), ESCAPE_LIKE)));
            return parameterIndex + 1;
        }
    }

    class MaskStringMethod
    implements Method {
        MaskStringMethod() {
        }

        public String identifier() {
            return "MaskString";
        }

        private void test(Object[] input) throws IllegalArgumentException {
            if (input.length < 2) {
                throw new IllegalArgumentException("Requires two or more parameters: {MaskString:parameter,mask1,mask2,mask3...} - given " + input.length);
            }
        }

        public String applyDirectly(Object[] input) {
            this.test(input);
            String maskedValue = this.mask(input);
            return MethodFactory.convertString(maskedValue);
        }

        public String preparePreparedStatement(Object[] input) {
            this.test(input);
            return "?";
        }

        public int applyPreparedStatement(PreparedStatement preparedStatement, int parameterIndex, Object[] input) throws SQLException {
            this.test(input);
            String maskedValue = this.mask(input);
            preparedStatement.setString(parameterIndex, maskedValue);
            return parameterIndex + 1;
        }

        private String mask(Object[] input) {
            if (input[0] == null) {
                return "";
            }
            String value = MethodFactory.getString(input[0]);
            String maskedValue = "";
            block0: for (int valueIndex = 0; valueIndex < value.length(); ++valueIndex) {
                for (int inputIndex = 1; inputIndex < input.length; ++inputIndex) {
                    String valueSubstring;
                    String test = MethodFactory.getString(input[inputIndex]);
                    if ("".equals(test) || !(valueSubstring = value.substring(valueIndex, valueIndex + test.length())).equals(test)) continue;
                    maskedValue = maskedValue + valueSubstring;
                    valueIndex += valueSubstring.length() - 1;
                    continue block0;
                }
            }
            return maskedValue;
        }
    }

    class StringMethod
    implements Method {
        StringMethod() {
        }

        public String identifier() {
            return "String";
        }

        private void test(Object[] input) throws IllegalArgumentException {
            if (input.length != 1) {
                throw new IllegalArgumentException("Requires exactly one parameter: {String:parameter} - given " + input.length);
            }
        }

        public String applyDirectly(Object[] input) {
            this.test(input);
            return MethodFactory.convertString(input[0]);
        }

        public String preparePreparedStatement(Object[] input) {
            this.test(input);
            return "?";
        }

        public int applyPreparedStatement(PreparedStatement preparedStatement, int parameterIndex, Object[] input) throws SQLException {
            this.test(input);
            preparedStatement.setString(parameterIndex, MethodFactory.getString(input[0]));
            return parameterIndex + 1;
        }
    }

    class LiteralMethod
    implements Method {
        LiteralMethod() {
        }

        public String identifier() {
            return "Literal";
        }

        private void test(Object[] input) throws IllegalArgumentException {
            if (input.length != 1) {
                throw new IllegalArgumentException("Requires exactly one parameter: {Literal:parameter} - given " + input.length);
            }
        }

        public String applyDirectly(Object[] input) {
            this.test(input);
            return MethodFactory.getString(input[0]);
        }

        public String preparePreparedStatement(Object[] input) {
            return this.applyDirectly(input);
        }

        public int applyPreparedStatement(PreparedStatement preparedStatement, int parameterIndex, Object[] input) {
            this.test(input);
            return parameterIndex;
        }
    }

    public static interface Method {
        public String identifier();

        public String applyDirectly(Object[] var1);

        public String preparePreparedStatement(Object[] var1);

        public int applyPreparedStatement(PreparedStatement var1, int var2, Object[] var3) throws SQLException;
    }
}

