/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.dataconnect;

import com.belenus.dataconnect.Row;
import com.belenus.dataconnect.RowContainer;
import com.belenus.dataconnect.Template;
import com.belenus.util.CharArray;
import com.belenus.util.Configurator;
import com.belenus.util.StringUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class ParameterContainer {
    private static final Logger logger = Logger.getLogger((Class)(class$com$belenus$dataconnect$ParameterContainer == null ? (class$com$belenus$dataconnect$ParameterContainer = ParameterContainer.class$("com.belenus.dataconnect.ParameterContainer")) : class$com$belenus$dataconnect$ParameterContainer));
    private static final char[][][] UNESCAPE = new char[][][]{new char[][]{"^opencurl^".toCharArray(), "{".toCharArray()}, new char[][]{"^closecurl^".toCharArray(), "}".toCharArray()}, new char[][]{"^opensqare^".toCharArray(), "[".toCharArray()}, new char[][]{"^closesqare^".toCharArray(), "]".toCharArray()}, new char[][]{"^openround^".toCharArray(), "(".toCharArray()}, new char[][]{"^closeround^".toCharArray(), ")".toCharArray()}, new char[][]{"^slash^".toCharArray(), "/".toCharArray()}, new char[][]{"^backslash^".toCharArray(), "\\".toCharArray()}, new char[][]{"^space^".toCharArray(), " ".toCharArray()}, new char[][]{"^dot^".toCharArray(), ".".toCharArray()}, new char[][]{"^comma^".toCharArray(), ",".toCharArray()}, new char[][]{"^colon^".toCharArray(), ":".toCharArray()}, new char[][]{"^semicolon^".toCharArray(), ";".toCharArray()}, new char[][]{"^apos^".toCharArray(), "'".toCharArray()}, new char[][]{"^quot^".toCharArray(), "\"".toCharArray()}, new char[][]{"^circumflex^".toCharArray(), "^".toCharArray()}};
    private HttpServletRequest m_httpServletRequest;
    private Configurator m_configurator;
    private boolean m_utf8Request;
    static /* synthetic */ Class class$com$belenus$dataconnect$ParameterContainer;

    public ParameterContainer(HttpServletRequest httpServletRequest) {
        this(httpServletRequest, null, true);
    }

    public ParameterContainer(HttpServletRequest httpServletRequest, Configurator configurator) {
        this(httpServletRequest, configurator, configurator.getBoolean("utf8request", "true"));
    }

    public ParameterContainer(HttpServletRequest httpServletRequest, Configurator configurator, boolean utf8Request) {
        this.m_httpServletRequest = httpServletRequest;
        this.m_configurator = configurator;
        this.m_utf8Request = utf8Request;
    }

    public void setHttpServletRequest(HttpServletRequest httpServletRequest) {
        this.m_httpServletRequest = httpServletRequest;
    }

    public void setConfigurator(Configurator configurator) {
        this.m_configurator = configurator;
    }

    public void setUTF8Request(boolean utf8Request) {
        this.m_utf8Request = utf8Request;
    }

    public void clearResponderVariables() {
        ArrayList<String> responderAttributeNames = new ArrayList<String>();
        Enumeration attributeNamesEnumeration = this.m_httpServletRequest.getAttributeNames();
        while (attributeNamesEnumeration.hasMoreElements()) {
            String attributeName = (String)attributeNamesEnumeration.nextElement();
            if (!attributeName.startsWith("interpartsserver.responder.")) continue;
            responderAttributeNames.add(attributeName);
        }
        for (int responderAttributeNamesIndex = 0; responderAttributeNamesIndex < responderAttributeNames.size(); ++responderAttributeNamesIndex) {
            String attributeName = (String)responderAttributeNames.get(responderAttributeNamesIndex);
            this.m_httpServletRequest.removeAttribute(attributeName);
        }
    }

    public String getConfigVariable(String key) {
        if (this.m_configurator != null) {
            Object value = this.m_configurator.getObject(key);
            if (value != null) {
                String intermediateResult = value.toString();
                Template template = new Template(intermediateResult, this);
                return template.fill();
            }
            return null;
        }
        throw new RuntimeException("Configurator not set. Wrong constructor called.");
    }

    public String getResponderVariable(String key) {
        return (String)this.m_httpServletRequest.getAttribute("interpartsserver.responder." + key);
    }

    public void setResponderVariable(String key, String value) {
        if (value != null) {
            this.m_httpServletRequest.setAttribute("interpartsserver.responder." + key, (Object)value);
        } else {
            this.m_httpServletRequest.removeAttribute("interpartsserver.responder." + key);
        }
    }

    public void setResponderVariables(Row row) {
        RowContainer rowContainer = row.getRowContainer();
        String[] columnNames = rowContainer.getColumnNames();
        for (int columnNamesIndex = 0; columnNamesIndex < columnNames.length; ++columnNamesIndex) {
            String key = columnNames[columnNamesIndex];
            String value = row.getString(key);
            this.setResponderVariable(key, value);
        }
    }

    public String getFixedResponderVariable(String key) {
        return (String)this.m_httpServletRequest.getAttribute("interpartsserver.fixedresponder." + key);
    }

    public void setFixedResponderVariable(String key, String value) {
        if (value != null) {
            this.m_httpServletRequest.setAttribute("interpartsserver.fixedresponder." + key, (Object)value);
        } else {
            this.m_httpServletRequest.removeAttribute("interpartsserver.fixedresponder." + key);
        }
    }

    public void setFixedResponderVariables(Row row) {
        RowContainer rowContainer = row.getRowContainer();
        String[] columnNames = rowContainer.getColumnNames();
        for (int columnNamesIndex = 0; columnNamesIndex < columnNames.length; ++columnNamesIndex) {
            String key = columnNames[columnNamesIndex];
            String value = row.getString(key);
            this.setFixedResponderVariable(key, value);
        }
    }

    public void setRequestVariable(String key, String value) {
        if (value != null) {
            this.m_httpServletRequest.setAttribute("interpartsserver.request." + key, (Object)value);
        } else {
            this.m_httpServletRequest.removeAttribute("interpartsserver.request." + key);
        }
    }

    public String getRequestVariable(String key) {
        String value = this.m_httpServletRequest.getParameter(key);
        if (value != null) {
            logger.info((Object)("Request Variable " + key + ": " + StringUtil.asHex(value)));
            if (this.m_utf8Request) {
                value = StringUtil.decodeUTF8(value);
            }
        } else {
            value = (String)this.m_httpServletRequest.getAttribute("interpartsserver.request." + key);
        }
        return value;
    }

    public void setSessionVariable(String key, String value) {
        if (value != null) {
            this.m_httpServletRequest.getSession().setAttribute("interpartsserver." + key, (Object)value);
        } else {
            this.m_httpServletRequest.getSession().removeAttribute("interpartsserver." + key);
        }
    }

    public String getSessionVariable(String key) {
        return (String)this.m_httpServletRequest.getSession().getAttribute("interpartsserver." + key);
    }

    public String getClientSessionVariable(String key) {
        return (String)this.m_httpServletRequest.getSession().getAttribute("ip_" + key);
    }

    public void setClientSessionVariable(String key, String value) {
        if (value != null) {
            this.m_httpServletRequest.getSession().setAttribute("ip_" + key, (Object)value);
        } else {
            this.m_httpServletRequest.getSession().removeAttribute("ip_" + key);
        }
    }

    public String getParameter(String parameter) {
        String[] splittedParameter = StringUtil.splitInTwo(parameter, ".");
        String scope = splittedParameter[0];
        String variable = splittedParameter[1];
        if (scope != null && variable != null) {
            if ("Constant".equals(scope)) {
                return this.unescape(variable);
            }
            if ("Config".equals(scope)) {
                return this.getConfigVariable(variable);
            }
            if ("Session".equals(scope)) {
                return this.getSessionVariable(variable);
            }
            if ("ClientSession".equals(scope)) {
                return this.getClientSessionVariable(variable);
            }
            if ("Request".equals(scope)) {
                return this.getRequestVariable(variable);
            }
            if ("Responder".equals(scope)) {
                return this.getResponderVariable(variable);
            }
            if ("FixedResponder".equals(scope)) {
                return this.getFixedResponderVariable(variable);
            }
            throw new RuntimeException("Invalid parameter: " + parameter);
        }
        throw new RuntimeException("Invalid parameter: " + parameter);
    }

    private String unescape(String variable) {
        return new String(CharArray.replaceAll(variable.toCharArray(), UNESCAPE));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

