/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.dataconnect;

import com.belenus.dataconnect.RowContainer;
import java.util.Locale;

public class Row {
    Object[] m_fields;
    RowContainer m_rowContainer;
    RowContainer m_containingRowContainer;
    boolean m_skip;

    public Row(RowContainer rowContainer, Object[] fields) {
        this.m_rowContainer = rowContainer;
        this.m_fields = fields;
    }

    protected void setRowContainer(RowContainer rowContainer) {
        this.m_rowContainer = rowContainer;
    }

    public RowContainer getRowContainer() {
        return this.m_rowContainer;
    }

    public RowContainer getContainingRowContainer() {
        return this.m_containingRowContainer;
    }

    public void setContainingRowContainer(RowContainer rowContainer) {
        this.m_containingRowContainer = rowContainer;
        rowContainer.setSurroundingRow(this);
    }

    public String[] getFieldNames() {
        return this.m_rowContainer.getColumnNames();
    }

    public Object[] getFields() {
        return this.m_fields;
    }

    public int getFieldNameIndex(String fieldName) {
        String[] fieldNames = this.m_rowContainer.getColumnNames();
        fieldName = fieldName.toLowerCase();
        for (int fieldNamesIndex = 0; fieldNamesIndex < fieldNames.length; ++fieldNamesIndex) {
            if (!fieldNames[fieldNamesIndex].equals(fieldName)) continue;
            return fieldNamesIndex;
        }
        return -1;
    }

    private Object getObject(String fieldName) {
        int fieldNamesIndex = this.getFieldNameIndex(fieldName);
        if (fieldNamesIndex != -1) {
            return this.m_fields[fieldNamesIndex];
        }
        return null;
    }

    private Object getObject(String fieldName, Locale locale, boolean fallback) {
        int fieldNamesIndex;
        int localizedFieldNameIndex;
        String localizedFieldName = fieldName;
        if (locale != null) {
            String language = locale.getLanguage();
            String country = locale.getCountry();
            if (language != null) {
                localizedFieldName = localizedFieldName + "_" + language;
                if (country != null) {
                    localizedFieldName = localizedFieldName + country;
                }
            }
        }
        if ((localizedFieldNameIndex = this.getFieldNameIndex(localizedFieldName)) != -1) {
            return this.m_fields[localizedFieldNameIndex];
        }
        if (fallback && (fieldNamesIndex = this.getFieldNameIndex(fieldName)) != -1) {
            return this.m_fields[fieldNamesIndex];
        }
        return null;
    }

    public String getString(String fieldName) {
        Object object = this.getObject(fieldName);
        if (object != null) {
            return object.toString().trim();
        }
        return "";
    }

    public String getString(String fieldName, Locale locale, boolean fallback) {
        Object object = this.getObject(fieldName, locale, fallback);
        if (object != null) {
            return object.toString().trim();
        }
        return "";
    }

    public void setSkip(boolean skip) {
        this.m_skip = skip;
    }

    public boolean getSkip() {
        return this.m_skip;
    }

    public String toString() {
        String[] columnNames = this.m_rowContainer.getColumnNames();
        StringBuffer result = new StringBuffer();
        result.append("Row[");
        for (int fieldsIndex = 0; fieldsIndex < this.m_fields.length; ++fieldsIndex) {
            if (fieldsIndex > 0) {
                result.append(", ");
            }
            result.append(columnNames[fieldsIndex]).append(":").append(String.valueOf(this.m_fields[fieldsIndex]));
        }
        result.append("]");
        return result.toString();
    }
}

