/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.dataconnect;

import com.belenus.dataconnect.AbstractRowContainer;
import com.belenus.dataconnect.DatabaseManager;
import com.belenus.dataconnect.LiberatedResultSetRowContainer;
import com.belenus.dataconnect.ListRowContainer;
import com.belenus.dataconnect.ParameterContainer;
import com.belenus.dataconnect.RecursiveRowContainer;
import com.belenus.dataconnect.ResultSetRowContainer;
import com.belenus.dataconnect.ReverseRowContainer;
import com.belenus.dataconnect.Row;
import com.belenus.dataconnect.RowContainer;
import com.belenus.dataconnect.Template;
import java.util.ArrayList;

public class SearchResultContainer {
    private DatabaseManager m_databaseManager;
    private ParameterContainer m_parameterContainer;
    private boolean m_recursiveTree;
    private boolean m_reverseTree;
    private int m_maxRows;
    private boolean m_countResults;
    private String[] m_queryNames;
    private String[] m_queryTemplates;
    private String[] m_toPathQueryTemplates;
    private String[] m_actualPathQueryTemplates;
    private RowContainer[] m_resultRowContainers;
    private ArrayList[] m_toPathRowContainerLists;
    private RowContainer[] m_tabledefRowContainers;
    private int m_queryIndex;
    private int m_resultIndex;
    private int m_toPathIndex;
    private int m_queryStart;
    private int m_resultStart;
    private int m_toPathStart;
    private int m_resultCount = -1;
    private boolean m_resultContinuesAfterLast;
    private RowContainer m_currentResultRowContainer;
    private RowContainer m_currentToPathRowContainer;

    public SearchResultContainer(DatabaseManager databaseManager, ParameterContainer parameterContainer, String[] queryNames, String[] queryTemplates, String[] toPathQueryTemplates, String[] actualPathQueryTemplates, String[] tabledefTemplates, boolean recursiveTree, boolean reverseTree, int maxRows, boolean countResults) {
        this.m_databaseManager = databaseManager;
        this.m_parameterContainer = parameterContainer;
        this.m_recursiveTree = recursiveTree;
        this.m_reverseTree = reverseTree;
        this.m_maxRows = maxRows;
        this.m_countResults = countResults;
        this.m_queryNames = queryNames;
        this.m_queryTemplates = queryTemplates;
        this.m_toPathQueryTemplates = toPathQueryTemplates;
        this.m_actualPathQueryTemplates = actualPathQueryTemplates;
        this.m_resultRowContainers = new RowContainer[queryTemplates.length];
        this.m_toPathRowContainerLists = new ArrayList[queryTemplates.length];
        for (int queryTemplatesIndex = 0; queryTemplatesIndex < queryTemplates.length; ++queryTemplatesIndex) {
            this.m_toPathRowContainerLists[queryTemplatesIndex] = new ArrayList();
        }
        this.m_tabledefRowContainers = new RowContainer[tabledefTemplates.length];
        for (int tabledefTemplatesIndex = 0; tabledefTemplatesIndex < tabledefTemplates.length; ++tabledefTemplatesIndex) {
            String tabledefTemplate = tabledefTemplates[tabledefTemplatesIndex];
            if (tabledefTemplate == null) continue;
            this.m_tabledefRowContainers[tabledefTemplatesIndex] = new ResultSetRowContainer(this.m_databaseManager, new Template(tabledefTemplate, this.m_parameterContainer));
        }
        this.set(0, 0, 0);
        this.currentToPathWithOverflow();
        this.m_queryStart = this.m_queryIndex;
        this.m_resultStart = this.m_resultIndex;
        this.m_toPathStart = this.m_toPathIndex;
    }

    public synchronized void setParameterContainer(ParameterContainer parameterContainer) {
        this.m_parameterContainer = parameterContainer;
    }

    public synchronized void set(int newQueryIndex, int newResultIndex, int newToPathIndex) {
        if (newQueryIndex < 0 || newQueryIndex >= this.m_queryTemplates.length) {
            throw new IllegalArgumentException("New query index out of bounds");
        }
        this.m_queryIndex = newQueryIndex;
        this.m_currentResultRowContainer = this.m_resultRowContainers[this.m_queryIndex];
        if (this.m_currentResultRowContainer == null) {
            this.m_currentResultRowContainer = this.m_countResults ? new ResultSetRowContainer(this.m_databaseManager, new Template(this.m_queryTemplates[this.m_queryIndex], this.m_parameterContainer), this.m_maxRows) : new LiberatedResultSetRowContainer(this.m_databaseManager, new Template(this.m_queryTemplates[this.m_queryIndex], this.m_parameterContainer), this.m_maxRows);
            this.m_resultRowContainers[this.m_queryIndex] = this.m_currentResultRowContainer;
        }
        if (this.m_currentResultRowContainer.isEmpty()) {
            ListRowContainer arrayListRowContainer = new ListRowContainer(new String[]{"id_id_device", "id_parent", "id_object"});
            this.m_currentToPathRowContainer = arrayListRowContainer;
            this.m_resultIndex = -1;
            this.m_toPathIndex = -1;
        } else {
            this.m_currentResultRowContainer.setPosition(newResultIndex);
            this.m_resultIndex = this.m_currentResultRowContainer.getPosition();
            Row row = this.m_currentResultRowContainer.currentRow();
            this.m_parameterContainer.setResponderVariables(row);
            String id_device = row.getString("id_device");
            String id_parent = row.getString("id_parent");
            String id_object = row.getString("id_object");
            ArrayList toPathRowContainerList = this.m_toPathRowContainerLists[this.m_queryIndex];
            while (toPathRowContainerList.size() <= this.m_resultIndex) {
                toPathRowContainerList.add(null);
            }
            this.m_currentToPathRowContainer = (RowContainer)toPathRowContainerList.get(this.m_resultIndex);
            if (this.m_currentToPathRowContainer == null) {
                ListRowContainer arrayListRowContainer;
                String toPathQueryTemplate = this.m_toPathQueryTemplates[this.m_queryIndex];
                if (toPathQueryTemplate == null || toPathQueryTemplate.trim().equals("")) {
                    arrayListRowContainer = new ListRowContainer(new String[]{"id_device", "id_parent", "id_object"});
                    arrayListRowContainer.addRow(new Row(arrayListRowContainer, new Object[]{id_device, id_parent, id_object}));
                    this.m_currentToPathRowContainer = arrayListRowContainer;
                } else {
                    this.m_currentToPathRowContainer = new ResultSetRowContainer(this.m_databaseManager, new Template(toPathQueryTemplate, this.m_parameterContainer));
                    if (this.m_currentToPathRowContainer.isEmpty()) {
                        arrayListRowContainer = new ListRowContainer(new String[]{"id_device", "id_parent", "id_object"});
                        arrayListRowContainer.addRow(new Row(arrayListRowContainer, new Object[]{null, null, id_object}));
                        this.m_currentToPathRowContainer = arrayListRowContainer;
                    }
                }
                toPathRowContainerList.set(this.m_resultIndex, this.m_currentToPathRowContainer);
            }
            this.m_currentToPathRowContainer.setPosition(newToPathIndex);
            this.m_toPathIndex = this.m_currentToPathRowContainer.getPosition();
            Row currentToPathRow = this.m_currentToPathRowContainer.currentRow();
            if (currentToPathRow.getContainingRowContainer() == null) {
                this.m_parameterContainer.setResponderVariables(currentToPathRow);
                this.m_parameterContainer.setResponderVariable("pathdepth", "0");
                this.m_parameterContainer.setResponderVariable("id_found", "");
                String actualPathQueryTemplate = this.m_actualPathQueryTemplates[this.m_queryIndex];
                if (actualPathQueryTemplate == null || actualPathQueryTemplate.trim().equals("")) {
                    ListRowContainer listRowContainer = new ListRowContainer(new String[]{"id_device", "id_parent", "id_object"});
                    currentToPathRow.setContainingRowContainer(listRowContainer);
                } else {
                    Template template = new Template(actualPathQueryTemplate, this.m_parameterContainer);
                    AbstractRowContainer abstractRowContainer = this.m_recursiveTree ? new RecursiveRowContainer(this.m_databaseManager, template) : new ResultSetRowContainer(this.m_databaseManager, template);
                    if (this.m_reverseTree) {
                        abstractRowContainer = new ReverseRowContainer(abstractRowContainer);
                    }
                    currentToPathRow.setContainingRowContainer(abstractRowContainer);
                }
            }
        }
    }

    public synchronized void destroy() {
        for (int resultRowContainersIndex = 0; resultRowContainersIndex < this.m_resultRowContainers.length; ++resultRowContainersIndex) {
            RowContainer rowContainer = this.m_resultRowContainers[resultRowContainersIndex];
            if (rowContainer == null) continue;
            rowContainer.destroy();
            this.m_resultRowContainers[resultRowContainersIndex] = null;
        }
        for (int toPathRowContainerListsIndex = 0; toPathRowContainerListsIndex < this.m_toPathRowContainerLists.length; ++toPathRowContainerListsIndex) {
            ArrayList toPathRowContainerList = this.m_toPathRowContainerLists[toPathRowContainerListsIndex];
            if (toPathRowContainerList == null) continue;
            for (int listIndex = 0; listIndex < toPathRowContainerList.size(); ++listIndex) {
                RowContainer rowContainer = (RowContainer)toPathRowContainerList.get(listIndex);
                if (rowContainer == null) continue;
                rowContainer.destroy();
                toPathRowContainerList.set(listIndex, null);
            }
            this.m_toPathRowContainerLists[toPathRowContainerListsIndex] = null;
        }
    }

    public synchronized String toString() {
        return "SearchResultContainer position: " + this.currentQueryIndex() + " " + this.currentResultIndex() + " " + this.currentToPathIndex();
    }

    public synchronized boolean hasPreviousToPath() {
        return this.m_currentToPathRowContainer.hasPrevious();
    }

    public synchronized Row previousToPath() {
        if (this.m_currentToPathRowContainer.hasPrevious()) {
            this.set(this.m_queryIndex, this.m_resultIndex, this.m_toPathIndex - 1);
            return this.m_currentToPathRowContainer.currentRow();
        }
        return null;
    }

    public synchronized Row previousToPathWithOverflow() {
        if (this.isAtStart()) {
            return null;
        }
        if (this.hasPreviousToPath()) {
            return this.previousToPath();
        }
        this.previousResultWithOverflow();
        this.m_currentToPathRowContainer.setToEnd();
        this.m_toPathIndex = this.m_currentToPathRowContainer.getPosition();
        this.set(this.m_queryIndex, this.m_resultIndex, this.m_toPathIndex);
        return this.m_currentToPathRowContainer.currentRow();
    }

    public synchronized int currentToPathIndex() {
        return this.m_toPathIndex;
    }

    public synchronized Row currentToPath() {
        if (!this.m_currentToPathRowContainer.isEmpty()) {
            return this.m_currentToPathRowContainer.currentRow();
        }
        return null;
    }

    public synchronized boolean hasNextToPath() {
        return this.m_currentToPathRowContainer.hasNext();
    }

    public synchronized Row nextToPath() {
        if (this.m_currentToPathRowContainer.hasNext()) {
            this.set(this.m_queryIndex, this.m_resultIndex, this.m_toPathIndex + 1);
            return this.m_currentToPathRowContainer.currentRow();
        }
        return null;
    }

    public synchronized Row nextToPathWithOverflow() {
        if (this.checkEnd()) {
            return null;
        }
        if (this.hasNextToPath()) {
            return this.nextToPath();
        }
        this.nextResultWithOverflow();
        this.m_currentToPathRowContainer.resetPosition();
        if (this.m_currentToPathRowContainer.hasNext()) {
            this.set(this.m_queryIndex, this.m_resultIndex, 0);
            return this.m_currentToPathRowContainer.currentRow();
        }
        return null;
    }

    public synchronized Row currentToPathWithOverflow() {
        if (!this.m_currentToPathRowContainer.isEmpty()) {
            return this.currentToPath();
        }
        this.currentResultWithOverflow();
        return this.currentToPath();
    }

    public synchronized boolean hasNextToPathWithOverflow() {
        if (this.checkEnd()) {
            return false;
        }
        if (this.hasNextToPath()) {
            return true;
        }
        return this.hasNextResultWithOverflow();
    }

    public synchronized boolean hasPreviousResult() {
        return this.m_currentResultRowContainer.hasPrevious();
    }

    public synchronized Row previousResult() {
        if (this.m_currentResultRowContainer.hasPrevious()) {
            this.set(this.m_queryIndex, this.m_resultIndex - 1, 0);
            return this.m_currentResultRowContainer.currentRow();
        }
        return null;
    }

    public synchronized Row previousResultWithOverflow() {
        if (this.isAtStart()) {
            return null;
        }
        if (this.hasPreviousResult()) {
            return this.previousResult();
        }
        this.previousQuery();
        this.m_currentResultRowContainer.setToEnd();
        this.m_resultIndex = this.m_currentResultRowContainer.getPosition();
        this.set(this.m_queryIndex, this.m_resultIndex, 0);
        return this.m_currentToPathRowContainer.currentRow();
    }

    public synchronized int currentResultIndex() {
        return this.m_resultIndex;
    }

    public synchronized Row currentResult() {
        if (!this.m_currentResultRowContainer.isEmpty()) {
            return this.m_currentResultRowContainer.currentRow();
        }
        return null;
    }

    public synchronized boolean hasNextResult() {
        return this.m_currentResultRowContainer.hasNext();
    }

    private synchronized boolean continuesAfterLastResult() {
        return this.m_currentResultRowContainer.resultContinuesAfterLast();
    }

    public synchronized Row nextResult() {
        if (this.m_currentResultRowContainer.hasNext()) {
            this.set(this.m_queryIndex, this.m_resultIndex + 1, 0);
            return this.m_currentResultRowContainer.currentRow();
        }
        return null;
    }

    public synchronized Row nextResultWithOverflow() {
        if (this.checkEnd()) {
            return null;
        }
        if (this.hasNextResult()) {
            return this.nextResult();
        }
        while (this.hasNextQuery()) {
            this.nextQuery();
            this.m_currentResultRowContainer.resetPosition();
            if (!this.m_currentResultRowContainer.hasNext()) continue;
            this.set(this.m_queryIndex, 0, 0);
            return this.m_currentToPathRowContainer.currentRow();
        }
        return null;
    }

    public synchronized Row currentResultWithOverflow() {
        if (!this.m_currentResultRowContainer.isEmpty()) {
            return this.currentResult();
        }
        while (this.hasNextQuery()) {
            this.nextQuery();
            if (this.m_currentResultRowContainer.isEmpty()) continue;
            return this.currentResult();
        }
        return null;
    }

    public synchronized boolean hasNextResultWithOverflow() {
        if (this.checkEnd()) {
            return false;
        }
        if (this.hasNextResult()) {
            return true;
        }
        int currentQueryIndex = this.m_queryIndex;
        int currentResultIndex = this.m_resultIndex;
        int currentToPathIndex = this.m_toPathIndex;
        while (this.hasNextQuery()) {
            this.nextQuery();
            if (this.m_currentResultRowContainer.isEmpty()) continue;
            this.set(currentQueryIndex, currentResultIndex, currentToPathIndex);
            return true;
        }
        this.set(currentQueryIndex, currentResultIndex, currentToPathIndex);
        return false;
    }

    public synchronized boolean hasPreviousQuery() {
        return this.m_queryIndex > 0;
    }

    public synchronized void previousQuery() {
        if (this.m_queryIndex > 0) {
            this.set(this.m_queryIndex - 1, 0, 0);
        }
    }

    public synchronized int currentQueryIndex() {
        return this.m_queryIndex;
    }

    public synchronized boolean hasNextQuery() {
        return this.m_queryIndex < this.m_queryTemplates.length - 1;
    }

    public synchronized void nextQuery() {
        if (this.m_queryIndex < this.m_queryTemplates.length - 1) {
            this.set(this.m_queryIndex + 1, 0, 0);
        }
    }

    public String currentQueryName() {
        return this.m_queryNames[this.m_queryIndex];
    }

    private void resultCountHelper() {
        if (this.m_resultCount == -1) {
            this.m_resultContinuesAfterLast = false;
            this.m_resultCount = 0;
            int currentQueryIndex = this.m_queryIndex;
            int currentResultIndex = this.m_resultIndex;
            int currentToPathIndex = this.m_toPathIndex;
            this.set(0, 0, 0);
            while (this.hasNextQuery()) {
                this.nextQuery();
            }
            for (int resultRowContainersIndex = 0; resultRowContainersIndex < this.m_resultRowContainers.length; ++resultRowContainersIndex) {
                this.m_resultCount += this.m_resultRowContainers[resultRowContainersIndex].resultCount();
                this.m_resultContinuesAfterLast |= this.m_resultRowContainers[resultRowContainersIndex].resultContinuesAfterLast();
            }
            this.set(currentQueryIndex, currentResultIndex, currentToPathIndex);
        }
    }

    public int resultCount() {
        this.resultCountHelper();
        return this.m_resultCount;
    }

    public boolean resultContinuesAfterLast() {
        this.resultCountHelper();
        return this.m_resultContinuesAfterLast;
    }

    private boolean checkEnd() {
        return !this.hasNextQuery() && !this.hasNextResult() && !this.hasNextToPath();
    }

    public synchronized boolean isAtStart() {
        return this.m_queryIndex <= this.m_queryStart && this.m_resultIndex <= this.m_resultStart && this.m_toPathIndex <= this.m_toPathStart;
    }

    public synchronized boolean isEmpty() {
        return this.isAtStart() && this.currentToPathWithOverflow() == null;
    }

    public synchronized boolean continuesFromHere() {
        return this.checkEnd() && this.continuesAfterLastResult();
    }

    public synchronized RowContainer currentTabledef() {
        return this.m_tabledefRowContainers[this.m_queryIndex];
    }
}

