/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.dataconnect;

import com.belenus.dataconnect.DatabaseManager;
import com.belenus.dataconnect.TransactionException;
import java.sql.Connection;
import java.sql.SQLException;

class Transaction {
    Connection currentConnection;
    DatabaseManager databaseManager;

    Transaction(DatabaseManager databaseManager) {
        this.databaseManager = databaseManager;
    }

    private void finish(Connection connection) throws TransactionException {
        try {
            connection.commit();
        }
        catch (SQLException sqlException) {
            throw new TransactionException("Cannot finish connection (cannot commit to database): " + sqlException.getMessage(), sqlException);
        }
        finally {
            this.databaseManager.releaseConnection(connection);
        }
    }

    private void abort(Connection connection) throws TransactionException {
        try {
            connection.rollback();
        }
        catch (SQLException sqlException) {
            throw new TransactionException("Cannot finish connection (cannot rollback from database): " + sqlException.getMessage(), sqlException);
        }
        finally {
            this.databaseManager.releaseBadConnection(connection);
        }
    }

    void finish() throws TransactionException {
        if (this.currentConnection != null) {
            this.finish(this.currentConnection);
            this.currentConnection = null;
        }
    }

    void abort() throws TransactionException {
        if (this.currentConnection != null) {
            this.abort(this.currentConnection);
            this.currentConnection = null;
        }
    }

    Connection getConnection() throws TransactionException {
        try {
            if (this.currentConnection == null) {
                this.currentConnection = this.databaseManager.provideConnection();
            }
            return this.currentConnection;
        }
        catch (SQLException sqlException) {
            throw new TransactionException("Cannot get connection (cannot connect to database): " + sqlException.getMessage(), sqlException);
        }
    }

    void refreshConnection() throws TransactionException {
        if (this.currentConnection == null) {
            throw new TransactionException("Connection not started");
        }
        this.databaseManager.releaseBadConnection(this.currentConnection);
        try {
            this.currentConnection = this.databaseManager.provideTestedConnection();
        }
        catch (SQLException sqlException) {
            throw new TransactionException("Cannot refresh connection (cannot connect to database): " + sqlException.getMessage(), sqlException);
        }
    }
}

