/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.interpartsserver3;

import com.belenus.dataconnect.Row;
import com.belenus.interpartsserver3.Note;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;

public class FileNote
extends Note {
    private static final Logger logger = Logger.getLogger((Class)(class$com$belenus$interpartsserver3$FileNote == null ? (class$com$belenus$interpartsserver3$FileNote = FileNote.class$("com.belenus.interpartsserver3.FileNote")) : class$com$belenus$interpartsserver3$FileNote));
    private File m_file;
    static /* synthetic */ Class class$com$belenus$interpartsserver3$FileNote;

    protected void validateIds() {
        if (this.m_idNote == null || this.m_idObject == null) {
            throw new RuntimeException("Invalid IDs for note.");
        }
        if (this.m_idNote.indexOf(47) != -1 || this.m_idNote.indexOf(92) != -1) {
            throw new RuntimeException("Invalid IDs for note.");
        }
        if (this.m_idObject.indexOf(47) != -1 || this.m_idObject.indexOf(92) != -1) {
            throw new RuntimeException("Invalid IDs for note.");
        }
        if (!this.m_idNote.equals("note_" + this.m_idObject)) {
            throw new RuntimeException("Invalid IDs for note.");
        }
    }

    FileNote(File noteFile) {
        this.m_file = noteFile;
        String fileName = this.m_file.getName();
        if (!fileName.startsWith("note_") || !fileName.endsWith(".xml")) {
            throw new RuntimeException("Invalid file name for note: " + fileName);
        }
        this.m_idNote = fileName.substring(0, fileName.length() - ".xml".length());
        this.m_idObject = this.m_idNote.substring("note_".length());
        this.validateIds();
    }

    FileNote(Row row, File notesDirectory) {
        super(row);
        this.m_file = new File(notesDirectory, this.m_idNote + ".xml");
        this.persist();
    }

    File getFile() {
        return this.m_file;
    }

    public Row getRow() {
        if (this.m_row == null) {
            this.materialize();
        }
        return super.getRow();
    }

    void setRow(Row row) {
        super.setRow(row);
        this.persist();
    }

    private void materialize() {
        try {
            this.m_row = EMPTY_ROW;
            if (this.m_file != null) {
                FileInputStream fileInputStream = new FileInputStream(this.m_file);
                this.parseXML(fileInputStream);
            }
        }
        catch (IOException ioException) {
            logger.error((Object)("Cannot read file " + this.m_file));
        }
        catch (DocumentException documentException) {
            logger.error((Object)"Incorrect format of note.");
        }
        catch (RuntimeException runtimeException) {
            logger.error((Object)"Incorrect format of note.");
        }
        this.validateIds();
    }

    private void persist() {
        this.validateIds();
        try {
            if (this.m_file != null) {
                FileOutputStream fileOutputStream = new FileOutputStream(this.m_file);
                this.buildXML(fileOutputStream);
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

