/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.interpartsserver3;

import com.belenus.dataconnect.ListRowContainer;
import com.belenus.dataconnect.Row;
import com.belenus.interpartsserver3.FileNote;
import com.belenus.interpartsserver3.Note;
import com.belenus.interpartsserver3.NoteStorage;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;

public class FileNoteStorage
implements NoteStorage {
    private File m_notesDirectory;
    private Hashtable m_fileNoteMapByIdNote = new Hashtable();
    private Hashtable m_fileNoteMapByIdObject = new Hashtable();
    public static final int SET = 0;
    public static final int EXACT = 1;
    public static final int EXACT_IGNORECASE = 2;
    public static final int SUBSTRING = 3;
    public static final int SUBSTRING_IGNORECASE = 4;

    public FileNoteStorage(File notesDirectory) {
        this.m_notesDirectory = notesDirectory;
        if (!this.m_notesDirectory.isDirectory()) {
            this.m_notesDirectory.mkdirs();
        }
        File[] files = this.m_notesDirectory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        });
        for (int filesIndex = 0; filesIndex < files.length; ++filesIndex) {
            FileNote fileNote = new FileNote(files[filesIndex]);
            this.m_fileNoteMapByIdNote.put(fileNote.getIdNote(), fileNote);
            this.m_fileNoteMapByIdObject.put(fileNote.getIdObject(), fileNote);
        }
    }

    public FileNote getFileNoteByIdNote(String idNote) {
        if (idNote != null) {
            return (FileNote)this.m_fileNoteMapByIdNote.get(idNote);
        }
        return null;
    }

    public FileNote getFileNoteByIdObject(String idObject) {
        if (idObject != null) {
            return (FileNote)this.m_fileNoteMapByIdObject.get(idObject);
        }
        return null;
    }

    private FileNote createFileNote(Row row) {
        FileNote fileNote = new FileNote(row, this.m_notesDirectory);
        this.m_fileNoteMapByIdNote.put(fileNote.getIdNote(), fileNote);
        this.m_fileNoteMapByIdObject.put(fileNote.getIdObject(), fileNote);
        return fileNote;
    }

    private void deleteFileNoteByIdNote(String idNote) {
        FileNote fileNote = (FileNote)this.m_fileNoteMapByIdNote.get(idNote);
        this.m_fileNoteMapByIdNote.remove(fileNote.getIdNote());
        this.m_fileNoteMapByIdObject.remove(fileNote.getIdObject());
        File file = fileNote.getFile();
        file.delete();
    }

    private void deleteFileNoteByIdObject(String idObject) {
        FileNote fileNote = (FileNote)this.m_fileNoteMapByIdObject.get(idObject);
        this.m_fileNoteMapByIdNote.remove(fileNote.getIdNote());
        this.m_fileNoteMapByIdObject.remove(fileNote.getIdObject());
        File file = fileNote.getFile();
        file.delete();
    }

    private FileNote modifyFileNoteByIdNote(String idNote, Row row) {
        FileNote fileNote = (FileNote)this.m_fileNoteMapByIdNote.get(idNote);
        fileNote.setRow(row);
        return fileNote;
    }

    private FileNote modifyFileNoteByIdObject(String idObject, Row row) {
        FileNote fileNote = (FileNote)this.m_fileNoteMapByIdObject.get(idObject);
        fileNote.setRow(row);
        return fileNote;
    }

    private ArrayList findFileNotes(String fieldName, String searchValue, int searchMode) {
        ArrayList<FileNote> result = new ArrayList<FileNote>();
        Iterator fileNoteMapByIdNoteKeysIterator = this.m_fileNoteMapByIdNote.keySet().iterator();
        while (fileNoteMapByIdNoteKeysIterator.hasNext()) {
            String value;
            String idNote = (String)fileNoteMapByIdNoteKeysIterator.next();
            FileNote fileNote = (FileNote)this.m_fileNoteMapByIdNote.get(idNote);
            Row row = fileNote.getRow();
            if (row.getFieldNameIndex(fieldName) == -1 || (value = row.getString(fieldName)) == null) continue;
            if (searchMode == 0) {
                result.add(fileNote);
                continue;
            }
            if (searchMode == 1 && value.equals(searchValue)) {
                result.add(fileNote);
                continue;
            }
            if (searchMode == 2 && value.toLowerCase().equals(searchValue.toLowerCase())) {
                result.add(fileNote);
                continue;
            }
            if (searchMode == 3 && value.indexOf(searchValue) != -1) {
                result.add(fileNote);
                continue;
            }
            if (searchMode != 3 || value.toLowerCase().indexOf(searchValue.toLowerCase()) == -1) continue;
            result.add(fileNote);
        }
        return result;
    }

    private Note getFileNoteFromRequest(HttpServletRequest httpServletRequest) {
        String idNote = httpServletRequest.getParameter("id_note");
        String idObject = httpServletRequest.getParameter("id_object");
        FileNote fileNote = this.getFileNoteByIdNote(idNote);
        if (fileNote == null) {
            fileNote = this.getFileNoteByIdObject(idObject);
        }
        return fileNote;
    }

    public Note retrieveNote(HttpServletRequest httpServletRequest) {
        Note fileNote = this.getFileNoteFromRequest(httpServletRequest);
        if (fileNote != null) {
            return fileNote;
        }
        return Note.EMPTY_FILE_NOTE;
    }

    public Note storeNote(HttpServletRequest httpServletRequest) {
        Note fileNote = this.getFileNoteFromRequest(httpServletRequest);
        Enumeration parameterNamesEnumeration = httpServletRequest.getParameterNames();
        ArrayList<String> fieldNameList = new ArrayList<String>();
        ArrayList<String> valuesList = new ArrayList<String>();
        while (parameterNamesEnumeration.hasMoreElements()) {
            String fieldName = (String)parameterNamesEnumeration.nextElement();
            String value = httpServletRequest.getParameter(fieldName);
            fieldNameList.add(fieldName);
            valuesList.add(value);
        }
        String[] fieldNames = fieldNameList.toArray(new String[fieldNameList.size()]);
        Object[] values = valuesList.toArray(new String[fieldNames.length]);
        ListRowContainer listRowContainer = new ListRowContainer(fieldNames);
        Row row = new Row(listRowContainer, values);
        if (fileNote == null) {
            this.createFileNote(row);
        } else {
            this.modifyFileNoteByIdNote(fileNote.getIdNote(), row);
        }
        return this.retrieveNote(httpServletRequest);
    }

    public Note removeNote(HttpServletRequest httpServletRequest) {
        Note fileNote = this.getFileNoteFromRequest(httpServletRequest);
        if (fileNote != null) {
            this.deleteFileNoteByIdNote(fileNote.getIdNote());
        }
        return this.retrieveNote(httpServletRequest);
    }
}

