/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.interpartsserver3;

import com.belenus.dataconnect.Row;
import com.belenus.dataconnect.RowContainer;
import com.belenus.interpartsserver3.InterpartsServer;
import com.belenus.interpartsserver3.SearchResponder;
import com.belenus.interpartsserver3.Server;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class SearchCsvResponder
extends SearchResponder {
    private static final Logger logger = Logger.getLogger((Class)(class$com$belenus$interpartsserver3$SearchCsvResponder == null ? (class$com$belenus$interpartsserver3$SearchCsvResponder = SearchCsvResponder.class$("com.belenus.interpartsserver3.SearchCsvResponder")) : class$com$belenus$interpartsserver3$SearchCsvResponder));
    protected InterpartsServer m_interpartsServer;
    private String m_currentQueryName;
    private String m_searchCsvContentType;
    private String m_searchCsvFileName;
    private String m_searchCsvEncoding;
    private String m_searchCsvPrefix;
    private String m_searchCsvSeperator;
    private boolean m_searchCsvHeader;
    static /* synthetic */ Class class$com$belenus$interpartsserver3$SearchCsvResponder;

    public SearchCsvResponder(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Server server) {
        super(httpServletRequest, httpServletResponse, server);
        this.m_interpartsServer = (InterpartsServer)this.m_server;
        this.m_searchCsvContentType = this.m_interpartsServer.m_searchCsvContentType;
        this.m_searchCsvFileName = this.m_interpartsServer.m_searchCsvFileName;
        this.m_searchCsvEncoding = this.m_interpartsServer.m_searchCsvEncoding;
        this.m_searchCsvPrefix = this.m_interpartsServer.m_searchCsvPrefix;
        this.m_searchCsvSeperator = this.m_interpartsServer.m_searchCsvSeperator;
        this.m_searchCsvHeader = this.m_interpartsServer.m_searchCsvHeader;
    }

    protected void prepareOutput() throws UnsupportedEncodingException {
        this.m_httpServletResponse.setContentType(this.m_searchCsvContentType);
        this.m_httpServletResponse.setDateHeader("Expires", 0L);
        this.m_httpServletResponse.setHeader("Pragma", "public");
        this.m_httpServletResponse.setHeader("Cache-Control", "max-age=0");
        this.m_httpServletResponse.setHeader("Content-Disposition", "attachment; filename=" + this.m_searchCsvFileName);
        OutputStream outputStream = this.startOutputStream(true, true);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.m_searchCsvEncoding);
        this.m_printWriter = new PrintWriter(outputStreamWriter);
        this.m_printWriter.write(this.m_searchCsvPrefix);
    }

    protected void showPage() {
        this.getSearchResultContainer();
        int queryIndex = this.m_searchResultContainer.currentQueryIndex();
        int toPathIndex = this.m_searchResultContainer.currentToPathIndex();
        int resultIndex = this.m_searchResultContainer.currentResultIndex();
        this.m_searchResultContainer.set(0, 0, 0);
        this.showHeader();
        this.showResults();
        this.m_searchResultContainer.set(queryIndex, toPathIndex, resultIndex);
    }

    private void showHeader() {
        RowContainer tabledefRowContainer = this.m_searchResultContainer.currentTabledef();
        if (tabledefRowContainer != null) {
            StringBuffer header = new StringBuffer();
            Row currentResultRow = this.m_searchResultContainer.currentResult();
            this.buildHeaderDefinition(header, currentResultRow.getRowContainer(), "field", tabledefRowContainer);
            Row currentToPathRow = this.m_searchResultContainer.currentToPath();
            this.buildHeaderDefinition(header, currentToPathRow.getRowContainer(), "field", tabledefRowContainer);
            this.m_printWriter.println(header);
        }
    }

    private void showResults() {
        if (!this.m_searchResultContainer.isEmpty()) {
            this.m_searchResultContainer.currentToPathWithOverflow();
            this.showSingleResult();
            this.m_printWriter.flush();
            int entry = 1;
            while (this.m_searchResultContainer.hasNextToPathWithOverflow()) {
                this.m_searchResultContainer.nextToPathWithOverflow();
                this.showSingleResult();
                this.m_printWriter.flush();
                ++entry;
            }
        }
    }

    private void showSingleResult() {
        String[] actualPathRowFieldNames;
        if (!this.m_searchResultContainer.currentQueryName().equals(this.m_currentQueryName)) {
            this.showDefinition();
        }
        Row currentResultRow = this.m_searchResultContainer.currentResult();
        Row currentToPathRow = this.m_searchResultContainer.currentToPath();
        StringBuffer entryResultFields = new StringBuffer();
        StringBuffer entryPath = new StringBuffer();
        StringBuffer entryPathFields = new StringBuffer();
        this.buildEntry(entryResultFields, currentResultRow, "field");
        this.buildEntry(entryResultFields, currentToPathRow, "field");
        RowContainer actualPathRowContainer = currentToPathRow.getContainingRowContainer();
        actualPathRowContainer.resetPosition();
        String[] actualPathRowNames = actualPathRowFieldNames = actualPathRowContainer.getFieldNamesByMeaning("field");
        StringBuffer[] pathEntries = new StringBuffer[actualPathRowNames.length];
        for (int pathEntriesIndex = 0; pathEntriesIndex < pathEntries.length; ++pathEntriesIndex) {
            pathEntries[pathEntriesIndex] = new StringBuffer();
        }
        while (actualPathRowContainer.hasNext()) {
            Row actualPathRow = actualPathRowContainer.nextRow();
            for (int actualPathRowNamesIndex = 0; actualPathRowNamesIndex < actualPathRowNames.length; ++actualPathRowNamesIndex) {
                String value = actualPathRow.getString(actualPathRowNames[actualPathRowNamesIndex], this.m_locale, true);
                this.addToSlashSeperatedList(pathEntries[actualPathRowNamesIndex], value);
            }
        }
        this.addToList(entryPathFields, pathEntries);
        this.addToList(entryPath, this.buildTreePath(currentToPathRow));
        this.m_printWriter.println(entryResultFields + this.m_searchCsvSeperator + entryPathFields.toString());
    }

    private void showDefinition() {
        if (this.m_searchCsvHeader) {
            this.m_currentQueryName = this.m_searchResultContainer.currentQueryName();
            Row currentResultRow = this.m_searchResultContainer.currentResult();
            Row currentToPathRow = this.m_searchResultContainer.currentToPath();
            RowContainer actualToPathRowContainer = currentToPathRow.getContainingRowContainer();
            StringBuffer definitionResultNames = new StringBuffer();
            this.buildDefinition(definitionResultNames, currentResultRow.getRowContainer(), "field");
            this.buildDefinition(definitionResultNames, currentToPathRow.getRowContainer(), "field");
            StringBuffer definitionPathNames = new StringBuffer();
            this.buildDefinition(definitionPathNames, actualToPathRowContainer, "field");
            this.m_printWriter.println(definitionResultNames);
        }
    }

    private String addToList(StringBuffer result, String[] input) {
        if (input != null) {
            for (int inputIndex = 0; inputIndex < input.length; ++inputIndex) {
                this.addToList(result, input[inputIndex]);
            }
        }
        return result.toString();
    }

    private String addToList(StringBuffer result, StringBuffer[] input) {
        if (input != null) {
            for (int inputIndex = 0; inputIndex < input.length; ++inputIndex) {
                this.addToList(result, input[inputIndex].toString());
            }
        }
        return result.toString();
    }

    private void addToList(StringBuffer result, String input, String separator, String stringStartIdentifier, String stringEndIdentifier) {
        if (result.length() > 0) {
            result.append(separator);
        }
        if (input != null && !input.equals("")) {
            result.append(stringStartIdentifier).append(input).append(stringEndIdentifier);
        } else {
            result.append(stringStartIdentifier).append(stringEndIdentifier);
        }
    }

    protected void addToList(StringBuffer result, String input) {
        this.addToList(result, input, this.m_searchCsvSeperator, "", "");
    }

    protected void addToListWithNull(StringBuffer result, String input) {
        this.addToList(result, input, this.m_searchCsvSeperator, "", "");
    }

    private void addToSlashSeperatedList(StringBuffer result, String input) {
        this.addToList(result, input, " / ", "", "");
    }

    private void buildDefinition(StringBuffer result, RowContainer rowContainer, String meaning) {
        String[] fieldNames = rowContainer.getFieldNamesByMeaning(meaning);
        this.addToList(result, fieldNames);
    }

    private void buildEntry(StringBuffer result, Row row, String meaning) {
        String[] fieldNames = row.getRowContainer().getFieldNamesByMeaning(meaning);
        for (int fieldNamesIndex = 0; fieldNamesIndex < fieldNames.length; ++fieldNamesIndex) {
            String value = row.getString(fieldNames[fieldNamesIndex], this.m_locale, true);
            this.addToList(result, value);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

