/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.interpartsserver3;

import com.belenus.dataconnect.Row;
import com.belenus.dataconnect.RowContainer;
import com.belenus.interpartsserver3.SearchResponder;
import com.belenus.interpartsserver3.Server;
import com.belenus.util.StringUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class SearchHtmlResponder
extends SearchResponder {
    private static final Logger logger = Logger.getLogger((Class)(class$com$belenus$interpartsserver3$SearchHtmlResponder == null ? (class$com$belenus$interpartsserver3$SearchHtmlResponder = SearchHtmlResponder.class$("com.belenus.interpartsserver3.SearchHtmlResponder")) : class$com$belenus$interpartsserver3$SearchHtmlResponder));
    static /* synthetic */ Class class$com$belenus$interpartsserver3$SearchHtmlResponder;

    public SearchHtmlResponder(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Server server) {
        super(httpServletRequest, httpServletResponse, server);
    }

    protected void showPage() {
        this.showPageLeadIn();
        this.initializeSearchResultContainer();
        this.showResults();
        this.showPageLeadOut();
    }

    private void showResults() {
        if (this.m_searchResultContainer.isEmpty()) {
            this.showLine(this.internationalize("resultNotFound"));
        } else {
            if (!this.m_searchResultContainer.isAtStart()) {
                this.showLink(this.pageLink("searchhtml", -this.m_searchEntriesPerPage), this.internationalize("previousResults"));
            }
            this.m_searchResultContainer.currentToPathWithOverflow();
            this.showSingleResult();
            for (int entry = 1; this.m_searchResultContainer.hasNextToPathWithOverflow() && entry < this.m_searchEntriesPerPage; ++entry) {
                this.m_searchResultContainer.nextToPathWithOverflow();
                this.showSingleResult();
            }
            if (this.m_searchResultContainer.hasNextToPathWithOverflow()) {
                this.showLink(this.pageLink("searchhtml", this.m_searchEntriesPerPage), this.internationalize("nextResults"));
            } else if (this.m_searchResultContainer.continuesFromHere()) {
                this.showLine(this.internationalize("noMoreEntriesDisplayed"));
            } else {
                this.showLine(this.internationalize("noMoreEntries"));
            }
        }
    }

    private void showSingleResult() {
        String treepath = this.buildTreePath(this.m_searchResultContainer.currentToPath());
        String order = null;
        if ("true".equals(this.m_searchResultContainer.currentResult().getString("extra_order")) || "true".equals(this.m_searchResultContainer.currentToPath().getString("extra_order"))) {
            order = this.buildOrder(this.m_searchResultContainer.currentResult());
            order = order + this.buildOrder(this.m_searchResultContainer.currentToPath());
        }
        this.showLeadIn();
        this.showHeader(treepath, order);
        System.err.println("Result: " + this.m_searchResultContainer.currentResult());
        System.err.println("ToPath: " + this.m_searchResultContainer.currentToPath());
        this.showFields(this.m_searchResultContainer.currentResult());
        this.showFields(this.m_searchResultContainer.currentToPath());
        this.showCaptionPath(this.m_searchResultContainer.currentToPath());
        this.showLeadOut();
        this.m_printWriter.flush();
    }

    private void showFields(Row row) {
        RowContainer rowContainer = row.getRowContainer();
        String[] fieldNamesByDescription = rowContainer.getFieldNamesByMeaning("field");
        for (int fieldNamesByDescriptionIndex = 0; fieldNamesByDescriptionIndex < fieldNamesByDescription.length; ++fieldNamesByDescriptionIndex) {
            String fieldName = fieldNamesByDescription[fieldNamesByDescriptionIndex];
            String fieldKey = fieldName.substring(6).toLowerCase();
            String fieldValue = row.getString(fieldName).trim();
            this.showField(fieldKey, fieldValue);
        }
    }

    public void showPageLeadIn() {
        this.m_printWriter.println("<html>");
        this.m_printWriter.println("<head>");
        this.m_printWriter.println("  <script type=\"text/javascript\" src=\"viewer/js/fbh.js\"></script>");
        this.m_printWriter.println("  <script type=\"text/javascript\">");
        this.m_printWriter.println("belenusHome.includeCSS(self,\"css/content.css\")");
        this.m_printWriter.println("  </script>");
        this.m_printWriter.println("  <style type=\"text/css\">");
        this.m_printWriter.println("    .grid {");
        this.m_printWriter.println("      background-color: #00ff00;");
        this.m_printWriter.println("    }");
        this.m_printWriter.println("  </style>");
        this.m_printWriter.println("  <script type=\"text/javascript\" src=\"viewer/js/no_right_click.js\"></script>");
        this.m_printWriter.println("  <script type=\"text/javascript\">");
        this.m_printWriter.println("    var undef;");
        this.m_printWriter.println("    var belenusHome;");
        this.m_printWriter.println("    var counter = 10;");
        this.m_printWriter.println("    if(top.opener) var current = top.opener;");
        this.m_printWriter.println("      else var current = parent;");
        this.m_printWriter.println("    while (current.belenusHome == undef && counter > 0) {");
        this.m_printWriter.println("      current = current.parent;");
        this.m_printWriter.println("      counter--;");
        this.m_printWriter.println("    }");
        this.m_printWriter.println("    belenusHome = current.belenusHome;");
        this.m_printWriter.println("    document.write('<title>'+belenusHome.ld['s_search']+'</title>');");
        this.m_printWriter.println("    var useArticleSearch = belenusHome.getQueryField(self.location.search,'useArticleSearch');");
        this.m_printWriter.println("    var gridColor =  belenusHome.getWebColor(belenusHome.getCSSProperty(document, \".grid\", \"backgroundColor\"));");
        this.m_printWriter.println("    if(belenusHome.getWebColor(belenusHome.getCSSProperty(belenusHome.document, \"#tableDefault\", \"borderColor\")) != null && belenusHome.getWebColor(belenusHome.getCSSProperty(belenusHome.document, \"#tableDefault\", \"borderColor\")) != \"\") {");
        this.m_printWriter.println("      gridColor = belenusHome.getWebColor(belenusHome.getCSSProperty(belenusHome.document, \"#tableDefault\", \"borderColor\"));");
        this.m_printWriter.println("    } else {");
        this.m_printWriter.println("      if(belenusHome.getWebColor(belenusHome.getCSSProperty(belenusHome.document, \"*\", \"color\")) != null && belenusHome.getWebColor(belenusHome.getCSSProperty(belenusHome.document, \"*\", \"color\")) != \"\") {");
        this.m_printWriter.println("        gridColor = belenusHome.getWebColor(belenusHome.getCSSProperty(belenusHome.document, \"*\", \"color\"));");
        this.m_printWriter.println("      }");
        this.m_printWriter.println("    }");
        this.m_printWriter.println("    belenusHome.setCSSProperty(document, \".grid\", \"backgroundColor\", gridColor);");
        this.m_printWriter.println("  </script>");
        this.m_printWriter.println("</head>");
        this.m_printWriter.println("<body>");
    }

    protected void showPageLeadOut() {
        this.m_printWriter.println("</body>");
        this.m_printWriter.println("</html>");
    }

    protected void showLeadIn() {
        this.m_printWriter.println("<table class=\"tab\" width=\"98%\">");
        this.m_printWriter.println("  <tr>");
        this.m_printWriter.println("    <td>");
        this.m_printWriter.println("      <table border=\"0\" width=\"96%\" cellpadding=\"0\" cellspacing=\"0\">");
    }

    protected void showLeadOut() {
        this.m_printWriter.println("      </table>");
        this.m_printWriter.println("    </td>");
        this.m_printWriter.println("  </tr>");
        this.m_printWriter.println("</table>");
        this.m_printWriter.println("<br>");
    }

    protected void showField(String fieldName, String fieldValue) {
        this.m_printWriter.println("        <tr>");
        this.m_printWriter.println("          <td width=\"1\" valign=\"top\"><b><script type=\"text/javascript\">document.write(belenusHome.ld['dynsearch_" + fieldName + "'])</script>&nbsp;</b></td>");
        this.m_printWriter.println("          <td width=\"100%\">" + fieldValue + "</td>");
        this.m_printWriter.println("        </tr>");
        this.showFieldDelimeter();
    }

    protected void showFieldDelimeter() {
        this.m_printWriter.println("        <tr>");
        this.m_printWriter.println("          <td class=\"grid\" colspan=\"2\" height=\"1\" width=\"1\"><img src=\"../viewer/custom/images/i.gif\" height=\"1\" width=\"1\" border=\"0\"></td>");
        this.m_printWriter.println("        </tr>");
    }

    protected void showHeader(String treepath, String order) {
        String treepathString = "";
        if (treepath != null && !treepath.equals("")) {
            treepathString = "<a href=\"javascript:belenusHome.eventHandler('OpenLink','URL=parts:" + treepath + "');\"><img src=\"viewer/custom/images/goto.gif\" width=\"25\" height=\"16\" border=\"0\"></a>";
        }
        String orderString = "";
        if (order != null && !order.equals("")) {
            orderString = "<a href=\"javascript:belenusHome.eventHandler('AddToBasket','AddBy=PartData&PartData='+escape('" + order + "'))\"><img src=\"viewer/custom/images/add2cart.gif\" width=\"25\" height=\"16\" border=\"0\"></a>";
        }
        this.m_printWriter.println("        <tr>");
        this.m_printWriter.println("          <td class=\"label\" colspan=\"2\" height=\"10\">" + treepathString + orderString);
        this.m_printWriter.println("          </td>");
        this.m_printWriter.println("        </tr>");
    }

    protected void showCaptionPath(Row toPathRow) {
        RowContainer actualPathRowContainer = toPathRow.getContainingRowContainer();
        String[] captionDescriptions = actualPathRowContainer.getDescriptionsByMeaning("field");
        for (int captionDescriptionsIndex = 0; captionDescriptionsIndex < captionDescriptions.length; ++captionDescriptionsIndex) {
            String captionDescription = captionDescriptions[captionDescriptionsIndex];
            String treepath = this.buildTreePath(toPathRow);
            String captionPath = this.buildCaptionPath(toPathRow, captionDescription);
            this.showLink("javascript:belenusHome.eventHandler('OpenLink', 'URL=parts:" + treepath + "');", captionPath);
        }
    }

    protected String buildCaptionPath(Row toPathRow, String captionDescription) {
        StringBuffer captionsStringBuffer = new StringBuffer();
        RowContainer actualPathRowContainer = toPathRow.getContainingRowContainer();
        actualPathRowContainer.resetPosition();
        int captionsIndex = 0;
        while (actualPathRowContainer.hasNext()) {
            Row actualPathRow = actualPathRowContainer.nextRow();
            String caption = actualPathRow.getString(captionDescription, this.m_locale, true);
            if (caption == null || caption.trim().equals("")) continue;
            this.addCaptionPath(captionsStringBuffer, caption, captionsIndex);
            ++captionsIndex;
        }
        String caption = toPathRow.getString(captionDescription, this.m_locale, true);
        if (caption != null && !caption.trim().equals("")) {
            this.addCaptionPath(captionsStringBuffer, caption, captionsIndex);
        }
        return captionsStringBuffer.toString();
    }

    protected void addCaptionPath(StringBuffer captionsStringBuffer, String caption, int captionsIndex) {
        caption = StringUtil.replaceAll(caption, " ", "&nbsp;");
        if (this.m_searchMultilinePathes) {
            captionsStringBuffer.append("<nobr>");
            for (int captionsIndexIndex = 0; captionsIndexIndex < captionsIndex; ++captionsIndexIndex) {
                captionsStringBuffer.append("&nbsp;&nbsp;");
            }
            captionsStringBuffer.append(caption).append("</nobr><br>");
        } else {
            if (captionsIndex > 0) {
                captionsStringBuffer.append("&nbsp;/ ");
            }
            captionsStringBuffer.append("<nobr>").append(caption).append("</nobr>");
        }
    }

    protected String buildOrder(Row row) {
        String order = "";
        RowContainer rowContainer = row.getRowContainer();
        String[] resultFieldNames = rowContainer.getDescriptionsByMeaning("field");
        for (int resultFieldNamesIndex = 0; resultFieldNamesIndex < resultFieldNames.length; ++resultFieldNamesIndex) {
            String fieldname = resultFieldNames[resultFieldNamesIndex];
            String name = rowContainer.nameOfField(fieldname);
            String value = StringUtil.encodeForURL(row.getString(fieldname));
            order = order + name + "=" + value + "&";
        }
        String[] resultOrderNames = rowContainer.getDescriptionsByMeaning("order");
        for (int resultOrderNamesIndex = 0; resultOrderNamesIndex < resultOrderNames.length; ++resultOrderNamesIndex) {
            String ordername = resultOrderNames[resultOrderNamesIndex];
            String name = rowContainer.nameOfField(ordername);
            String value = StringUtil.encodeForURL(row.getString(ordername));
            order = order + name + "=" + value + "&";
        }
        return order;
    }

    protected String internationalize(String caption) {
        return "<script type=\"text/javascript\">document.write(belenusHome.ld['" + caption + "'])</script>";
    }

    protected void showLink(String href, String caption) {
        this.m_printWriter.println("        <tr><td colspan=\"2\"><a href=\"" + href + "\">" + caption + "</a></td></tr>");
    }

    protected void showLine(String caption) {
        this.m_printWriter.println("        <tr><td colspan=\"2\">" + caption + "</td></tr>");
    }

    protected String pageLink(String search, int offset) {
        return "server?command=" + search + "&resultid=" + this.m_resultId + "&query=" + this.m_queryParameter + "&queryindex=" + this.m_queryIndex + "&resultindex=" + this.m_resultIndex + "&topathindex=" + this.m_toPathIndex + "&offset=" + offset;
    }

    protected void addToList(StringBuffer result, String input) {
    }

    protected void addToListWithNull(StringBuffer result, String input) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

