/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.interpartsserver3;

import com.belenus.interpartsserver3.ServerDispatcher;
import com.belenus.util.ServletConfigurator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;

abstract class Server {
    private static final Logger logger = Logger.getLogger((Class)(class$com$belenus$interpartsserver3$Server == null ? (class$com$belenus$interpartsserver3$Server = Server.class$("com.belenus.interpartsserver3.Server")) : class$com$belenus$interpartsserver3$Server));
    public static final Object[][] RESPONDER_DESCRIPTIONS = new Object[][]{{"info", class$com$belenus$interpartsserver3$InfoResponder == null ? (class$com$belenus$interpartsserver3$InfoResponder = Server.class$("com.belenus.interpartsserver3.InfoResponder")) : class$com$belenus$interpartsserver3$InfoResponder}, {"resource", class$com$belenus$interpartsserver3$ResourceResponder == null ? (class$com$belenus$interpartsserver3$ResourceResponder = Server.class$("com.belenus.interpartsserver3.ResourceResponder")) : class$com$belenus$interpartsserver3$ResourceResponder}};
    protected File m_configBase;
    protected File m_configFile;
    protected ServerDispatcher m_serverDispatcher;
    protected HttpServlet m_httpServlet;
    protected String m_serverName;
    protected ServletConfigurator m_configurator;
    protected Properties m_properties;
    protected String m_streamBase;
    protected String m_streamDirectUrl;
    protected boolean m_useUserDependentMedia;
    protected String[] m_streamReplaces;
    protected String[][] m_streamSearchFor;
    protected String[][] m_streamReplaceWith;
    protected HashMap m_responderClassMap;
    protected HashMap m_responderConstructorMap;
    protected ArrayList m_responderNames;
    protected Throwable m_startupError;
    Date m_startupDate;
    static /* synthetic */ Class class$com$belenus$interpartsserver3$Server;
    static /* synthetic */ Class class$com$belenus$interpartsserver3$InfoResponder;
    static /* synthetic */ Class class$com$belenus$interpartsserver3$ResourceResponder;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletResponse;

    public Server(ServerDispatcher serverDispatcher, File configBase, String serverName) {
        block9: {
            this.m_startupDate = new Date();
            this.m_serverDispatcher = serverDispatcher;
            this.m_configBase = configBase;
            this.m_serverName = serverName;
            this.m_httpServlet = this.m_serverDispatcher.getServlet();
            ServletConfig servletConfig = this.m_httpServlet.getServletConfig();
            Properties properties = ServletConfigurator.getServletProperties(servletConfig);
            try {
                if (this.m_configBase == null || !this.m_configBase.isDirectory()) {
                    throw new FileNotFoundException("Configuration base not correct (no directory): " + this.m_configBase);
                }
                this.m_configFile = new File(this.m_configBase, this.m_serverName + ".properties").getCanonicalFile();
                FileInputStream fileInputStream = new FileInputStream(this.m_configFile);
                properties.load(fileInputStream);
                fileInputStream.close();
            }
            catch (Throwable throwable) {
                if (this.m_startupError == null) {
                    this.m_startupError = throwable;
                }
                logger.error((Object)throwable);
            }
            String overridePrefix = "interparts." + this.m_serverName;
            try {
                this.m_configurator = new ServletConfigurator(properties, overridePrefix, this.m_configBase);
            }
            catch (Throwable throwable) {
                if (this.m_startupError == null) {
                    this.m_startupError = throwable;
                }
                logger.error((Object)throwable);
                this.m_configurator = new ServletConfigurator(properties, overridePrefix);
            }
            this.m_properties = properties;
            this.configure();
            NDC.push((String)this.m_serverName);
            try {
                this.start();
            }
            catch (Throwable exc) {
                logger.error((Object)exc, exc);
                if (this.m_startupError == null) break block9;
                this.m_startupError = exc;
            }
        }
        NDC.pop();
    }

    protected void initResponders(Object[][] responderDescriptions) {
        try {
            this.m_responderClassMap = new HashMap();
            this.m_responderConstructorMap = new HashMap();
            this.m_responderNames = new ArrayList();
            for (int responderDescriptionsIndex = 0; responderDescriptionsIndex < responderDescriptions.length; ++responderDescriptionsIndex) {
                String responderName = (String)responderDescriptions[responderDescriptionsIndex][0];
                Class responderClass = (Class)responderDescriptions[responderDescriptionsIndex][1];
                this.m_responderClassMap.put(responderName, responderClass);
                try {
                    logger.debug((Object)("Responder: " + responderName + "  " + responderClass));
                    Constructor responderConstructor = responderClass.getConstructor(class$javax$servlet$http$HttpServletRequest == null ? Server.class$("javax.servlet.http.HttpServletRequest") : class$javax$servlet$http$HttpServletRequest, class$javax$servlet$http$HttpServletResponse == null ? Server.class$("javax.servlet.http.HttpServletResponse") : class$javax$servlet$http$HttpServletResponse, class$com$belenus$interpartsserver3$Server == null ? Server.class$("com.belenus.interpartsserver3.Server") : class$com$belenus$interpartsserver3$Server);
                    this.m_responderConstructorMap.put(responderName, responderConstructor);
                    this.m_responderNames.add(responderName);
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    logger.error((Object)noSuchMethodException);
                }
            }
        }
        catch (Throwable throwable) {
            if (this.m_startupError != null) {
                this.m_startupError = throwable;
            }
            logger.error((Object)throwable, throwable);
        }
    }

    protected void configure() {
        this.m_configurator.setScope("Media Stream");
        String mediaPathDefault = new File(this.m_serverDispatcher.m_directoryBaseFile, "WEB-INF/data/media").toString();
        this.m_streamBase = this.m_configurator.getString("stream.base", mediaPathDefault);
        File mediaPathFile = new File(this.m_streamBase);
        if (!mediaPathFile.isAbsolute()) {
            this.m_streamBase = new File(this.m_serverDispatcher.m_directoryBaseFile, this.m_streamBase).toString();
        }
        this.m_streamReplaces = this.m_configurator.getArray("stream");
        this.m_streamSearchFor = new String[this.m_streamReplaces.length][];
        this.m_streamReplaceWith = new String[this.m_streamReplaces.length][];
        for (int i = 0; i < this.m_streamReplaces.length; ++i) {
            this.m_streamSearchFor[i] = this.m_configurator.getArray("stream." + i + ".search");
            this.m_streamReplaceWith[i] = this.m_configurator.getArray("stream." + i + ".replace");
        }
        this.m_useUserDependentMedia = this.m_configurator.getBoolean("stream.userdependent", "false");
        this.m_streamDirectUrl = this.m_configurator.getString("stream.directurl", null);
    }

    public void start() {
        try {
            this.initResponders(RESPONDER_DESCRIPTIONS);
        }
        catch (Throwable exc) {
            logger.error((Object)exc, exc);
            this.m_startupError = exc;
        }
    }

    public void stop() {
    }

    public abstract String getServerType();

    public abstract String getVersion();

    public abstract String getRevision();

    public String getServerName() {
        return this.m_serverName;
    }

    public Throwable getStartupError() {
        return this.m_startupError;
    }

    public abstract void checkAvailability() throws Throwable;

    protected String giveMimeType(String filename, InputStream in, String defaulttype) {
        String contenttype = this.m_httpServlet.getServletContext().getMimeType(filename);
        if (contenttype == null) {
            try {
                contenttype = URLConnection.guessContentTypeFromStream(in);
            }
            catch (IOException exc) {
                // empty catch block
            }
            if (contenttype == null) {
                contenttype = defaulttype;
            }
        }
        return contenttype;
    }

    public Properties getConfigProperties(HttpServletRequest httpServletRequest) {
        return new Properties(this.m_properties);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

