/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.interpartsserver3;

import com.belenus.dataconnect.ParameterContainer;
import com.belenus.interpartsserver3.InterpartsServer;
import com.belenus.interpartsserver3.InterpartsServlet;
import com.belenus.interpartsserver3.NoServerException;
import com.belenus.interpartsserver3.Responder;
import com.belenus.interpartsserver3.Revision;
import com.belenus.interpartsserver3.ServerDispatcherInterface;
import com.belenus.util.Configurator;
import com.belenus.util.NoNowlinePatternLayout;
import com.belenus.util.ServletConfigurator;
import com.belenus.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.net.SyslogAppender;

public class ServerDispatcher
implements ServerDispatcherInterface,
Runnable {
    private static final Logger logger = Logger.getLogger((Class)(class$com$belenus$interpartsserver3$ServerDispatcher == null ? (class$com$belenus$interpartsserver3$ServerDispatcher = ServerDispatcher.class$("com.belenus.interpartsserver3.ServerDispatcher")) : class$com$belenus$interpartsserver3$ServerDispatcher));
    private static final Object[][] SERVERDISPATCHER_RESPONDER_DESCRIPTIONS = new Object[][]{{"dispatcherinfo", class$com$belenus$interpartsserver3$ServerDispatcherInfoResponder == null ? (class$com$belenus$interpartsserver3$ServerDispatcherInfoResponder = ServerDispatcher.class$("com.belenus.interpartsserver3.ServerDispatcherInfoResponder")) : class$com$belenus$interpartsserver3$ServerDispatcherInfoResponder}, {"systeminfo", class$com$belenus$interpartsserver3$SystemInfoResponder == null ? (class$com$belenus$interpartsserver3$SystemInfoResponder = ServerDispatcher.class$("com.belenus.interpartsserver3.SystemInfoResponder")) : class$com$belenus$interpartsserver3$SystemInfoResponder}, {"resource", class$com$belenus$interpartsserver3$ResourceResponder == null ? (class$com$belenus$interpartsserver3$ResourceResponder = ServerDispatcher.class$("com.belenus.interpartsserver3.ResourceResponder")) : class$com$belenus$interpartsserver3$ResourceResponder}, {"server", class$com$belenus$interpartsserver3$ServerResponder == null ? (class$com$belenus$interpartsserver3$ServerResponder = ServerDispatcher.class$("com.belenus.interpartsserver3.ServerResponder")) : class$com$belenus$interpartsserver3$ServerResponder}, {"log", class$com$belenus$interpartsserver3$LogResponder == null ? (class$com$belenus$interpartsserver3$LogResponder = ServerDispatcher.class$("com.belenus.interpartsserver3.LogResponder")) : class$com$belenus$interpartsserver3$LogResponder}, {"activate", class$com$belenus$interpartsserver3$ActivateResponder == null ? (class$com$belenus$interpartsserver3$ActivateResponder = ServerDispatcher.class$("com.belenus.interpartsserver3.ActivateResponder")) : class$com$belenus$interpartsserver3$ActivateResponder}, {"restart", class$com$belenus$interpartsserver3$RestartResponder == null ? (class$com$belenus$interpartsserver3$RestartResponder = ServerDispatcher.class$("com.belenus.interpartsserver3.RestartResponder")) : class$com$belenus$interpartsserver3$RestartResponder}};
    private static final String SERVER_TYPE = "Belenus Server Center";
    private static final String VERSION = "3.0";
    private static final long RESTART_PAUSE = 1000L;
    protected boolean m_running;
    protected ArrayList m_propertiesDates = new ArrayList();
    protected Thread m_thread;
    protected Configurator m_configurator;
    protected boolean m_logInitialized = false;
    protected File m_logBaseFile;
    protected String m_logFileName;
    protected FileAppender m_fileAppender;
    protected SyslogAppender m_syslogAppender;
    protected Date m_startupDate = new Date();
    protected Throwable m_startupError;
    protected File m_directoryBaseFile;
    protected File m_configBaseFile;
    protected String m_password;
    protected String[][] m_adminAccessMask;
    protected boolean m_autorestart;
    protected String m_fallbackLocale;
    protected ArrayList m_serverNames = new ArrayList();
    protected HashMap m_serverMap = new HashMap();
    protected ArrayList m_rangeNames = new ArrayList();
    protected HashMap m_rangesMap = new HashMap();
    protected HashMap m_activeServerForRange = new HashMap();
    protected InterpartsServlet m_interpartsServlet;
    private String m_webAppBase;
    protected HashMap m_responderClassMap;
    protected HashMap m_responderConstructorMap;
    protected ArrayList m_responderNames;
    protected HashMap m_compressorMap;
    protected HashMap m_contentTypeMap;
    protected Class m_encryptor;
    static /* synthetic */ Class class$com$belenus$interpartsserver3$ServerDispatcher;
    static /* synthetic */ Class class$com$belenus$interpartsserver3$ServerDispatcherInfoResponder;
    static /* synthetic */ Class class$com$belenus$interpartsserver3$SystemInfoResponder;
    static /* synthetic */ Class class$com$belenus$interpartsserver3$ResourceResponder;
    static /* synthetic */ Class class$com$belenus$interpartsserver3$ServerResponder;
    static /* synthetic */ Class class$com$belenus$interpartsserver3$LogResponder;
    static /* synthetic */ Class class$com$belenus$interpartsserver3$ActivateResponder;
    static /* synthetic */ Class class$com$belenus$interpartsserver3$RestartResponder;
    static /* synthetic */ Class class$java$io$FilterOutputStream;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletResponse;

    public ServerDispatcher(InterpartsServlet interpartsServlet) {
        this.m_interpartsServlet = interpartsServlet;
    }

    public String getServerType() {
        return SERVER_TYPE;
    }

    public String getVersion() {
        return VERSION;
    }

    public String getRevision() {
        return Revision.getRevision();
    }

    public synchronized void init(ServletConfig servletConfig) throws ServletException {
        try {
            ServletContext servletContext = servletConfig.getServletContext();
            File webXmlFile = new File(servletContext.getRealPath("/WEB-INF/web.xml"));
            File configBase = new File(servletContext.getRealPath("/WEB-INF"));
            this.m_directoryBaseFile = webXmlFile.getParentFile().getParentFile();
            Properties properties = ServletConfigurator.getServletProperties(servletConfig);
            this.m_configurator = new Configurator(properties, null, configBase);
            this.m_configurator.setScope("General");
            boolean useFileLogging = this.m_configurator.getBoolean("filelogging", "true");
            String logBase = this.m_configurator.getString("log-base", new File(this.m_directoryBaseFile, "/WEB-INF/log").toString());
            this.m_logBaseFile = !"".equals(logBase) ? new File(logBase) : new File(this.m_directoryBaseFile, "/WEB-INF/log");
            String syslogHost = this.m_configurator.getString("syslog-host", null);
            this.configureLogger(useFileLogging, syslogHost);
            this.configureServerDispatcher();
            this.configureResponders();
            this.m_configurator.setScope("Servers");
            String serverNamesString = this.m_configurator.getString("servers", "server");
            logger.info((Object)("ServerDispatcher Configuration:\n" + this.m_configurator.toString()));
            this.initResponders(SERVERDISPATCHER_RESPONDER_DESCRIPTIONS);
            this.constructServers(serverNamesString);
            logger.info((Object)("Current working directory: " + System.getProperty("user.dir")));
            this.loadActiveServerNames();
            this.saveActiveServerNames();
            if (this.m_autorestart) {
                this.startAutorestarter();
            }
        }
        catch (Throwable throwable) {
            if (this.m_startupError != null) {
                this.m_startupError = throwable;
            }
            logger.error((Object)"Error initializing server dispatcher", throwable);
        }
    }

    private void startAutorestarter() {
        for (int serverNamesIndex = 0; serverNamesIndex < this.m_serverNames.size(); ++serverNamesIndex) {
            String serverName = (String)this.m_serverNames.get(serverNamesIndex);
            File propertiesFile = new File(this.m_configBaseFile, serverName + ".properties");
            Date propertiesDate = new Date(propertiesFile.lastModified());
            this.m_propertiesDates.add(propertiesDate);
        }
        this.m_running = true;
        this.m_thread = new Thread(this);
        this.m_thread.start();
    }

    public void run() {
        while (this.m_running) {
            try {
                Thread.sleep(1000L);
                for (int serverNamesIndex = 0; serverNamesIndex < this.m_serverNames.size() && this.m_running; ++serverNamesIndex) {
                    try {
                        String serverName = (String)this.m_serverNames.get(serverNamesIndex);
                        Date oldPropertiesDate = (Date)this.m_propertiesDates.get(serverNamesIndex);
                        File propertiesFile = new File(this.m_configBaseFile, serverName + ".properties");
                        Date newPropertiesDate = new Date(propertiesFile.lastModified());
                        if (newPropertiesDate.equals(oldPropertiesDate)) continue;
                        InterpartsServer oldInterpartsServer = (InterpartsServer)this.m_serverMap.get(serverName);
                        InterpartsServer newInterpartsServer = this.restart(oldInterpartsServer);
                        if (newInterpartsServer != null && this.m_running) {
                            this.m_serverMap.put(serverName, newInterpartsServer);
                        }
                        this.m_propertiesDates.set(serverNamesIndex, newPropertiesDate);
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private void loadActiveServerNames() {
        try {
            File currentServerNamesFile = new File(this.m_directoryBaseFile, "/WEB-INF/.activeservernames");
            FileReader fileReader = new FileReader(currentServerNamesFile);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String line = bufferedReader.readLine();
            while (line != null) {
                String serverName = line.trim();
                if (this.m_serverNames.contains(serverName)) {
                    this.setActive(serverName);
                }
                line = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void saveActiveServerNames() {
        try {
            File currentServerNamesFile = new File(this.m_directoryBaseFile, "/WEB-INF/.activeservernames");
            FileWriter fileWriter = new FileWriter(currentServerNamesFile, false);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            for (int serverNamesIndex = 0; serverNamesIndex < this.m_serverNames.size(); ++serverNamesIndex) {
                String serverName = (String)this.m_serverNames.get(serverNamesIndex);
                if (!this.isActive(serverName)) continue;
                printWriter.println(serverName);
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void constructServers(String serverNamesString) {
        String[] serverNames = StringUtil.split(serverNamesString, ",");
        for (int serverNamesIndex = 0; serverNamesIndex < serverNames.length; ++serverNamesIndex) {
            String serverName = serverNames[serverNamesIndex].trim();
            this.m_serverNames.add(serverName);
            String range = this.getRangeFromServerName(serverName);
            if (!this.m_rangesMap.containsKey(range)) {
                this.m_rangeNames.add(range);
                this.m_rangesMap.put(range, new ArrayList());
                this.m_activeServerForRange.put(range, serverName);
            }
            ArrayList rangeServerList = (ArrayList)this.m_rangesMap.get(range);
            rangeServerList.add(serverName);
            try {
                InterpartsServer interpartsServer = new InterpartsServer(this, this.m_configBaseFile, serverName);
                this.m_serverMap.put(serverName, interpartsServer);
                continue;
            }
            catch (Throwable throwable) {
                if (this.m_startupError != null) {
                    this.m_startupError = throwable;
                }
                logger.error((Object)"Error constructing servers", throwable);
            }
        }
    }

    private void configureServerDispatcher() {
        String configBase = this.m_configurator.getString("config-base", new File(this.m_directoryBaseFile, "/WEB-INF").toString());
        this.m_configBaseFile = !"".equals(configBase) ? new File(configBase) : new File(this.m_directoryBaseFile, "/WEB-INF");
        this.m_configurator.addPasswordName("password");
        this.m_password = this.m_configurator.getString("password", null);
        this.m_webAppBase = this.m_configurator.getString("webapp", null);
        String adminAccess = this.m_configurator.getString("admin-access", "127.0.0.1");
        this.m_adminAccessMask = this.prepareAccessMask(adminAccess);
        this.m_autorestart = this.m_configurator.getBoolean("autorestart", "false");
        this.m_fallbackLocale = this.m_configurator.getString("fallbacklocale", null);
    }

    private void configureResponders() {
        this.m_configurator.setScope("Content Type");
        String[] extentions = this.m_configurator.getArray("content.extention");
        String[] contenttypes = this.m_configurator.getArray("content.type");
        if (extentions.length != contenttypes.length) {
            logger.error((Object)("Count of properties Extention[" + extentions.length + "] does not equal properties ContentType[" + contenttypes.length + "]"));
        }
        this.m_contentTypeMap = new HashMap((int)((float)contenttypes.length / 0.25f), 0.25f);
        for (int i = 0; i < contenttypes.length && i < contenttypes.length; ++i) {
            this.m_contentTypeMap.put(extentions[i].toLowerCase(), contenttypes[i]);
        }
        this.m_configurator.setScope("Compression");
        String[] compressorcontents = this.m_configurator.getArray("compressor.name");
        String[] compressors = this.m_configurator.getArray("compressor.class");
        if (compressorcontents.length != compressors.length) {
            logger.error((Object)("Count of properties CompressionContent[" + compressorcontents.length + "] does not equal properties Compressor[" + compressors.length + "]"));
        }
        this.m_compressorMap = new HashMap((int)((float)compressorcontents.length / 0.25f), 0.25f);
        for (int i = 0; i < compressorcontents.length && i < compressors.length; ++i) {
            try {
                Class<?> compressor = Class.forName(compressors[i].trim());
                if ((class$java$io$FilterOutputStream == null ? ServerDispatcher.class$("java.io.FilterOutputStream") : class$java$io$FilterOutputStream).isAssignableFrom(compressor)) {
                    this.m_compressorMap.put(compressorcontents[i].toLowerCase().trim(), compressor);
                    continue;
                }
                logger.error((Object)("Compressor " + compressors[i] + " of CompressorContent " + compressorcontents[i] + " is not a subclass of java.io.FilterOutputStream"));
                continue;
            }
            catch (ClassNotFoundException exc) {
                logger.error((Object)("Compressor " + compressors[i] + " of CompressorContent " + compressorcontents[i] + " is not a class"));
            }
        }
        this.m_configurator.setScope("Encryption");
        String encryptorname = this.m_configurator.getString("encryptor.class", null);
        if (encryptorname != null && !encryptorname.equals("")) {
            try {
                this.m_encryptor = Class.forName(encryptorname.trim());
                if ((class$java$io$FilterOutputStream == null ? (class$java$io$FilterOutputStream = ServerDispatcher.class$("java.io.FilterOutputStream")) : class$java$io$FilterOutputStream).isAssignableFrom(this.m_encryptor)) {
                    logger.error((Object)("Encryptor " + encryptorname + " is not a subclass of java.io.FilterOutputStream"));
                }
            }
            catch (ClassNotFoundException exc) {
                logger.error((Object)("Encryptor " + encryptorname + " is not a class"));
            }
        }
        this.m_configurator.setScope("Without Scope");
    }

    private void configureLogger(boolean useFileLogging, String syslogHost) {
        if (!this.m_logInitialized) {
            this.m_logInitialized = true;
            boolean loggingConfigured = false;
            Throwable fileLoggingThrowable = null;
            Throwable syslogLoggingThrowable = null;
            if (useFileLogging && this.m_logFileName == null) {
                try {
                    if (!this.m_logBaseFile.isDirectory()) {
                        this.m_logBaseFile.mkdirs();
                    }
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
                    String now = simpleDateFormat.format(new Date());
                    this.m_logFileName = new File(this.m_logBaseFile, "interparts." + now + ".log").toString();
                    PatternLayout filePatternLayout = new PatternLayout("%d [%t] %-5p %c %x %l - %m%n");
                    this.m_fileAppender = new FileAppender((Layout)filePatternLayout, this.m_logFileName);
                    if (!loggingConfigured) {
                        BasicConfigurator.configure((Appender)this.m_fileAppender);
                    } else {
                        Logger.getRootLogger().addAppender((Appender)this.m_fileAppender);
                    }
                    loggingConfigured = true;
                }
                catch (Throwable throwable) {
                    if (this.m_startupError == null) {
                        this.m_startupError = throwable;
                    }
                    fileLoggingThrowable = throwable;
                }
            }
            if (syslogHost != null && !"".equals(syslogHost)) {
                try {
                    String context = this.m_directoryBaseFile.getName();
                    context = context.replace(' ', '_');
                    NoNowlinePatternLayout syslogPatternLayout = new NoNowlinePatternLayout("de.belenus.interpartsserver3." + context + ": %d [%t] %-5p %c %x - %m");
                    this.m_syslogAppender = new SyslogAppender((Layout)syslogPatternLayout, syslogHost, 8);
                    if (!loggingConfigured) {
                        BasicConfigurator.configure((Appender)this.m_syslogAppender);
                    } else {
                        Logger.getRootLogger().addAppender((Appender)this.m_syslogAppender);
                    }
                    loggingConfigured = true;
                }
                catch (Throwable throwable) {
                    if (this.m_startupError == null) {
                        this.m_startupError = throwable;
                    }
                    syslogLoggingThrowable = throwable;
                }
            }
            if (!loggingConfigured) {
                BasicConfigurator.configure();
            }
            if (fileLoggingThrowable != null) {
                logger.error((Object)"Error configuring file logger", fileLoggingThrowable);
            }
            if (syslogLoggingThrowable != null) {
                logger.error((Object)"Error configuring syslog logger", syslogLoggingThrowable);
            }
        }
    }

    protected void initResponders(Object[][] responderDescriptions) {
        try {
            this.m_responderClassMap = new HashMap();
            this.m_responderConstructorMap = new HashMap();
            this.m_responderNames = new ArrayList();
            for (int responderDescriptionsIndex = 0; responderDescriptionsIndex < responderDescriptions.length; ++responderDescriptionsIndex) {
                String responderName = (String)responderDescriptions[responderDescriptionsIndex][0];
                Class responderClass = (Class)responderDescriptions[responderDescriptionsIndex][1];
                this.m_responderClassMap.put(responderName, responderClass);
                try {
                    logger.debug((Object)("Responder: " + responderName + "  " + responderClass));
                    Constructor responderConstructor = responderClass.getConstructor(class$javax$servlet$http$HttpServletRequest == null ? ServerDispatcher.class$("javax.servlet.http.HttpServletRequest") : class$javax$servlet$http$HttpServletRequest, class$javax$servlet$http$HttpServletResponse == null ? ServerDispatcher.class$("javax.servlet.http.HttpServletResponse") : class$javax$servlet$http$HttpServletResponse, class$com$belenus$interpartsserver3$ServerDispatcher == null ? ServerDispatcher.class$("com.belenus.interpartsserver3.ServerDispatcher") : class$com$belenus$interpartsserver3$ServerDispatcher);
                    this.m_responderConstructorMap.put(responderName, responderConstructor);
                    this.m_responderNames.add(responderName);
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    logger.error((Object)("Cannot initialize responder " + responderName), (Throwable)noSuchMethodException);
                }
            }
        }
        catch (Throwable throwable) {
            if (this.m_startupError != null) {
                this.m_startupError = throwable;
            }
            logger.error((Object)"Error initializing responders", throwable);
        }
    }

    protected synchronized InterpartsServer activate(InterpartsServer interpartsServer) throws Throwable {
        String serverName = interpartsServer.getServerName();
        this.setActive(serverName);
        this.saveActiveServerNames();
        return interpartsServer;
    }

    protected synchronized InterpartsServer restart(InterpartsServer oldInterpartsServer) throws Throwable {
        String serverName = oldInterpartsServer.getServerName();
        HashMap newServerMap = (HashMap)this.m_serverMap.clone();
        InterpartsServer newInterpartsServer = new InterpartsServer(this, this.m_configBaseFile, serverName);
        newInterpartsServer.start();
        newServerMap.remove(serverName);
        newServerMap.put(serverName, newInterpartsServer);
        if (oldInterpartsServer != null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            oldInterpartsServer.stop();
        }
        this.m_serverMap = newServerMap;
        return newInterpartsServer;
    }

    public boolean allowedAdministration(HttpServletRequest httpServletRequest) {
        return this.allowedAccess(httpServletRequest, this.m_adminAccessMask);
    }

    public String[][] prepareAccessMask(String access) {
        String[] accessSplitted = StringUtil.split(access, ",");
        String[][] accessMask = new String[accessSplitted.length][4];
        for (int accessSplittedIndex = 0; accessSplittedIndex < accessSplitted.length; ++accessSplittedIndex) {
            String[] adminAccessSplitSplatted = StringUtil.split(accessSplitted[accessSplittedIndex], ".");
            for (int adminAccessSplitSplattedIndex = 0; adminAccessSplitSplattedIndex < 4; ++adminAccessSplitSplattedIndex) {
                accessMask[accessSplittedIndex][adminAccessSplitSplattedIndex] = adminAccessSplitSplattedIndex < adminAccessSplitSplatted.length ? adminAccessSplitSplatted[adminAccessSplitSplattedIndex].trim() : "*";
            }
        }
        return accessMask;
    }

    public boolean allowedAccess(HttpServletRequest httpServletRequest, String[][] accessMask) {
        String ip = httpServletRequest.getRemoteAddr();
        String[] splittedIp = StringUtil.split(ip, ".");
        for (int adminAccessIndex = 0; adminAccessIndex < accessMask.length; ++adminAccessIndex) {
            String[] adminAccessEntry = accessMask[adminAccessIndex];
            int correctIpParts = 0;
            for (int adminAccessEntryIndex = 0; adminAccessEntryIndex < adminAccessEntry.length; ++adminAccessEntryIndex) {
                if (!"*".equals(adminAccessEntry[adminAccessEntryIndex]) && !splittedIp[adminAccessEntryIndex].equals(adminAccessEntry[adminAccessEntryIndex])) continue;
                ++correctIpParts;
            }
            if (correctIpParts != 4) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, NoServerException {
        block10: {
            try {
                Class responderClass;
                InterpartsServer interpartsServer = this.getInterpartsServer(httpServletRequest);
                String command = this.getCommand(httpServletRequest);
                if (command == null) {
                    command = "dispatcherinfo";
                }
                if ((responderClass = (Class)this.m_responderClassMap.get(command)) != null) {
                    Constructor responderConstructor = (Constructor)this.m_responderConstructorMap.get(command);
                    Responder responder = (Responder)responderConstructor.newInstance(httpServletRequest, httpServletResponse, this);
                    responder.respond();
                    break block10;
                }
                if (interpartsServer == null) {
                    throw new NoServerException("No server named \"" + httpServletRequest.getSession().getAttribute("interpartsservlet.currentservername") + "\" installed");
                }
                interpartsServer.handle(httpServletRequest, httpServletResponse);
                return;
            }
            catch (NoServerException noServerException) {
                logger.error((Object)noServerException.getMessage(), (Throwable)noServerException);
                throw noServerException;
            }
            catch (Throwable throwable) {
                logger.error((Object)"Error handling request", throwable);
                return;
            }
        }
    }

    public boolean isActive(String serverName) {
        boolean active = serverName.equals(this.m_activeServerForRange.get(this.getRangeFromServerName(serverName)));
        return active;
    }

    private void setActive(String serverName) {
        this.m_activeServerForRange.put(this.getRangeFromServerName(serverName), serverName);
    }

    protected String getRangeFromServerName(String serverName) {
        String[] splitted = StringUtil.splitInTwo(serverName, "-");
        if (splitted[1] == null) {
            return "";
        }
        return splitted[0];
    }

    protected InterpartsServer getInterpartsServer(HttpServletRequest httpServletRequest) throws NoServerException {
        HttpSession httpSession = httpServletRequest.getSession();
        String forceServerParameter = httpServletRequest.getParameter("forceserver");
        if (forceServerParameter != null) {
            if ("".equals(forceServerParameter)) {
                httpSession.removeAttribute("interpartsservlet.forceserver");
            } else {
                httpSession.setAttribute("interpartsservlet.forceserver", (Object)forceServerParameter);
            }
        }
        String serverParameter = forceServerParameter = (String)httpSession.getAttribute("interpartsservlet.forceserver");
        if (forceServerParameter == null) {
            serverParameter = httpServletRequest.getParameter("server");
            if (serverParameter == null) {
                String rangeName = httpServletRequest.getParameter("range");
                serverParameter = (String)this.m_activeServerForRange.get(rangeName);
            }
            if (serverParameter == null) {
                serverParameter = (String)httpSession.getAttribute("interpartsservlet.currentservername");
            }
        }
        if (serverParameter == null) {
            serverParameter = (String)this.m_serverNames.get(0);
        }
        httpSession.setAttribute("interpartsservlet.currentservername", (Object)serverParameter);
        InterpartsServer interpartsServer = (InterpartsServer)this.m_serverMap.get(serverParameter);
        return interpartsServer;
    }

    public ArrayList getServerNames(HttpServletRequest httpServletRequest) {
        return new ArrayList(this.m_serverNames);
    }

    public String getCurrentServerName(HttpServletRequest httpServletRequest) {
        try {
            InterpartsServer interpartsServer = this.getInterpartsServer(httpServletRequest);
            return interpartsServer.getServerName();
        }
        catch (NoServerException noServerException) {
            return null;
        }
        catch (Throwable throwable) {
            logger.error((Object)"Cannot get current server name", throwable);
            return null;
        }
    }

    public String getCurrentRange(HttpServletRequest httpServletRequest) {
        try {
            InterpartsServer interpartsServer = this.getInterpartsServer(httpServletRequest);
            return this.getRangeFromServerName(interpartsServer.getServerName());
        }
        catch (NoServerException noServerException) {
            return null;
        }
        catch (Throwable throwable) {
            logger.error((Object)"Cannot get current range", throwable);
            return null;
        }
    }

    public void destroy() {
        this.m_running = false;
        for (int serverNamesIndex = 0; serverNamesIndex < this.m_serverNames.size(); ++serverNamesIndex) {
            String serverName = (String)this.m_serverNames.get(serverNamesIndex);
            InterpartsServer interpartsServer = (InterpartsServer)this.m_serverMap.get(serverName);
            try {
                interpartsServer.stop();
                continue;
            }
            catch (Throwable throwable) {
                logger.error((Object)"Cannot destroy Interparts Server.", throwable);
            }
        }
        this.freeLogger();
    }

    private void freeLogger() {
        if (this.m_logInitialized) {
            try {
                if (this.m_fileAppender != null) {
                    this.m_fileAppender.close();
                    this.m_fileAppender = null;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (this.m_syslogAppender != null) {
                    this.m_syslogAppender.close();
                    this.m_syslogAppender = null;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.m_logInitialized = false;
        }
    }

    public InterpartsServlet getServlet() {
        return this.m_interpartsServlet;
    }

    public Properties getConfigProperties(HttpServletRequest httpServletRequest) throws NoServerException {
        InterpartsServer interpartsServer = this.getInterpartsServer(httpServletRequest);
        return interpartsServer.getConfigProperties(httpServletRequest);
    }

    public Configurator getConfigurator(HttpServletRequest httpServletRequest) throws NoServerException {
        InterpartsServer interpartsServer = this.getInterpartsServer(httpServletRequest);
        return interpartsServer.m_configurator;
    }

    public void checkAvailability(String serverName) throws Throwable {
        InterpartsServer interpartsServer = (InterpartsServer)this.m_serverMap.get(serverName);
        interpartsServer.checkAvailability();
    }

    public String getCommand(HttpServletRequest httpServletRequest) {
        String command = httpServletRequest.getParameter("command");
        return command;
    }

    private Locale[] getLocales(HttpServletRequest httpServletRequest) {
        String dataLocaleString = null;
        String guiLocaleString = null;
        try {
            Cookie[] cookies = httpServletRequest.getCookies();
            if (cookies != null) {
                for (int cookiesIndex = 0; cookiesIndex < cookies.length; ++cookiesIndex) {
                    String guiDataLocaleString;
                    Cookie cookie = cookies[cookiesIndex];
                    if (!"Language".equals(cookie.getName()) || (guiDataLocaleString = cookie.getValue()) == null || "".equals(guiDataLocaleString)) continue;
                    String[] guiDataLocales = guiDataLocaleString.indexOf("%7C") != -1 ? StringUtil.split(guiDataLocaleString, "%7C") : StringUtil.split(guiDataLocaleString, "|");
                    if (guiDataLocales.length >= 1) {
                        guiLocaleString = guiDataLocales[0];
                    }
                    if (guiDataLocales.length >= 2) {
                        dataLocaleString = guiDataLocales[1];
                    }
                    logger.debug((Object)("[1] DataLocaleString: " + dataLocaleString + "   GuiLocaleString: " + guiLocaleString));
                    break;
                }
            }
            HttpSession httpSession = httpServletRequest.getSession(true);
            try {
                String guiLocaleParameter = httpServletRequest.getParameter("language");
                if (guiLocaleParameter != null && !"".equals(guiLocaleParameter)) {
                    guiLocaleString = guiLocaleParameter;
                    logger.debug((Object)("[2] DataLocaleString: " + dataLocaleString + "   GuiLocaleString: " + guiLocaleString));
                }
            }
            catch (Exception exception) {
                logger.error((Object)exception, (Throwable)exception);
            }
            try {
                String dataLocaleParameter = httpServletRequest.getParameter("dataLanguage");
                if (dataLocaleParameter != null && !"".equals(dataLocaleParameter)) {
                    dataLocaleString = dataLocaleParameter;
                    logger.debug((Object)("[3] DataLocaleString: " + dataLocaleString + "   GuiLocaleString: " + guiLocaleString));
                }
            }
            catch (Exception exception) {
                logger.error((Object)exception, (Throwable)exception);
            }
            if (dataLocaleString == null) {
                dataLocaleString = (String)httpSession.getAttribute("interpartsserver.locale");
                logger.debug((Object)("[4] DataLocaleString: " + dataLocaleString + "   GuiLocaleString: " + guiLocaleString));
            }
            if (guiLocaleString == null) {
                guiLocaleString = (String)httpSession.getAttribute("interpartsserver.guilocale");
                logger.debug((Object)("[5] DataLocaleString: " + dataLocaleString + "   GuiLocaleString: " + guiLocaleString));
            }
            if (guiLocaleString == null) {
                guiLocaleString = dataLocaleString;
            }
            if (dataLocaleString == null) {
                dataLocaleString = guiLocaleString;
            }
            if (guiLocaleString == null) {
                guiLocaleString = httpServletRequest.getParameter("fallbacklocale");
            }
            if (dataLocaleString == null) {
                dataLocaleString = httpServletRequest.getParameter("fallbacklocale");
            }
            if (guiLocaleString == null) {
                guiLocaleString = this.m_fallbackLocale;
            }
            if (dataLocaleString == null) {
                dataLocaleString = this.m_fallbackLocale;
            }
            httpSession.setAttribute("interpartsserver.locale", (Object)dataLocaleString);
            httpSession.setAttribute("interpartsserver.guilocale", (Object)guiLocaleString);
            try {
                String quickLocaleString = httpServletRequest.getParameter("quicklocale");
                if (quickLocaleString != null) {
                    dataLocaleString = quickLocaleString;
                }
            }
            catch (Exception exception) {
                logger.error((Object)exception, (Throwable)exception);
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception, (Throwable)exception);
        }
        logger.debug((Object)("[6] DataLocaleString: " + dataLocaleString + "   GuiLocaleString: " + guiLocaleString));
        Locale dataLocale = this.makeLocale(dataLocaleString);
        Locale guiLocale = this.makeLocale(guiLocaleString);
        String dbLocaleString = this.makeDbLocaleString(dataLocale);
        ParameterContainer parameterContainer = new ParameterContainer(httpServletRequest, this.m_configurator);
        parameterContainer.setResponderVariable("language", dataLocale.getLanguage().toLowerCase());
        parameterContainer.setResponderVariable("country", dataLocale.getCountry().toLowerCase());
        parameterContainer.setResponderVariable("locale", dataLocale.toString().toLowerCase());
        parameterContainer.setResponderVariable("guilanguage", guiLocale.getLanguage().toLowerCase());
        parameterContainer.setResponderVariable("guicountry", guiLocale.getCountry().toLowerCase());
        parameterContainer.setResponderVariable("guilocale", guiLocale.toString().toLowerCase());
        parameterContainer.setResponderVariable("dblocale", dbLocaleString);
        logger.debug((Object)("[final] DataLocale: " + dataLocale + "   GuiLocale: " + guiLocale));
        return new Locale[]{dataLocale, guiLocale};
    }

    public Locale getDataLocale(HttpServletRequest httpServletRequest) {
        return this.getLocales(httpServletRequest)[0];
    }

    public Locale getGuiLocale(HttpServletRequest httpServletRequest) {
        return this.getLocales(httpServletRequest)[1];
    }

    private String makeDbLocaleString(Locale dataLocale) {
        if ("00".equals(dataLocale.getLanguage()) && "00".equals(dataLocale.getCountry())) {
            return "";
        }
        if ("00".equals(dataLocale.getCountry())) {
            return "_" + dataLocale.getLanguage();
        }
        return "_" + (dataLocale.getLanguage() + dataLocale.getCountry()).toLowerCase();
    }

    private Locale makeLocale(String localeString) {
        Locale locale = new Locale("00", "00");
        if (localeString != null) {
            String language = "00";
            String country = "00";
            if (localeString.length() >= 2) {
                language = localeString.substring(0, 2).toLowerCase();
            }
            if (localeString.length() >= 5) {
                country = localeString.substring(3, 5).toUpperCase();
            }
            locale = new Locale(language, country);
        }
        return locale;
    }

    public String getWebAppBase(HttpServletRequest httpServletRequest) {
        if (this.m_webAppBase != null) {
            return this.m_webAppBase;
        }
        String servletPath = httpServletRequest.getServletPath();
        int lastIndex = servletPath.lastIndexOf(47);
        if (lastIndex > 0) {
            return httpServletRequest.getContextPath() + "/" + servletPath.substring(1, lastIndex) + "/";
        }
        return httpServletRequest.getContextPath() + "/";
    }

    public boolean doLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String queryName, String passwordParameter, String randomString, String md5String) throws ServletException {
        try {
            InterpartsServer interpartsServer = this.getInterpartsServer(httpServletRequest);
            return interpartsServer.doLogin(httpServletRequest, httpServletResponse, queryName, passwordParameter, randomString, md5String);
        }
        catch (NoServerException noServerException) {
            throw new ServletException("Interparts Server not found");
        }
    }

    public void initDatabaseManager(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        try {
            this.getLocales(httpServletRequest);
            InterpartsServer interpartsServer = this.getInterpartsServer(httpServletRequest);
            interpartsServer.initDatabaseManager();
        }
        catch (NoServerException noServerException) {
            throw new ServletException("Interparts Server not found");
        }
    }

    public void finishDatabaseManager(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        try {
            InterpartsServer interpartsServer = this.getInterpartsServer(httpServletRequest);
            interpartsServer.finishDatabaseManager();
        }
        catch (NoServerException noServerException) {
            throw new ServletException("Interparts Server not found");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

