/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.interpartsserver3;

import com.belenus.util.StringUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class StoredCall {
    protected static ArrayList s_storedCalls = new ArrayList();
    protected static Random s_random = new Random();
    public static long s_timeToLive = 60000L;
    protected long m_deathTime;
    protected String m_id;
    protected HashMap m_requestParameterMap = new HashMap();
    protected HashMap m_sessionAttributeMap = new HashMap();

    protected StoredCall(HttpServletRequest httpServletRequest) {
        this.m_deathTime = System.currentTimeMillis() + s_timeToLive;
        this.m_id = Long.toHexString(s_random.nextLong());
        this.storeRequestParameters(httpServletRequest);
        this.storeSessionAttributes(httpServletRequest);
    }

    private void storeRequestParameters(HttpServletRequest httpServletRequest) {
        Enumeration requestParameterNamesEnumeration = httpServletRequest.getParameterNames();
        while (requestParameterNamesEnumeration.hasMoreElements()) {
            String parameterName = (String)requestParameterNamesEnumeration.nextElement();
            String parameterValue = httpServletRequest.getParameter(parameterName);
            this.m_requestParameterMap.put(parameterName, parameterValue);
        }
    }

    private void storeSessionAttributes(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession();
        Enumeration sessionAttributeNamesEnumeration = httpSession.getAttributeNames();
        while (sessionAttributeNamesEnumeration.hasMoreElements()) {
            String attributeName = (String)sessionAttributeNamesEnumeration.nextElement();
            Object attributeValue = httpSession.getAttribute(attributeName);
            if (!(attributeValue instanceof String)) continue;
            this.m_sessionAttributeMap.put(attributeName, (String)attributeValue);
        }
    }

    public String getId() {
        return this.m_id;
    }

    public long getDeathTime() {
        return this.m_deathTime;
    }

    public void setAttribute(String key, String value) {
        this.m_requestParameterMap.remove(key);
        this.m_requestParameterMap.put(key, value);
    }

    public String getAttribute(String key) {
        return (String)this.m_requestParameterMap.get(key);
    }

    public String writeRequestAsJS(String variable) {
        String result = "";
        Set requestParameterMapEntrySet = this.m_requestParameterMap.entrySet();
        Iterator entrySetIterator = requestParameterMapEntrySet.iterator();
        while (entrySetIterator.hasNext()) {
            Map.Entry mapEntry = entrySetIterator.next();
            String key = (String)mapEntry.getKey();
            String value = (String)mapEntry.getValue();
            result = result + variable + "[" + StringUtil.encodeForJS(key) + "]=" + StringUtil.encodeForJS(value) + "; ";
        }
        return result;
    }

    public void restoreAsRequestAttributesAndSession(HttpServletRequest httpServletRequest, String requestPrefix, String sessionPrefix) {
        this.restoreRequestAttributes(httpServletRequest, requestPrefix);
        this.restoreSessionAttributes(httpServletRequest, sessionPrefix);
    }

    private void restoreRequestAttributes(HttpServletRequest httpServletRequest, String prefix) {
        Set requestParameterMapEntrySet = this.m_requestParameterMap.entrySet();
        Iterator entrySetIterator = requestParameterMapEntrySet.iterator();
        while (entrySetIterator.hasNext()) {
            Map.Entry mapEntry = entrySetIterator.next();
            String key = (String)mapEntry.getKey();
            String value = (String)mapEntry.getValue();
            httpServletRequest.setAttribute(prefix + key, (Object)value);
        }
    }

    private void restoreSessionAttributes(HttpServletRequest httpServletRequest, String prefix) {
        HttpSession httpSession = httpServletRequest.getSession();
        Set sessionAttributeMapEntrySet = this.m_sessionAttributeMap.entrySet();
        Iterator entrySetIterator = sessionAttributeMapEntrySet.iterator();
        while (entrySetIterator.hasNext()) {
            Map.Entry mapEntry = entrySetIterator.next();
            String key = (String)mapEntry.getKey();
            String value = (String)mapEntry.getValue();
            httpSession.setAttribute(prefix + key, (Object)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanCalls() {
        long currenTimeMillis = System.currentTimeMillis();
        ArrayList arrayList = s_storedCalls;
        synchronized (arrayList) {
            Iterator storedCallsIterator = s_storedCalls.iterator();
            while (storedCallsIterator.hasNext()) {
                StoredCall storedCall = (StoredCall)storedCallsIterator.next();
                if (storedCall.getDeathTime() >= currenTimeMillis) continue;
                storedCallsIterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StoredCall putCall(HttpServletRequest httpServletRequest) {
        ArrayList arrayList = s_storedCalls;
        synchronized (arrayList) {
            StoredCall.cleanCalls();
            StoredCall storedCall = new StoredCall(httpServletRequest);
            s_storedCalls.add(storedCall);
            return storedCall;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StoredCall getCall(String id) {
        ArrayList arrayList = s_storedCalls;
        synchronized (arrayList) {
            StoredCall.cleanCalls();
            if (id != null && !"".equals(id)) {
                for (int storedCallsIndex = 0; storedCallsIndex < s_storedCalls.size(); ++storedCallsIndex) {
                    StoredCall storedCall = (StoredCall)s_storedCalls.get(storedCallsIndex);
                    if (!storedCall.getId().equals(id)) continue;
                    return storedCall;
                }
            }
            return null;
        }
    }
}

