/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.interpartsserver3;

import com.belenus.dataconnect.DatabaseManager;
import com.belenus.dataconnect.ParameterContainer;
import com.belenus.dataconnect.ResultSetRowContainer;
import com.belenus.dataconnect.Row;
import com.belenus.dataconnect.RowContainer;
import com.belenus.dataconnect.Template;
import com.belenus.interpartsserver3.FileNote;
import com.belenus.interpartsserver3.InterpartsServer;
import com.belenus.interpartsserver3.Responder;
import com.belenus.interpartsserver3.Server;
import com.belenus.util.StringUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class TreeResponder
extends Responder {
    private static final Logger logger = Logger.getLogger((Class)(class$com$belenus$interpartsserver3$TreeResponder == null ? (class$com$belenus$interpartsserver3$TreeResponder = TreeResponder.class$("com.belenus.interpartsserver3.TreeResponder")) : class$com$belenus$interpartsserver3$TreeResponder));
    protected InterpartsServer m_interpartsServer;
    protected DatabaseManager m_databaseManager;
    protected Properties m_queryTemplates;
    protected Properties m_xslNames;
    protected Document m_document;
    static /* synthetic */ Class class$com$belenus$interpartsserver3$TreeResponder;

    public TreeResponder(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Server server) {
        super(httpServletRequest, httpServletResponse, server);
        this.m_interpartsServer = (InterpartsServer)this.m_server;
        this.m_databaseManager = this.m_interpartsServer.getDatabaseManager();
        this.m_queryTemplates = this.m_interpartsServer.m_treeQueries;
        this.m_xslNames = this.m_interpartsServer.m_treeXslNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void respond() throws Exception {
        block12: {
            this.m_databaseManager.startTransaction();
            String idParameter = this.m_httpServletRequest.getParameter("id");
            String queryParameter = this.m_httpServletRequest.getParameter("query");
            if (queryParameter == null) {
                throw new RuntimeException("Parameter query must be set.");
            }
            this.m_document = DocumentHelper.createDocument();
            String xslName = (String)this.m_xslNames.get(queryParameter);
            if (xslName != null) {
                HashMap<String, String> processingInstructionHashMap = new HashMap<String, String>();
                processingInstructionHashMap.put("type", "text/xsl");
                processingInstructionHashMap.put("href", xslName);
                this.m_document.addProcessingInstruction("xml-stylesheet", processingInstructionHashMap);
            }
            Element treeElement = this.constructTree(queryParameter, idParameter);
            this.m_document.add(treeElement);
            try {
                this.m_httpServletResponse.setContentType("text/xml");
                OutputStream outputStream = this.startOutputStream(true, true);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF8");
                this.m_document.write((Writer)outputStreamWriter);
                outputStreamWriter.flush();
                outputStreamWriter.close();
            }
            catch (IOException exc) {
            }
            Object var8_9 = null;
            try {
                this.m_databaseManager.finishTransaction();
            }
            catch (Exception exc2) {
                logger.error((Object)exc2, (Throwable)exc2);
            }
            break block12;
            {
                catch (Exception exc) {
                    logger.error((Object)exc, (Throwable)exc);
                    Object var8_10 = null;
                    try {
                        this.m_databaseManager.finishTransaction();
                    }
                    catch (Exception exc2) {
                        logger.error((Object)exc2, (Throwable)exc2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                try {
                    this.m_databaseManager.finishTransaction();
                }
                catch (Exception exc2) {
                    logger.error((Object)exc2, (Throwable)exc2);
                }
                throw throwable;
            }
        }
    }

    private Element buildEntryElement(Row row) throws SQLException {
        FileNote note;
        RowContainer rowContainer = row.getRowContainer();
        String typeEntry = row.getString("type_entry");
        String idObject = row.getString("id_object").trim();
        String idQuery = row.getString("id_query");
        String idDevice = row.getString("id_device");
        Element entryElement = DocumentHelper.createElement((String)typeEntry);
        if ("device".equals(typeEntry)) {
            String constructedHref = this.constructHref(row, typeEntry, idQuery, idDevice, null);
            this.addAttribute(entryElement, "itemlist_href", constructedHref);
            entryElement.addAttribute("id", idDevice);
        }
        entryElement.addAttribute("contextid", idObject);
        String[] attributeNamesByMeaning = rowContainer.getFieldNamesByMeaning("att");
        for (int attributeNamesByMeaningIndex = 0; attributeNamesByMeaningIndex < attributeNamesByMeaning.length; ++attributeNamesByMeaningIndex) {
            String attributeName = attributeNamesByMeaning[attributeNamesByMeaningIndex];
            String attribute = row.getString(attributeName).trim();
            String realAttributeName = attributeName.substring(4);
            if (attribute == null || attribute.equals("")) continue;
            entryElement.addAttribute(realAttributeName, attribute);
        }
        String[] fieldNamesByDescription = rowContainer.getFieldNamesByDescription("field_name");
        for (int fieldNamesByDescriptionIndex = 0; fieldNamesByDescriptionIndex < fieldNamesByDescription.length; ++fieldNamesByDescriptionIndex) {
            String fieldName = fieldNamesByDescription[fieldNamesByDescriptionIndex];
            Locale locale = rowContainer.getLocaleFromFieldName(fieldName);
            String field = row.getString(fieldName);
            Element aElement = entryElement.addElement("a");
            aElement.addText(field);
            if (locale != null) {
                this.addAttribute(aElement, "lang", locale.getLanguage());
                if (locale.getCountry() != null) {
                    this.addAttribute(aElement, "country", locale.getCountry());
                }
            }
            if ("device".equals(typeEntry)) continue;
            String constructedHref = this.constructHref(row, typeEntry, idQuery, idDevice, locale);
            this.addAttribute(aElement, "href", constructedHref);
        }
        String idNote = row.getString("id_note");
        if (this.m_interpartsServer.m_noteStorage != null && (note = this.m_interpartsServer.m_noteStorage.getFileNoteByIdObject(idObject)) != null) {
            idNote = note.getIdNote();
        }
        if (idNote != null && !idNote.equals("")) {
            Element noteElement = entryElement.addElement("note");
            noteElement.addAttribute("id", idNote);
        }
        return entryElement;
    }

    private String constructHref(Row row, String entryType, String idQuery, String idDevice, Locale locale) {
        String href = row.getString("href_name", locale, true);
        String constructedHref = null;
        if (href != null && !href.equals("")) {
            constructedHref = this.m_interpartsServer.m_dataPath + href;
        }
        if (idQuery != null && !idQuery.equals("") && idDevice != null && !idDevice.equals("")) {
            String[] queryIdSplitted = StringUtil.split(idQuery, ".");
            String command = queryIdSplitted.length == 1 ? entryType : queryIdSplitted[0];
            String query = queryIdSplitted.length == 1 ? queryIdSplitted[0] : queryIdSplitted[1];
            constructedHref = this.m_interpartsServer.m_serverDispatcher.getWebAppBase(this.m_httpServletRequest) + "server?command=" + command + "&query=" + query + "&id=" + idDevice;
        }
        return constructedHref;
    }

    private Element constructTree(String queryParameter, String idParameter) throws Exception {
        Element treeElement = DocumentHelper.createElement((String)"tree");
        treeElement.addAttribute("contextid", idParameter);
        String queryTemplate = (String)this.m_queryTemplates.get(queryParameter);
        if (queryTemplate == null) {
            throw new RuntimeException("Call with parameter query=" + queryParameter + " not in properties-file.");
        }
        Template template = new Template(queryTemplate, new ParameterContainer(this.m_httpServletRequest, this.m_configurator));
        ResultSetRowContainer rowContainer = new ResultSetRowContainer(this.m_databaseManager, template);
        while (rowContainer.hasNext()) {
            Row row = rowContainer.nextRow();
            String parentid = row.getString("id_parent").trim();
            treeElement.addAttribute("contextid", parentid);
            Element entryElement = this.buildEntryElement(row);
            treeElement.add(entryElement);
        }
        return treeElement;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

