/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.util;

public final class CharArray {
    private static final char[] radixTenTenths = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    private static final char[] radixTenUnits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final char[] AMP = "&".toCharArray();
    private static final char[] AMP_ENC = "&amp;".toCharArray();
    private static final char[] LT = "<".toCharArray();
    private static final char[] LT_ENC = "&lt;".toCharArray();
    private static final char[] GT = ">".toCharArray();
    private static final char[] GT_ENC = "&gt;".toCharArray();
    private static final char[] QUOT = "\"".toCharArray();
    private static final char[] QUOT_ENC = "&quot;".toCharArray();

    public static void write2Digits(char[] dest, int position, int number) throws IllegalArgumentException {
        if (number < 0 && number > 99) {
            throw new IllegalArgumentException("write2Digits(): number needs to be between 0 and 99 (including)");
        }
        dest[position] = radixTenTenths[number];
        dest[position + 1] = radixTenUnits[number];
    }

    public static int read2Digits(char[] source, int position) throws NumberFormatException {
        int highdigit = source[position] - 48;
        int lowdigit = source[position + 1] - 48;
        if (highdigit < 0 || highdigit > 9 || lowdigit < 0 || lowdigit > 9) {
            throw new NumberFormatException("No decimal digits at positions " + position + ", " + (position + 1) + " of '" + new String(source) + "'.");
        }
        return highdigit * 10 + lowdigit;
    }

    public static char[] copy(char[] source) {
        return CharArray.copy(source, 0, source.length);
    }

    public static char[] copy(char[] source, int fromIndex, int length) {
        char[] result = new char[length];
        System.arraycopy(source, fromIndex, result, 0, length);
        return result;
    }

    public static char[] replaceAll(char[] work, char[] replace, char[] replaceWith) {
        return CharArray.replaceAll(work, replace, replaceWith, 0, work.length);
    }

    public static char[] replaceAll(char[] work, char[][][] searchForsAndReplaceWiths) {
        for (int searchForsAndReplaceWithsIndex = 0; searchForsAndReplaceWithsIndex < searchForsAndReplaceWiths.length; ++searchForsAndReplaceWithsIndex) {
            char[][] searchForsAndReplaceWith = searchForsAndReplaceWiths[searchForsAndReplaceWithsIndex];
            if (searchForsAndReplaceWith.length != 2) {
                throw new IllegalArgumentException("SearchFors and ReplaceWiths are not of equal count.");
            }
            char[] searchFor = searchForsAndReplaceWith[0];
            char[] replaceWith = searchForsAndReplaceWith[1];
            work = CharArray.replaceAll(work, searchFor, replaceWith);
        }
        return work;
    }

    public static char[] replaceAll(char[] work, char[] replace, char[] replacewith, int fromIndex, int length) {
        int worklength = length;
        int replacelength = replace.length;
        int replacewithlength = replacewith.length;
        int position = fromIndex;
        if (replacelength == replacewithlength) {
            if (fromIndex != 0 || length != work.length) {
                char[] result = new char[length];
                System.arraycopy(work, fromIndex, result, 0, length);
                work = result;
                position = 0;
            }
            position = CharArray.indexOf(work, replace, position);
            while (position != -1) {
                System.arraycopy(replacewith, 0, work, position, replacewithlength);
                position += replacelength;
                position = CharArray.indexOf(work, replace, position);
            }
            return work;
        }
        int occurences = 0;
        while ((position = CharArray.indexOf(work, replace, position)) != -1 && position <= fromIndex + worklength) {
            ++occurences;
            position += replacelength;
        }
        if (occurences == 0) {
            if (fromIndex == 0 && length == work.length) {
                return work;
            }
            char[] result = new char[length];
            System.arraycopy(work, fromIndex, result, 0, length);
            return result;
        }
        int resultlength = worklength + occurences * (replacewithlength - replacelength);
        char[] result = new char[resultlength];
        int oldposition = position = fromIndex;
        int destposition = 0;
        do {
            position = CharArray.indexOf(work, replace, position);
            int copylength = position - oldposition;
            System.arraycopy(work, oldposition, result, destposition, copylength);
            System.arraycopy(replacewith, 0, result, destposition += copylength, replacewithlength);
            destposition += replacewithlength;
            oldposition = position += replacelength;
        } while (--occurences > 0);
        System.arraycopy(work, position, result, destposition, worklength - position);
        return result;
    }

    public static int indexOf(char[] v1, char[] v2) {
        return CharArray.indexOf(v1, v2, 0);
    }

    public static int indexOf(char[] v1, char[] v2, int fromIndex) {
        int max = v1.length - v2.length;
        if (fromIndex >= v1.length) {
            if (v1.length == 0 && fromIndex == 0 && v2.length == 0) {
                return 0;
            }
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (v2.length == 0) {
            return fromIndex;
        }
        char first = v2[0];
        int i = fromIndex;
        block0: while (true) {
            if (i <= max && v1[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + v2.length - 1;
            int k = 1;
            while (j < end) {
                if (v1[j++] == v2[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static char[] encodeForSGML(char[] work) {
        work = CharArray.replaceAll(work, AMP, AMP_ENC);
        work = CharArray.replaceAll(work, LT, LT_ENC);
        work = CharArray.replaceAll(work, GT, GT_ENC);
        work = CharArray.replaceAll(work, QUOT, QUOT_ENC);
        return work;
    }

    public static char[] decodeFromSGML(char[] work) {
        work = CharArray.replaceAll(work, QUOT_ENC, QUOT);
        work = CharArray.replaceAll(work, GT_ENC, GT);
        work = CharArray.replaceAll(work, LT_ENC, LT);
        work = CharArray.replaceAll(work, AMP_ENC, AMP);
        return work;
    }
}

