/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.util;

import com.belenus.util.CharArray;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;

public class StringUtil {
    private static final char[] AMP = "&".toCharArray();
    private static final char[] AMP_ENC = "&amp;".toCharArray();
    private static final char[] LT = "<".toCharArray();
    private static final char[] LT_ENC = "&lt;".toCharArray();
    private static final char[] GT = ">".toCharArray();
    private static final char[] GT_ENC = "&gt;".toCharArray();
    private static final char[] QUOT = "\"".toCharArray();
    private static final char[] QUOT_ENC = "&quot;".toCharArray();
    private static final char[] QUOT_ENC_JS = "\\22".toCharArray();
    private static final char[] APOS = "'".toCharArray();
    private static final char[] APOS_ENC = "&#39;".toCharArray();
    private static final char[] APOS_ENC_JS = "\\27".toCharArray();
    private static final char[] BS = "\\".toCharArray();
    private static final char[] BS_ENC_JS = "\\u005c".toCharArray();
    private static final char[] NL = "\n".toCharArray();
    private static final char[] NL_ENC_JS = "\\n".toCharArray();
    private static final char[] CR = "\r".toCharArray();
    private static final char[] CR_ENC_JS = "\\r".toCharArray();

    private StringUtil() {
    }

    public static String[] split(String input, String delimeter, boolean trimmed) {
        String current;
        int newPosition;
        if (input == null) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        int oldPosition = 0;
        while ((newPosition = input.indexOf(delimeter, oldPosition)) != -1) {
            current = input.substring(oldPosition, newPosition);
            result.add(trimmed ? current.trim() : current);
            oldPosition = newPosition + delimeter.length();
        }
        current = input.substring(oldPosition);
        result.add(trimmed ? current.trim() : current);
        return result.toArray(new String[result.size()]);
    }

    public static String[] split(String input, String delimeter) {
        return StringUtil.split(input, delimeter, false);
    }

    public static String[] splitInTwo(String input, String delimeter) {
        String[] result = new String[2];
        if (input != null) {
            int position = input.indexOf(delimeter);
            if (position < 0) {
                result[0] = input;
            } else {
                result[0] = input.substring(0, position);
                result[1] = input.substring(position + delimeter.length());
            }
        }
        return result;
    }

    public static String join(String[] input, String delimeter) {
        StringBuffer result = new StringBuffer();
        for (int inputIndex = 0; inputIndex < input.length; ++inputIndex) {
            String inputValue = input[inputIndex];
            if (inputValue == null) continue;
            if (result.length() > 0) {
                result.append(delimeter);
            }
            result.append(inputValue);
        }
        return result.toString();
    }

    private static int indexOf(char[] v1, char[] v2, int fromIndex) {
        int max = v1.length - v2.length;
        if (fromIndex >= v1.length) {
            if (v1.length == 0 && fromIndex == 0 && v2.length == 0) {
                return 0;
            }
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (v2.length == 0) {
            return fromIndex;
        }
        char first = v2[0];
        int i = fromIndex;
        block0: while (true) {
            if (i <= max && v1[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + v2.length - 1;
            int k = 1;
            while (j < end) {
                if (v1[j++] == v2[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    private static char[] replaceAll(char[] work, char[] replace, char[] replacewith, int fromIndex, int length) {
        int worklength = length;
        int replacelength = replace.length;
        int replacewithlength = replacewith.length;
        int position = fromIndex;
        if (replacelength == replacewithlength) {
            if (fromIndex != 0 || length != work.length) {
                char[] result = new char[length];
                System.arraycopy(work, fromIndex, result, 0, length);
                work = result;
                position = 0;
            }
            position = StringUtil.indexOf(work, replace, position);
            while (position != -1) {
                System.arraycopy(replacewith, 0, work, position, replacewithlength);
                position += replacelength;
                position = StringUtil.indexOf(work, replace, position);
            }
            return work;
        }
        int occurences = 0;
        while ((position = StringUtil.indexOf(work, replace, position)) != -1 && position <= fromIndex + worklength) {
            ++occurences;
            position += replacelength;
        }
        if (occurences == 0) {
            if (fromIndex == 0 && length == work.length) {
                return work;
            }
            char[] result = new char[length];
            System.arraycopy(work, fromIndex, result, 0, length);
            return result;
        }
        int resultlength = worklength + occurences * (replacewithlength - replacelength);
        char[] result = new char[resultlength];
        int oldposition = position = fromIndex;
        int destposition = 0;
        do {
            position = StringUtil.indexOf(work, replace, position);
            int copylength = position - oldposition;
            System.arraycopy(work, oldposition, result, destposition, copylength);
            System.arraycopy(replacewith, 0, result, destposition += copylength, replacewithlength);
            destposition += replacewithlength;
            oldposition = position += replacelength;
        } while (--occurences > 0);
        System.arraycopy(work, position, result, destposition, worklength - position);
        return result;
    }

    public static String replaceAll(String work, String searchFor, String replaceWith) {
        return new String(StringUtil.replaceAll(work.toCharArray(), searchFor.toCharArray(), replaceWith.toCharArray(), 0, work.length()));
    }

    public static String replaceAll(String workString, String[] searchFors, String[] replaceWiths) {
        if (searchFors.length != replaceWiths.length) {
            throw new IllegalArgumentException("SearchFors and ReplaceWiths are not of equal count.");
        }
        char[] work = workString.toCharArray();
        for (int searchForsIndex = 0; searchForsIndex < searchFors.length; ++searchForsIndex) {
            String searchFor = searchFors[searchForsIndex];
            String replaceWith = replaceWiths[searchForsIndex];
            work = CharArray.replaceAll(work, searchFor.toCharArray(), replaceWith.toCharArray());
        }
        return new String(work);
    }

    public static String encodeForSGML(String input) {
        if (input != null) {
            char[] work = input.toCharArray();
            work = StringUtil.replaceAll(work, AMP, AMP_ENC, 0, work.length);
            work = StringUtil.replaceAll(work, LT, LT_ENC, 0, work.length);
            work = StringUtil.replaceAll(work, GT, GT_ENC, 0, work.length);
            work = StringUtil.replaceAll(work, QUOT, QUOT_ENC, 0, work.length);
            work = StringUtil.replaceAll(work, APOS, APOS_ENC, 0, work.length);
            return new String(work);
        }
        return null;
    }

    public static String encodeForSGMLForASCIIOutput(String input) {
        if (input != null) {
            char[] work = input.toCharArray();
            work = StringUtil.replaceAll(work, AMP, AMP_ENC, 0, work.length);
            work = StringUtil.replaceAll(work, LT, LT_ENC, 0, work.length);
            work = StringUtil.replaceAll(work, GT, GT_ENC, 0, work.length);
            work = StringUtil.replaceAll(work, QUOT, QUOT_ENC, 0, work.length);
            work = StringUtil.replaceAll(work, APOS, APOS_ENC, 0, work.length);
            StringBuffer result = new StringBuffer();
            for (int workIndex = 0; workIndex < work.length; ++workIndex) {
                char ch = work[workIndex];
                if (ch >= ' ' && ch < '\u007f') {
                    result.append(ch);
                    continue;
                }
                result.append("&#").append(Integer.toString(ch)).append(';');
            }
            return result.toString();
        }
        return null;
    }

    public static String decodeFromSGML(String input) {
        if (input != null) {
            char[] work = input.toCharArray();
            work = StringUtil.replaceAll(work, APOS_ENC, APOS, 0, work.length);
            work = StringUtil.replaceAll(work, QUOT_ENC, QUOT, 0, work.length);
            work = StringUtil.replaceAll(work, GT_ENC, GT, 0, work.length);
            work = StringUtil.replaceAll(work, LT_ENC, LT, 0, work.length);
            work = StringUtil.replaceAll(work, AMP_ENC, AMP, 0, work.length);
            return new String(work);
        }
        return null;
    }

    private static char hexChar(char input) {
        int out = input < '\n' ? input + 48 : input + 65 - 10;
        return (char)out;
    }

    public static String encodeForURL(String input) {
        if (input != null) {
            StringBuffer output = new StringBuffer(input.length());
            for (int inputIndex = 0; inputIndex < input.length(); ++inputIndex) {
                char ch = input.charAt(inputIndex);
                if (ch != '%' && ch != '&' && ch != '=') {
                    output.append(ch);
                    continue;
                }
                output.append('%').append(StringUtil.hexChar((char)((ch & 0xF0) >> 4))).append(StringUtil.hexChar((char)(ch & 0xF)));
            }
            return output.toString();
        }
        return null;
    }

    public static String encodeForJS(String input, boolean useDoubleQuotes) {
        if (input != null) {
            char[] work = input.toCharArray();
            work = StringUtil.replaceAll(work, BS, BS_ENC_JS, 0, work.length);
            work = StringUtil.replaceAll(work, QUOT, QUOT_ENC_JS, 0, work.length);
            work = StringUtil.replaceAll(work, APOS, APOS_ENC_JS, 0, work.length);
            work = StringUtil.replaceAll(work, NL, NL_ENC_JS, 0, work.length);
            work = StringUtil.replaceAll(work, CR, CR_ENC_JS, 0, work.length);
            return (useDoubleQuotes ? "\"" : "'") + new String(work) + (useDoubleQuotes ? "\"" : "'");
        }
        return null;
    }

    public static String encodeForJS(String input) {
        return StringUtil.encodeForJS(input, true);
    }

    public static String encodeForJSForASCIIOutput(String input, boolean useDoubleQuotes) {
        if (input != null) {
            char[] work = input.toCharArray();
            work = StringUtil.replaceAll(work, BS, BS_ENC_JS, 0, work.length);
            work = StringUtil.replaceAll(work, QUOT, QUOT_ENC_JS, 0, work.length);
            work = StringUtil.replaceAll(work, APOS, APOS_ENC_JS, 0, work.length);
            work = StringUtil.replaceAll(work, NL, NL_ENC_JS, 0, work.length);
            work = StringUtil.replaceAll(work, CR, CR_ENC_JS, 0, work.length);
            StringBuffer result = new StringBuffer();
            for (int workIndex = 0; workIndex < work.length; ++workIndex) {
                char ch = work[workIndex];
                if (ch >= ' ' && ch < '\u007f') {
                    result.append(ch);
                    continue;
                }
                String hexString = "0000" + Integer.toHexString(ch);
                hexString = hexString.substring(hexString.length() - 4);
                result.append("\\u").append(hexString);
            }
            return (useDoubleQuotes ? "\"" : "'") + result.toString() + (useDoubleQuotes ? "\"" : "'");
        }
        return null;
    }

    public static String encodeForJSForASCIIOutput(String input) {
        return StringUtil.encodeForJSForASCIIOutput(input, true);
    }

    public static String toString(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public static String decodeUTF8(String input) {
        String result1 = StringUtil.decodeUTF8Version1(input);
        String result2 = StringUtil.decodeUTF8Version2(input);
        if (!result2.equals(result1)) {
            System.err.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! decodeUTF8 versions different: \"" + result1 + "\" != \"" + result2 + "\"");
        }
        return result1;
    }

    public static String decodeUTF8Version1(String input) {
        try {
            CharsetDecoder charsetDecoder = Charset.forName("UTF-8").newDecoder();
            ByteBuffer byteBuffer = ByteBuffer.allocate(input.length());
            for (int inputIndex = 0; inputIndex < input.length(); ++inputIndex) {
                byteBuffer.put((byte)input.charAt(inputIndex));
            }
            byteBuffer.rewind();
            CharBuffer charBuffer = charsetDecoder.decode(byteBuffer);
            charBuffer.rewind();
            String result = charBuffer.toString();
            return result;
        }
        catch (CharacterCodingException characterCodingException) {
            System.err.println("decodeUTF8 skipped: " + input);
            return input;
        }
    }

    public static String decodeUTF8Version2(String input) {
        boolean valid = true;
        StringBuffer result = new StringBuffer(input.length());
        try {
            for (int inputIndex = 0; inputIndex < input.length(); ++inputIndex) {
                char ch1;
                char ch0 = input.charAt(inputIndex);
                if (ch0 <= '\u007f') {
                    char value = ch0;
                    result.append(value);
                    continue;
                }
                if (ch0 >= '\u00c0' && ch0 <= '\u00df') {
                    ch1 = input.charAt(++inputIndex);
                    char value = (char)(((ch0 & 0x1F) << 6) + (ch1 & 0x3F));
                    result.append(value);
                    continue;
                }
                if (ch0 >= '\u00e0' && ch0 <= '\u00ef') {
                    ch1 = input.charAt(++inputIndex);
                    char ch2 = input.charAt(++inputIndex);
                    char value = (char)(((ch0 & 0xF) << 12) + ((ch1 & 0x3F) << 6) + (ch2 & 0x3F));
                    result.append(value);
                    continue;
                }
                valid = false;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            valid = false;
        }
        if (!valid) {
            System.err.println("decodeUTF8 invalid: " + input);
        }
        return result.toString();
    }

    public static String encodeUTF8(String input) {
        String result1 = StringUtil.encodeUTF8Version1(input);
        String result2 = StringUtil.encodeUTF8Version2(input);
        if (!result2.equals(result1)) {
            System.err.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! encodeUTF8 versions different: \"" + result1 + "\" != \"" + result2 + "\"");
        }
        return result1;
    }

    public static String encodeUTF8Version1(String input) {
        try {
            CharsetEncoder charsetEncoder = Charset.forName("UTF-8").newEncoder();
            CharBuffer charBuffer = CharBuffer.wrap(input.toCharArray());
            charBuffer.rewind();
            ByteBuffer byteBuffer = charsetEncoder.encode(charBuffer);
            byteBuffer.rewind();
            StringBuffer output = new StringBuffer(input.length());
            while (byteBuffer.hasRemaining()) {
                output.append(byteBuffer.getChar());
            }
            String result = output.toString();
            return result;
        }
        catch (CharacterCodingException characterCodingException) {
            System.err.println("encodeUTF8 skipped: " + input);
            return input;
        }
    }

    public static String encodeUTF8Version2(String input) {
        StringBuffer result = new StringBuffer(input.length() * 2);
        for (int inputIndex = 0; inputIndex < input.length(); ++inputIndex) {
            char ch = input.charAt(inputIndex);
            if (ch <= '\u007f') {
                result.append(ch);
                continue;
            }
            if (ch <= '\u07ff') {
                result.append((char)(ch >> 6 | 0xC0));
                result.append((char)(ch & 0x3F | 0x80));
                continue;
            }
            result.append((char)(ch >> 12 | 0xE0));
            result.append((char)(ch >> 6 & 0x3F | 0x80));
            result.append((char)(ch & 0x3F | 0x80));
        }
        return result.toString();
    }

    public static String asHex(String input) {
        StringBuffer result = new StringBuffer();
        for (int inputLengthIndex = 0; inputLengthIndex < input.length(); ++inputLengthIndex) {
            if (result.length() > 0) {
                result.append(", ");
            }
            char ch = input.charAt(inputLengthIndex);
            result.append(StringUtil.hexDigit((ch & 0xF000) >> 12));
            result.append(StringUtil.hexDigit((ch & 0xF00) >> 8));
            result.append(StringUtil.hexDigit((ch & 0xF0) >> 4));
            result.append(StringUtil.hexDigit((ch & 0xF) >> 0));
        }
        return result.toString();
    }

    private static char hexDigit(int input) {
        if (input < 0 || input > 15) {
            throw new IllegalArgumentException("hexDigit: Input may be only between 0x0000 and 0x000F");
        }
        return (char)(input <= 9 ? input + 48 : input - 10 + 65);
    }
}

