/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import com.sun.javaws.Resources;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.security.CertificateInfo;
import com.sun.javaws.security.KeyStoreManager;
import com.sun.javaws.security.SunSecurityUtil;
import com.sun.javaws.ui.general.AbstractController;
import com.sun.javaws.ui.general.GeneralUtilities;
import com.sun.javaws.ui.general.GridBagHelper;
import com.sun.javaws.ui.general.LineBorder;
import com.sun.javaws.ui.general.PropertyPanel;
import com.sun.javaws.ui.general.Subcontroller;
import com.sun.javaws.util.BASE64Encoder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class CertificatePanel
extends PropertyPanel
implements ChangeListener {
    private JSplitPane _spane;
    private AbstractController _controller;
    private CertificateInfo[][] _certificates;
    private Frame _frame;
    private Vector _aliases = new Vector();
    private Certificate[][] _certs;
    private boolean _allowAliasSelection = false;
    private boolean _standAlone = false;
    private boolean _showImportExport = false;
    private int _selectedIndex = 0;
    JComboBox _aliasList = null;
    private final String DEFAULT_CERTIFICATE_ALIAS = "mykey";
    private AncestorListener _aliasAncestorListener = new aliasComboAncestorListener(this);
    private ActionListener _aliasActionListener = new aliasComboActionListener(this);

    private int getSelectedIndex() {
        return this._selectedIndex;
    }

    public CertificatePanel() {
        this(true, false, true);
    }

    private void createComponents() {
        this._spane = new JSplitPane();
        this._controller.setActiveSubcontrollerIndex(0);
        Component component = this._controller.getActiveSubcontroller().getComponent();
        this._spane.setLeftComponent(component);
        this._controller.setActiveSubcontrollerIndex(1);
        Component component2 = this._controller.getActiveSubcontroller().getComponent();
        this._spane.setRightComponent(component2);
        this._spane.setDividerLocation(225);
    }

    protected void createPropertyControls() {
        this._controller = new AbstractController(this){
            private final CertificatePanel this$0;
            {
                this.this$0 = certificatePanel;
            }

            protected Subcontroller createSubcontroller(int n) {
                switch (n) {
                    case 0: {
                        return new GeneralPanel(this.this$0, null);
                    }
                }
                return new CertPathPanel(this.this$0, null);
            }
        };
        this.updateData(false);
        this.createComponents();
        this.setSelectedTab(0);
    }

    private void setSelectedTab(int n) {
        if (n != this._controller.getActiveSubcontrollerIndex()) {
            Subcontroller subcontroller = this._controller.getSubcontroller(n);
            this._controller.setActiveSubcontrollerIndex(n);
            if (subcontroller == null) {
                this._controller.setActiveSubcontrollerIndex(0);
                Component component = this._controller.getActiveSubcontroller().getComponent();
                this._spane.setLeftComponent(component);
                this._controller.setActiveSubcontrollerIndex(1);
                Component component2 = this._controller.getActiveSubcontroller().getComponent();
                this._spane.setRightComponent(component2);
            }
        }
    }

    public void setVisible(boolean bl) {
        this.setVisible(bl, this._selectedIndex);
    }

    private void updateData(boolean bl) {
        if (this._standAlone) {
            return;
        }
        KeyStore keyStore = null;
        Enumeration<String> enumeration = null;
        if (bl) {
            this._aliases = new Vector();
        }
        try {
            keyStore = KeyStoreManager.getKeyStore();
            if (keyStore == null) {
                return;
            }
            enumeration = keyStore.aliases();
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace();
        }
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            this._aliases.addElement(string);
        }
        Collections.sort(this._aliases);
        this._certs = new Certificate[this._aliases.size()][];
        this._certificates = new CertificateInfo[this._aliases.size()][];
        for (int i = 0; i < this._aliases.size(); ++i) {
            String string = (String)this._aliases.get(i);
            try {
                this._certs[i] = keyStore.getCertificateChain(string);
                if (this._certs[i] != null) {
                    this._certificates[i] = new CertificateInfo[this._certs[i].length];
                    for (int j = 0; j < this._certs[i].length; ++j) {
                        if (this._certs[i][j] == null) continue;
                        try {
                            this._certificates[i][j] = CertificateInfo.getCertificateInfo(this._certs[i][j]);
                            continue;
                        }
                        catch (CertificateException certificateException) {
                            Debug.ignoredException(certificateException);
                        }
                    }
                }
            }
            catch (KeyStoreException keyStoreException) {
                Debug.ignoredException(keyStoreException);
            }
            if (this._certs[i] != null) continue;
            this._certs[i] = new Certificate[1];
            try {
                this._certs[i][0] = keyStore.getCertificate(string);
                if (this._certs[i][0] == null) continue;
                this._certificates[i] = new CertificateInfo[1];
                try {
                    this._certificates[i][0] = CertificateInfo.getCertificateInfo(this._certs[i][0]);
                }
                catch (CertificateException certificateException) {
                    Debug.ignoredException(certificateException);
                }
                continue;
            }
            catch (KeyStoreException keyStoreException) {
                Debug.ignoredException(keyStoreException);
            }
        }
        if (bl) {
            this.setVisible(true);
        }
    }

    public void setVisible(boolean bl, int n) {
        this._selectedIndex = n;
        if (this._controller.getSubcontroller(0) != null) {
            this._controller.getSubcontroller(0).stop();
            this._controller.getSubcontroller(0).start();
        }
        if (this._controller.getSubcontroller(1) != null) {
            this._controller.getSubcontroller(1).stop();
            this._controller.getSubcontroller(1).start();
        }
    }

    public CertificatePanel(boolean bl, boolean bl2, boolean bl3) {
        this._allowAliasSelection = bl;
        this._standAlone = bl2;
        this._showImportExport = bl3;
    }

    private CertificateInfo getCertificate() {
        return this.getCertificate(0);
    }

    private CertificateInfo[] getCertificates() {
        return this.getCertificates(0);
    }

    private CertificateInfo getCertificate(int n) {
        return this._certificates != null && this._certificates[n] != null ? this._certificates[n][0] : null;
    }

    private CertificateInfo[] getCertificates(int n) {
        if (n >= 0 && this._certificates != null) {
            return this._certificates[n];
        }
        return null;
    }

    static int access$200(CertificatePanel certificatePanel) {
        return certificatePanel._selectedIndex;
    }

    static int access$800(CertificatePanel certificatePanel) {
        return certificatePanel.getSelectedIndex();
    }

    static boolean access$1100(CertificatePanel certificatePanel) {
        return certificatePanel._showImportExport;
    }

    static boolean access$400(CertificatePanel certificatePanel) {
        return certificatePanel._allowAliasSelection;
    }

    static void access$1300(CertificatePanel certificatePanel, boolean bl) {
        certificatePanel.updateData(bl);
    }

    public Component getComponent() {
        return this._spane;
    }

    private Frame getFrame() {
        return this._frame;
    }

    private void setFrame(Frame frame) {
        this._frame = frame;
    }

    private boolean askUser(Object object) {
        int n = GeneralUtilities.showOptionDialog(null, object, Resources.getString("certificatePanel.import.querytitle"), 0, 3);
        return n == 0;
    }

    private char[] getKeyPasswd(String string) {
        return this.askUserForCertPassword(string).toCharArray();
    }

    private boolean askUserAboutCertificate(Certificate certificate) throws Exception {
        JLabel jLabel = new JLabel(Resources.getString("certificatePanel.import.certtrustquery"));
        Insets insets = new Insets(5, 5, 5, 5);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "North");
        CertificatePanel certificatePanel = new CertificatePanel(false, true, false);
        certificatePanel._certificates = new CertificateInfo[1][1];
        certificatePanel._certificates[0][0] = CertificateInfo.getCertificateInfo(certificate);
        certificatePanel._selectedIndex = 0;
        certificatePanel.start();
        certificatePanel.setVisible(true);
        ((JComponent)certificatePanel.getComponent()).setPreferredSize(new Dimension(400, 400));
        jPanel.add(certificatePanel.getComponent(), "Center");
        return this.askUser(jPanel);
    }

    private boolean isSelfSigned(X509Certificate x509Certificate) {
        return ((Object)x509Certificate.getSubjectDN()).equals(x509Certificate.getIssuerDN());
    }

    private Vector getAliases() {
        return this._aliases;
    }

    public void stateChanged(ChangeEvent changeEvent) {
    }

    static CertificateInfo access$300(CertificatePanel certificatePanel, int n) {
        return certificatePanel.getCertificate(n);
    }

    static CertificateInfo[] access$900(CertificatePanel certificatePanel, int n) {
        return certificatePanel.getCertificates(n);
    }

    public static void showCertificateDialog(Frame frame, CertificateInfo[] certificateInfoArray, int n) {
        JDialog jDialog = GeneralUtilities.createDialog(frame, Resources.getString("certificateDialog.title"), true);
        CertificatePanel certificatePanel = new CertificatePanel(false, true, false);
        certificatePanel.setFrame(frame);
        int n2 = -1;
        n2 = n < 0 ? certificateInfoArray.length : Math.min(n + 1, certificateInfoArray.length);
        certificatePanel._certificates = new CertificateInfo[1][n2];
        System.arraycopy(certificateInfoArray, 0, certificatePanel._certificates[0], 0, n2);
        certificatePanel._selectedIndex = 0;
        certificatePanel.start();
        certificatePanel.setVisible(true);
        jDialog.getContentPane().add(certificatePanel.getComponent(), "Center");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        JButton jButton = new JButton(Resources.getString("certificateDialog.okButton"));
        jButton.addActionListener(new ActionListener(jDialog){
            private final JDialog val$frame;

            public void actionPerformed(ActionEvent actionEvent) {
                this.val$frame.setVisible(false);
            }
            {
                this.val$frame = jDialog;
            }
        });
        box.add(jButton);
        box.add(Box.createHorizontalStrut(5));
        Box box2 = Box.createVerticalBox();
        box2.add(Box.createVerticalStrut(5));
        box2.add(box);
        box2.add(Box.createVerticalStrut(5));
        jDialog.getContentPane().add((Component)box2, "South");
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jButton.requestDefaultFocus();
        jButton.requestFocus();
        jDialog.getRootPane().setDefaultButton(jButton);
        jDialog.show();
    }

    static Frame access$1000(CertificatePanel certificatePanel) {
        return certificatePanel.getFrame();
    }

    static ActionListener access$500(CertificatePanel certificatePanel) {
        return certificatePanel._aliasActionListener;
    }

    private void doExportCert(Certificate certificate, PrintStream printStream) {
        X509Certificate x509Certificate = (X509Certificate)certificate;
        this.dumpX509Cert(x509Certificate, printStream);
    }

    private void dumpX509Cert(X509Certificate x509Certificate, PrintStream printStream) {
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        printStream.println(SunSecurityUtil.getBeginCert());
        try {
            bASE64Encoder.encodeBuffer(x509Certificate.getEncoded(), (OutputStream)printStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            certificateEncodingException.printStackTrace();
        }
        printStream.println(SunSecurityUtil.getEndCert());
    }

    private String askUserForCertPassword(String string) {
        JPasswordField jPasswordField = new JPasswordField();
        JLabel jLabel = new JLabel(Resources.getString("certificatePanel.import.certpasswordquery", string));
        Object[] objectArray = new Object[]{jLabel, jPasswordField};
        int n = GeneralUtilities.showOptionDialog(this, objectArray, Resources.getString("certificatePanel.import.aliasquerytitle"), 0, 3);
        String string2 = null;
        if (n == 0) {
            string2 = ((JTextComponent)jPasswordField).getText();
        }
        return string2;
    }

    private boolean isTrusted(KeyStore keyStore, Certificate certificate) throws Exception {
        return keyStore.getCertificateAlias(certificate) != null;
    }

    private void keystorecerts2Hashtable(KeyStore keyStore, Hashtable hashtable) throws Exception {
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate = keyStore.getCertificate(string);
            if (certificate == null) continue;
            Principal principal = ((X509Certificate)certificate).getSubjectDN();
            Vector<Certificate> vector = (Vector<Certificate>)hashtable.get(principal);
            if (vector == null) {
                vector = new Vector<Certificate>();
                vector.addElement(certificate);
            } else if (!vector.contains(certificate)) {
                vector.addElement(certificate);
            }
            hashtable.put(principal, vector);
        }
    }

    static Vector access$700(CertificatePanel certificatePanel) {
        return certificatePanel.getAliases();
    }

    static AncestorListener access$600(CertificatePanel certificatePanel) {
        return certificatePanel._aliasAncestorListener;
    }

    private void doImportCert(String string, String string2, InputStream inputStream) throws Exception {
        if (string == null) {
            throw new Exception(Resources.getString("certificatePanel.import.aliasnull"));
        }
        KeyStore keyStore = null;
        try {
            keyStore = KeyStoreManager.getKeyStore();
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace();
        }
        if (keyStore == null) {
            throw new Exception(Resources.getString("certificatePanel.import.keystorereaderror"));
        }
        if (keyStore.isKeyEntry(string)) {
            this.installReply(keyStore, string, string2.toCharArray(), inputStream);
            KeyStoreManager.saveKeyStore(keyStore, string2);
            return;
        }
        if (keyStore.containsAlias(string)) {
            GeneralUtilities.showMessageDialog(this, Resources.getString("certificatePanel.import.aliasexists", string), Resources.getString("certificatePanel.import.querytitle"), 2);
            return;
        }
        X509Certificate x509Certificate = null;
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        try {
            x509Certificate = (X509Certificate)certificateFactory.generateCertificate(inputStream);
        }
        catch (ClassCastException classCastException) {
            throw new Exception("Input not an X.509 Certificate");
        }
        boolean bl = false;
        if (this.isSelfSigned(x509Certificate)) {
            x509Certificate.verify(x509Certificate.getPublicKey());
            bl = true;
        }
        String string3 = keyStore.getCertificateAlias(x509Certificate);
        boolean bl2 = false;
        if (string3 != null) {
            bl2 = this.askUser(Resources.getString("certificatePanel.import.certexistsquery", string3));
        } else if (bl && string3 == null) {
            bl2 = this.askUserAboutCertificate(x509Certificate);
        }
        if (!bl2) {
            return;
        }
        keyStore.setCertificateEntry(string, x509Certificate);
        try {
            Certificate[] certificateArray = this.establishCertChain(null, x509Certificate);
            if (certificateArray != null) {
                keyStore.setCertificateEntry(string, x509Certificate);
            }
        }
        catch (Exception exception) {
            if (this.askUserAboutCertificate(x509Certificate)) {
                keyStore.setCertificateEntry(string, x509Certificate);
            }
            return;
        }
        KeyStoreManager.saveKeyStore(keyStore, string2);
    }

    private boolean installReply(KeyStore keyStore, String string, char[] cArray, InputStream inputStream) throws Exception {
        Certificate certificate;
        String string2 = null;
        if (string2 == null) {
            string2 = string;
        }
        char[] cArray2 = cArray;
        Object[] objectArray = this.recoverPrivateKey(keyStore, string2, cArray, cArray2);
        PrivateKey privateKey = (PrivateKey)objectArray[0];
        if (cArray2 == null) {
            cArray2 = (char[])objectArray[1];
        }
        if ((certificate = keyStore.getCertificate(string2)) == null) {
            throw new Exception(Resources.getString("certificatePanel.import.nopublickey", string2));
        }
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> collection = certificateFactory.generateCertificates(inputStream);
        if (collection.isEmpty()) {
            throw new Exception(Resources.getString("certificatePanel.import.nocert"));
        }
        Certificate[] certificateArray = (Certificate[])collection.toArray();
        Certificate[] certificateArray2 = certificateArray.length == 1 ? this.establishCertChain(certificate, certificateArray[0]) : this.validateReply(keyStore, string2, certificate, certificateArray);
        if (certificateArray2 != null) {
            keyStore.setKeyEntry(string2, privateKey, cArray2 != null ? cArray2 : cArray, certificateArray2);
            return true;
        }
        return false;
    }

    static void access$1400(CertificatePanel certificatePanel, Certificate certificate, PrintStream printStream) {
        certificatePanel.doExportCert(certificate, printStream);
    }

    private Object[] recoverPrivateKey(KeyStore keyStore, String string, char[] cArray, char[] cArray2) throws Exception {
        Key key = null;
        if (!keyStore.containsAlias(string)) {
            throw new Exception(Resources.getString("certificatePanel.import.noalias", string));
        }
        if (!keyStore.isKeyEntry(string)) {
            throw new Exception(Resources.getString("certificatePanel.import.noprivatekey", string));
        }
        if (cArray2 == null) {
            try {
                key = keyStore.getKey(string, cArray);
                cArray2 = cArray;
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                cArray2 = this.getKeyPasswd(string);
                key = keyStore.getKey(string, cArray2);
            }
        } else {
            key = keyStore.getKey(string, cArray2);
        }
        if (!(key instanceof PrivateKey)) {
            throw new Exception(Resources.getString("certificatePanel.import.notaprivkey"));
        }
        return new Object[]{(PrivateKey)key, cArray2};
    }

    private Certificate[] establishCertChain(Certificate certificate, Certificate certificate2) throws Exception {
        Vector vector;
        Object object;
        Serializable serializable;
        if (certificate != null) {
            serializable = certificate.getPublicKey();
            if (!serializable.equals(object = certificate2.getPublicKey())) {
                String string = Resources.getString("certificatePanel.import.keymatcherror");
                throw new Exception(string);
            }
            if (certificate2.equals(certificate)) {
                String string = Resources.getString("certificatePanel.import.replyequalscert");
                throw new Exception(string);
            }
        }
        serializable = null;
        object = null;
        try {
            object = KeyStoreManager.getKeyStore();
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace();
        }
        if (object == null) {
            return null;
        }
        if (((KeyStore)object).size() > 0) {
            serializable = new Hashtable(11);
            this.keystorecerts2Hashtable((KeyStore)object, (Hashtable)serializable);
        }
        if (this.buildChain((X509Certificate)certificate2, vector = new Vector(2), (Hashtable)serializable)) {
            Certificate[] certificateArray = new Certificate[vector.size()];
            int n = 0;
            for (int i = vector.size() - 1; i >= 0; --i) {
                certificateArray[n] = (Certificate)vector.elementAt(i);
                ++n;
            }
            return certificateArray;
        }
        throw new Exception("Failed to establish chain from reply");
    }

    private boolean buildChain(X509Certificate x509Certificate, Vector vector, Hashtable hashtable) {
        Principal principal;
        Principal principal2 = x509Certificate.getSubjectDN();
        if (((Object)principal2).equals(principal = x509Certificate.getIssuerDN())) {
            vector.addElement(x509Certificate);
            return true;
        }
        Vector vector2 = (Vector)hashtable.get(principal);
        if (vector2 == null) {
            return false;
        }
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate2 = (X509Certificate)enumeration.nextElement();
            PublicKey publicKey = x509Certificate2.getPublicKey();
            try {
                x509Certificate.verify(publicKey);
            }
            catch (Exception exception) {
                continue;
            }
            if (!this.buildChain(x509Certificate2, vector, hashtable)) continue;
            vector.addElement(x509Certificate);
            return true;
        }
        return false;
    }

    static void access$1200(CertificatePanel certificatePanel, String string, String string2, InputStream inputStream) throws Exception {
        certificatePanel.doImportCert(string, string2, inputStream);
    }

    private Certificate[] validateReply(KeyStore keyStore, String string, Certificate certificate, Certificate[] certificateArray) throws Exception {
        int n;
        PublicKey publicKey = certificate.getPublicKey();
        for (n = 0; n < certificateArray.length && !publicKey.equals(certificateArray[n].getPublicKey()); ++n) {
        }
        if (n == certificateArray.length) {
            throw new Exception(Resources.getString("certificatePanel.import.nocertreplypubkey", string));
        }
        Certificate certificate2 = certificateArray[0];
        certificateArray[0] = certificateArray[n];
        certificateArray[n] = certificate2;
        Principal principal = ((X509Certificate)certificateArray[0]).getIssuerDN();
        for (n = 1; n < certificateArray.length - 1; ++n) {
            int n2;
            for (n2 = n; n2 < certificateArray.length; ++n2) {
                Principal principal2 = ((X509Certificate)certificateArray[n2]).getSubjectDN();
                if (!((Object)principal2).equals(principal)) continue;
                certificate2 = certificateArray[n];
                certificateArray[n] = certificateArray[n2];
                certificateArray[n2] = certificate2;
                principal = ((X509Certificate)certificateArray[n]).getIssuerDN();
                break;
            }
            if (n2 != certificateArray.length) continue;
            throw new Exception(Resources.getString("certificatePanel.import.incompletechain"));
        }
        for (n = 0; n < certificateArray.length - 1; ++n) {
            PublicKey publicKey2 = certificateArray[n + 1].getPublicKey();
            try {
                certificateArray[n].verify(publicKey2);
                continue;
            }
            catch (Exception exception) {
                throw new Exception(Resources.getString("certificatePanel.import.cantverify", exception.getMessage()));
            }
        }
        Certificate certificate3 = certificateArray[certificateArray.length - 1];
        if (!this.isTrusted(keyStore, certificate3)) {
            boolean bl = false;
            Object var11_16 = null;
            if (!bl) {
                if (!this.askUserAboutCertificate(certificate3)) {
                    return null;
                }
            } else if (!this.isSelfSigned((X509Certificate)certificate3)) {
                Certificate[] certificateArray2 = new Certificate[certificateArray.length + 1];
                System.arraycopy(certificateArray, 0, certificateArray2, 0, certificateArray.length);
                certificateArray2[certificateArray2.length - 1] = var11_16;
                certificateArray = certificateArray2;
            }
        }
        return certificateArray;
    }

    private class CertPathPanel
    extends JPanel
    implements ActionListener,
    Subcontroller,
    TreeSelectionListener {
        private boolean _createdComponents;
        private JTree _tree;
        private JButton _viewButton;
        private JButton _importButton;
        private JButton _exportButton;
        private final CertificatePanel this$0;

        public void apply() {
        }

        private void createPropertyControls() {
            JLabel jLabel;
            Dimension dimension = new Dimension(0, 0);
            this.setMinimumSize(dimension);
            this._tree = new JTree();
            this._tree.addTreeSelectionListener(this);
            this._tree.getSelectionModel().setSelectionMode(1);
            String string = System.getProperty("java.version");
            if (string.startsWith("1.2") || string.startsWith("1.3")) {
                jLabel = new JLabel("<html><u><font size=4 color=black face=dialog>" + Resources.getString("certificatePanel.certPath.title") + "</font></u></html>");
            } else {
                jLabel = new JLabel("<html><u>" + Resources.getString("certificatePanel.certPath.title") + "</u></html>");
                jLabel.setFont(jLabel.getFont().deriveFont(1, jLabel.getFont().getSize() + 4));
            }
            jLabel.setForeground(Color.black);
            jLabel.setBorder(new EmptyBorder(2, 2, 2, 2));
            FlowLayout flowLayout = new FlowLayout(this, 0){
                private final CertPathPanel this$1;
                {
                    this.this$1 = certPathPanel;
                }

                public Dimension minimumLayoutSize(Container container) {
                    Container container2 = container.getParent();
                    Component[] componentArray = container.getComponents();
                    int n = componentArray.length;
                    Insets insets = container.getInsets();
                    int n2 = insets.top + insets.bottom + 8;
                    int n3 = insets.left + insets.right;
                    if (container2 != null && componentArray != null && componentArray.length > 0) {
                        int n4;
                        int n5 = 0;
                        int n6 = 0;
                        for (n4 = 0; n4 < n; ++n4) {
                            Dimension dimension = componentArray[n4].getPreferredSize();
                            n6 = Math.max(n6, dimension.height);
                            n5 += dimension.width;
                        }
                        n4 = n3 + n5 + n * this.getHgap();
                        if (container2.getWidth() < n4) {
                            int n7 = n4 / 3 + 1;
                            int n8 = container2.getWidth() / n7;
                            int n9 = 3 - n8;
                            if (n8 > 0) {
                                ++n9;
                            }
                            return new Dimension(n4, n2 + n9 * (n6 + this.getVgap()));
                        }
                        return new Dimension(n4, n2 + n6);
                    }
                    return new Dimension(0, 0);
                }

                public Dimension preferredLayoutSize(Container container) {
                    return this.minimumLayoutSize(container);
                }
            };
            JPanel jPanel = new JPanel(flowLayout);
            if (CertificatePanel.access$1100(this.this$0)) {
                this._importButton = new JButton(Resources.getString("certificatePanel.certPath.import"));
                this._exportButton = new JButton(Resources.getString("certificatePanel.certPath.export"));
                this._importButton.setMnemonic(Resources.getVKCode("certificatePanel.certPath.importMnemonic"));
                this._exportButton.setMnemonic(Resources.getVKCode("certificatePanel.certPath.exportMnemonic"));
                this._importButton.addActionListener(this);
                this._exportButton.addActionListener(this);
                jPanel.add(this._importButton);
                jPanel.add(this._exportButton);
            }
            this._viewButton = new JButton(Resources.getString("certificatePanel.certPath.details"));
            this._viewButton.setMnemonic(Resources.getVKCode("certificatePanel.certPath.detailsMnemonic"));
            this._viewButton.addActionListener(this);
            jPanel.add(this._viewButton);
            this.setLayout(new BorderLayout(2, 2));
            this.add((Component)jLabel, "North");
            JScrollPane jScrollPane = new JScrollPane(this._tree, 20, 30);
            Border border = jScrollPane.getBorder();
            EmptyBorder emptyBorder = new EmptyBorder(2, 2, 2, 2);
            jScrollPane.setBorder(new CompoundBorder(emptyBorder, border));
            this.add((Component)jScrollPane, "Center");
            this.add((Component)jPanel, "South");
        }

        public void revert() {
        }

        public void start() {
            if (!this._createdComponents) {
                this._createdComponents = true;
                this.createPropertyControls();
            }
            this.updateWidgets();
        }

        public void stop() {
        }

        private void updateViewButton() {
            int n = this._tree.getMinSelectionRow();
            CertificateInfo[] certificateInfoArray = CertificatePanel.access$900(this.this$0, CertificatePanel.access$800(this.this$0));
            this._viewButton.setEnabled(certificateInfoArray != null && n >= 0 && n < certificateInfoArray.length - 1);
            if (this._exportButton != null) {
                this._exportButton.setEnabled(certificateInfoArray != null && n >= 0 && n < certificateInfoArray.length);
            }
        }

        private void updateWidgets() {
            CertificateInfo[] certificateInfoArray = CertificatePanel.access$900(this.this$0, CertificatePanel.access$800(this.this$0));
            if (certificateInfoArray != null && certificateInfoArray.length > 0) {
                int n;
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(certificateInfoArray[0].getSubjectName());
                for (n = 1; n < certificateInfoArray.length; ++n) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(certificateInfoArray[n].getSubjectName());
                    defaultMutableTreeNode2.add(defaultMutableTreeNode);
                    defaultMutableTreeNode = defaultMutableTreeNode2;
                }
                this._tree.setModel(new DefaultTreeModel(defaultMutableTreeNode));
                this._tree.setRootVisible(true);
                for (n = 0; n < this._tree.getRowCount(); ++n) {
                    this._tree.expandRow(n);
                }
            } else {
                this._tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("")));
                this._tree.setRootVisible(false);
            }
            this.updateViewButton();
        }

        private CertPathPanel(CertificatePanel certificatePanel) {
            this.this$0 = certificatePanel;
        }

        public Component getComponent() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void actionPerformed(ActionEvent actionEvent) {
            block32: {
                if (actionEvent.getSource() == this._viewButton) {
                    int n = this._tree.getMinSelectionRow();
                    int n2 = CertificatePanel.access$800(this.this$0);
                    CertificateInfo[] certificateInfoArray = CertificatePanel.access$900(this.this$0, CertificatePanel.access$800(this.this$0));
                    if (n >= 0 && n < certificateInfoArray.length - 1) {
                        CertificateInfo[] certificateInfoArray2 = new CertificateInfo[n + 1];
                        System.arraycopy(certificateInfoArray, certificateInfoArray.length - n - 1, certificateInfoArray2, 0, n + 1);
                        CertificatePanel.showCertificateDialog(CertificatePanel.access$1000(this.this$0), certificateInfoArray2, -1);
                    }
                } else if (CertificatePanel.access$1100(this.this$0) && actionEvent.getSource() == this._importButton) {
                    KeyStore keyStore = null;
                    try {
                        keyStore = KeyStoreManager.getKeyStore();
                    }
                    catch (KeyStoreException keyStoreException) {
                        keyStoreException.printStackTrace();
                        return;
                    }
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setFileSelectionMode(0);
                    jFileChooser.setDialogType(0);
                    jFileChooser.setMultiSelectionEnabled(false);
                    int n = jFileChooser.showOpenDialog(this);
                    this.requestFocus();
                    if (n == 0) {
                        BufferedInputStream bufferedInputStream;
                        block30: {
                            File file = jFileChooser.getSelectedFile();
                            if (file == null) {
                                return;
                            }
                            bufferedInputStream = null;
                            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                            String[] stringArray = this.askUserForCertAliasAndPassword();
                            if (stringArray == null) break block30;
                            CertificatePanel.access$1200(this.this$0, stringArray[0], stringArray[1], bufferedInputStream);
                        }
                        Object var9_20 = null;
                        try {
                            if (bufferedInputStream != null) {
                                bufferedInputStream.close();
                            }
                        }
                        catch (IOException iOException) {
                            Debug.ignoredException(iOException);
                        }
                        CertificatePanel.access$1300(this.this$0, true);
                        this.updateWidgets();
                        {
                            break block32;
                            catch (Exception exception) {
                                exception.printStackTrace();
                                Object var9_21 = null;
                                try {
                                    if (bufferedInputStream != null) {
                                        bufferedInputStream.close();
                                    }
                                }
                                catch (IOException iOException) {
                                    Debug.ignoredException(iOException);
                                }
                                CertificatePanel.access$1300(this.this$0, true);
                                this.updateWidgets();
                                break block32;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var9_22 = null;
                            try {
                                if (bufferedInputStream != null) {
                                    bufferedInputStream.close();
                                }
                            }
                            catch (IOException iOException) {
                                Debug.ignoredException(iOException);
                            }
                            CertificatePanel.access$1300(this.this$0, true);
                            this.updateWidgets();
                            throw throwable;
                        }
                    }
                } else if (CertificatePanel.access$1100(this.this$0) && actionEvent.getSource() == this._exportButton) {
                    int n = this._tree.getMinSelectionRow();
                    CertificateInfo[] certificateInfoArray = CertificatePanel.access$900(this.this$0, CertificatePanel.access$800(this.this$0));
                    if (n >= 0 && n < certificateInfoArray.length) {
                        JFileChooser jFileChooser = new JFileChooser();
                        jFileChooser.setFileSelectionMode(0);
                        jFileChooser.setDialogType(1);
                        jFileChooser.setMultiSelectionEnabled(false);
                        int n3 = jFileChooser.showSaveDialog(this);
                        this.requestFocus();
                        if (n3 == 0) {
                            File file = jFileChooser.getSelectedFile();
                            if (file == null) {
                                return;
                            }
                            PrintStream printStream = null;
                            try {
                                printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
                                CertificatePanel.access$1400(this.this$0, certificateInfoArray[n].getCertificate(), printStream);
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                            finally {
                                if (printStream != null) {
                                    printStream.close();
                                }
                            }
                        }
                    }
                }
            }
        }

        private String[] askUserForCertAliasAndPassword() {
            JTextField jTextField = new JTextField();
            JPasswordField jPasswordField = new JPasswordField();
            JLabel jLabel = new JLabel(Resources.getString("certificatePanel.import.aliasquery"));
            JLabel jLabel2 = new JLabel(Resources.getString("certificatePanel.import.passwordquery"));
            Object[] objectArray = new Object[]{jLabel, jTextField, jLabel2, jPasswordField};
            int n = GeneralUtilities.showOptionDialog(this, objectArray, Resources.getString("certificatePanel.import.aliasquerytitle"), 0, 3);
            String string = null;
            String string2 = null;
            if (n != 0) {
                return null;
            }
            string = jTextField.getText();
            string2 = ((JTextComponent)jPasswordField).getText();
            if (string != null && string.equals("")) {
                string = null;
            }
            String[] stringArray = new String[]{string == null ? "mykey" : string, string2};
            return stringArray;
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            this.updateViewButton();
        }

        CertPathPanel(CertificatePanel certificatePanel, 1 var2_2) {
            this(certificatePanel);
        }
    }

    private class GeneralPanel
    extends JPanel
    implements Subcontroller {
        private boolean _createdComponents;
        private JLabel _issuedToLabel;
        private JLabel _issuerLabel;
        private JLabel _dateLabel;
        private DefaultTableModel _tableModel;
        private final CertificatePanel this$0;

        public void apply() {
        }

        private void createPropertyControls() {
            Dimension dimension = new Dimension(0, 0);
            this.setMinimumSize(dimension);
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel(Resources.getString("certificatePanel.general.label"));
            jLabel.setFont(jLabel.getFont().deriveFont(1, jLabel.getFont().getSize() + 4));
            jLabel.setForeground(Color.black);
            jLabel.setBorder(new LineBorder(Color.black, 1, 8));
            Insets insets = new Insets(2, 2, 2, 2);
            GridBagHelper.addGridBagComponent(this, jLabel, 0, 1, 2, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
            insets.top = 0;
            if (CertificatePanel.access$400(this.this$0)) {
                this.this$0._aliasList = new JComboBox();
                this.this$0._aliasList.addActionListener(CertificatePanel.access$500(this.this$0));
                this.this$0._aliasList.addAncestorListener(CertificatePanel.access$600(this.this$0));
                GridBagHelper.addGridBagComponent(this, this.this$0._aliasList, 0, 0, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
            }
            this._issuedToLabel = new JLabel("");
            GridBagHelper.addGridBagComponent(this, this._issuedToLabel, 0, 2, 1, 1, 12.0, 0.0, 17, 2, insets, 0, 0);
            this._issuerLabel = new JLabel("");
            GridBagHelper.addGridBagComponent(this, this._issuerLabel, 0, 3, 1, 1, 12.0, 0.0, 17, 2, insets, 0, 0);
            this._dateLabel = new JLabel("");
            GridBagHelper.addGridBagComponent(this, this._dateLabel, 0, 4, 2, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
            jLabel = new JLabel(Resources.getString("certificatePanel.general.details"));
            GridBagHelper.addGridBagComponent(this, jLabel, 0, 5, 2, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
            insets.top = 0;
            Object[] objectArray = new String[]{Resources.getString("certificatePanel.general.table.column0"), Resources.getString("certificatePanel.general.table.column1")};
            this._tableModel = new DefaultTableModel(this, objectArray, 0){
                private final GeneralPanel this$1;

                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
                {
                    this.this$1 = generalPanel;
                }
            };
            JTable jTable = new JTable(this._tableModel);
            jTable.setAutoResizeMode(0);
            JScrollPane jScrollPane = new JScrollPane(jTable);
            jTable.setPreferredScrollableViewportSize(new Dimension(600, 300));
            for (int i = 0; i < jTable.getColumnCount(); ++i) {
                if (i == 0) {
                    jTable.getColumnModel().getColumn(i).setPreferredWidth(100);
                    continue;
                }
                jTable.getColumnModel().getColumn(i).setPreferredWidth(1100);
            }
            jScrollPane.setBackground(Color.white);
            jScrollPane.getViewport().setBackground(Color.white);
            GridBagHelper.addGridBagComponent(this, jScrollPane, 0, 6, 2, 1, 1.0, 1.0, 17, 1, insets, 0, 0);
        }

        public void revert() {
        }

        public void start() {
            CertificateInfo certificateInfo;
            if (!this._createdComponents) {
                this._createdComponents = true;
                this.createPropertyControls();
            }
            if ((certificateInfo = CertificatePanel.access$300(this.this$0, CertificatePanel.access$200(this.this$0))) != null) {
                this.updateTable(certificateInfo);
                this.updateWidgets(certificateInfo);
            }
        }

        public void stop() {
        }

        private void updateTable(CertificateInfo certificateInfo) {
            this._tableModel.setNumRows(0);
            Iterator iterator = certificateInfo.getKeys();
            Object[] objectArray = new Object[2];
            while (iterator.hasNext()) {
                Object e = iterator.next();
                objectArray[0] = e.toString();
                objectArray[1] = certificateInfo.getValue(e);
                this._tableModel.addRow(objectArray);
            }
        }

        private void updateWidgets(CertificateInfo certificateInfo) {
            String string;
            Cloneable cloneable;
            if (this.this$0._aliasList != null) {
                this.this$0._aliasList.removeActionListener(CertificatePanel.access$500(this.this$0));
                this.this$0._aliasList.removeAncestorListener(CertificatePanel.access$600(this.this$0));
                this.this$0._aliasList.removeAllItems();
                cloneable = CertificatePanel.access$700(this.this$0);
                if (cloneable != null) {
                    for (int i = 0; i < ((Vector)cloneable).size(); ++i) {
                        this.this$0._aliasList.addItem(((Vector)cloneable).elementAt(i));
                    }
                }
                this.this$0._aliasList.addActionListener(CertificatePanel.access$500(this.this$0));
                this.this$0._aliasList.addAncestorListener(CertificatePanel.access$600(this.this$0));
                this.this$0._aliasList.setSelectedIndex(CertificatePanel.access$200(this.this$0));
            }
            this._issuedToLabel.setText(Resources.getString("certificatePanel.general.issuedTo") + " " + certificateInfo.getSubjectName());
            this._issuerLabel.setText(Resources.getString("certificatePanel.general.issuer") + " " + certificateInfo.getIssuerName());
            cloneable = DateFormat.getDateInstance(3);
            Date date = certificateInfo.getStartDate();
            String string2 = date == null ? null : ((DateFormat)cloneable).format(date);
            date = certificateInfo.getExpirationDate();
            String string3 = string = date == null ? null : ((DateFormat)cloneable).format(date);
            String string4 = string2 != null ? (string != null ? Resources.getString("certificatePanel.general.dateString0", string2, string) : Resources.getString("certificatePanel.general.dateString1", string2)) : (string != null ? Resources.getString("certificatePanel.general.dateString2", string) : Resources.getString("certificatePanel.general.dateString3", string2));
            this._dateLabel.setText(string4);
        }

        private GeneralPanel(CertificatePanel certificatePanel) {
            this.this$0 = certificatePanel;
        }

        public Component getComponent() {
            return this;
        }

        GeneralPanel(CertificatePanel certificatePanel, 1 var2_2) {
            this(certificatePanel);
        }
    }

    class aliasComboActionListener
    implements ActionListener {
        private final CertificatePanel this$0;

        aliasComboActionListener(CertificatePanel certificatePanel) {
            this.this$0 = certificatePanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            int n = jComboBox.getSelectedIndex();
            if (n != -1 && jComboBox.getItemAt(n) != null) {
                this.this$0.setVisible(true, n);
            }
        }
    }

    class aliasComboAncestorListener
    implements AncestorListener {
        private final CertificatePanel this$0;

        aliasComboAncestorListener(CertificatePanel certificatePanel) {
            this.this$0 = certificatePanel;
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
            if (ancestorEvent.getSource() == this.this$0._aliasList && CertificatePanel.access$200(this.this$0) == -1) {
                this.this$0._aliasList.setSelectedIndex(CertificatePanel.access$200(this.this$0));
            }
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
        }
    }
}

