/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cache;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import sun.plugin.cache.JarCacheEntry;
import sun.plugin.cache.JarCacheTableModel;

public class JarCacheTableSorter
extends JarCacheTableModel {
    int selectedColumn = -1;
    boolean ascending = true;

    public void refresh() {
        super.refresh();
        this.sort();
    }

    public void sort() {
        if (this.selectedColumn != -1) {
            Arrays.sort(this.tableRows, new Comparator(this){
                private final JarCacheTableSorter this$0;
                {
                    this.this$0 = jarCacheTableSorter;
                }

                public int compare(Object object, Object object2) {
                    int n = this.this$0.compareRowsByColumn((JarCacheEntry)object, (JarCacheEntry)object2);
                    return n != 0 && this.this$0.ascending ? n : -n;
                }
            });
        }
        super.fireTableDataChanged();
    }

    public void sortByColumn(int n) {
        this.ascending = n != this.selectedColumn ? true : !this.ascending;
        this.selectedColumn = n;
        this.sort();
    }

    public void removeRows(int[] nArray) {
        super.removeRows(nArray);
        this.sort();
    }

    public JarCacheTableSorter(String[] stringArray) {
        super(stringArray);
    }

    public void addMouseListenerToHeaderInTable(JTable jTable) {
        JarCacheTableSorter jarCacheTableSorter = this;
        JTable jTable2 = jTable;
        jTable2.setColumnSelectionAllowed(false);
        MouseAdapter mouseAdapter = new MouseAdapter(this, jTable2, jarCacheTableSorter){
            private final JTable val$tableView;
            private final JarCacheTableSorter val$sorter;
            private final JarCacheTableSorter this$0;

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = this.val$tableView.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = this.val$tableView.convertColumnIndexToModel(n);
                if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                    this.val$sorter.sortByColumn(n2);
                }
            }
            {
                this.this$0 = jarCacheTableSorter;
                this.val$tableView = jTable;
                this.val$sorter = jarCacheTableSorter2;
            }
        };
        JTableHeader jTableHeader = jTable2.getTableHeader();
        jTableHeader.addMouseListener(mouseAdapter);
    }

    public int compareRowsByColumn(JarCacheEntry jarCacheEntry, JarCacheEntry jarCacheEntry2) {
        String string;
        Object object = jarCacheEntry.getValue(super.getColumnName(this.selectedColumn));
        Object object2 = jarCacheEntry2.getValue(super.getColumnName(this.selectedColumn));
        if (object instanceof Number) {
            Number number;
            double d;
            Number number2 = (Number)object;
            double d2 = number2.doubleValue();
            if (d2 < (d = (number = (Number)object2).doubleValue())) {
                return -1;
            }
            if (d2 > d) {
                return 1;
            }
            return 0;
        }
        if (object instanceof Date) {
            Date date;
            long l;
            Date date2 = (Date)object;
            long l2 = date2.getTime();
            if (l2 < (l = (date = (Date)object2).getTime())) {
                return -1;
            }
            if (l2 > l) {
                return 1;
            }
            return 0;
        }
        if (object instanceof String) {
            String string2 = (String)object;
            String string3 = (String)object2;
            int n = string2.compareToIgnoreCase(string3);
            if (n < 0) {
                return -1;
            }
            if (n > 0) {
                return 1;
            }
            return 0;
        }
        if (object instanceof Boolean) {
            Boolean bl;
            boolean bl2;
            Boolean bl3 = (Boolean)object;
            boolean bl4 = bl3;
            if (bl4 == (bl2 = (bl = (Boolean)object2).booleanValue())) {
                return 0;
            }
            if (bl4) {
                return 1;
            }
            return -1;
        }
        String string4 = object.toString();
        int n = string4.compareToIgnoreCase(string = object2.toString());
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        return 0;
    }
}

