/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.HandshakeInStream;
import com.sun.net.ssl.internal.ssl.HandshakeOutStream;
import com.sun.net.ssl.internal.ssl.RSASignature;
import com.sun.net.ssl.internal.ssl.SunJSSE_a6;
import com.sun.net.ssl.internal.ssl.SunJSSE_bd;
import com.sun.net.ssl.internal.ssl.SunJSSE_g;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Vector;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLProtocolException;

abstract class HandshakeMessage
implements SunJSSE_g {
    static final byte a = 0;
    static final byte b = 1;
    static final byte c = 2;
    static final byte d = 11;
    static final byte e = 12;
    static final byte f = 13;
    static final byte g = 14;
    static final byte h = 15;
    static final byte i = 16;
    static final byte j = 20;
    static final Debug k = Debug.getInstance("ssl");

    abstract int messageLength();

    abstract int messageType();

    HandshakeMessage() {
    }

    abstract void send(HandshakeOutStream var1) throws IOException;

    public final void write(HandshakeOutStream handshakeOutStream) throws IOException {
        int n = this.messageLength();
        if (n > 0x1000000) {
            throw new SSLException("Handshake message too big, type = " + this.messageType() + ", len = " + n);
        }
        handshakeOutStream.write(this.messageType());
        handshakeOutStream.c(this.messageLength());
        this.send(handshakeOutStream);
    }

    abstract void a(PrintStream var1) throws IOException;

    static byte[] a(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length > 1 && byArray[0] == 0) {
            int n = byArray.length - 1;
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 1, byArray2, 0, n);
            byArray = byArray2;
        }
        return byArray;
    }

    static final class CertificateMsg
    extends HandshakeMessage {
        private X509Certificate[] a;

        int messageLength() {
            int n = 3;
            try {
                for (int i = this.a.length - 1; i >= 0; --i) {
                    n += 3 + this.a[i].getEncoded().length;
                }
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
            return n;
        }

        int messageType() {
            return 11;
        }

        CertificateMsg(HandshakeInStream handshakeInStream) throws IOException {
            int n;
            int n2 = handshakeInStream.d();
            Vector<Certificate> vector = new Vector<Certificate>(3);
            while (n2 > 0) {
                int n3;
                n = handshakeInStream.d();
                byte[] byArray = new byte[n];
                n2 -= 3 + n;
                for (int i = 0; i != n; i += n3) {
                    n3 = handshakeInStream.read(byArray, i, n - i);
                    if (n3 >= 0) continue;
                    throw new SSLProtocolException("short read of certificates");
                }
                try {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    vector.addElement(certificateFactory.generateCertificate(new ByteArrayInputStream(byArray)));
                }
                catch (CertificateException certificateException) {
                    throw (SSLProtocolException)new SSLProtocolException(certificateException.getMessage()).initCause(certificateException);
                }
            }
            this.a = new X509Certificate[vector.size()];
            for (n = 0; n < this.a.length; ++n) {
                this.a[n] = (X509Certificate)vector.elementAt(n);
            }
        }

        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            try {
                handshakeOutStream.c(this.messageLength() - 3);
                for (int i = 0; i < this.a.length; ++i) {
                    handshakeOutStream.c(this.a[i].getEncoded());
                }
            }
            catch (CertificateException certificateException) {
                throw (SSLProtocolException)new SSLProtocolException(certificateException.getMessage()).initCause(certificateException);
            }
        }

        void a(PrintStream printStream) throws IOException {
            printStream.println("*** Certificate chain");
            if (k != null && Debug.isOn("verbose")) {
                for (int i = 0; i < this.a.length; ++i) {
                    printStream.println("chain [" + i + "] = " + this.a[i]);
                }
                printStream.println("***");
            }
        }

        public X509Certificate[] getCertificateChain() {
            return this.a;
        }

        CertificateMsg(X509Certificate[] x509CertificateArray) {
            this.a = x509CertificateArray;
        }
    }

    static final class DH_ServerKeyExchange
    extends SunJSSE_a6 {
        private static final boolean a = Debug.a("com.sun.net.ssl.dhKeyExchangeFix", true);
        private byte[] b;
        private byte[] c;
        private byte[] d;
        private byte[] e;

        int messageLength() {
            int n = 6;
            n += this.b.length;
            n += this.c.length;
            n += this.d.length;
            if (this.e != null) {
                n += this.e.length;
                if (a) {
                    n += 2;
                }
            }
            return n;
        }

        DH_ServerKeyExchange(HandshakeInStream handshakeInStream) throws IOException {
            this.b = handshakeInStream.g();
            this.c = handshakeInStream.g();
            this.d = handshakeInStream.g();
            this.e = null;
        }

        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.b(this.b);
            handshakeOutStream.b(this.c);
            handshakeOutStream.b(this.d);
            if (this.e != null) {
                if (a) {
                    handshakeOutStream.b(this.e);
                } else {
                    handshakeOutStream.write(this.e);
                }
            }
        }

        DH_ServerKeyExchange(SunJSSE_bd sunJSSE_bd) {
            this.a(sunJSSE_bd);
            this.e = null;
        }

        private void a(SunJSSE_bd sunJSSE_bd) {
            this.b = HandshakeMessage.a(sunJSSE_bd.a());
            this.c = HandshakeMessage.a(sunJSSE_bd.b());
            this.d = HandshakeMessage.a(sunJSSE_bd.c());
        }

        void a(PrintStream printStream) throws IOException {
            printStream.println("*** Diffie-Hellman ServerKeyExchange");
            if (k != null && Debug.isOn("verbose")) {
                Debug.a(printStream, "DH Modulus", this.b);
                Debug.a(printStream, "DH Base", this.c);
                Debug.a(printStream, "Server DH Public Key", this.d);
                if (this.e == null) {
                    printStream.println("Anonymous");
                } else {
                    printStream.println("Signed with a DSA or RSA public key");
                }
            }
        }

        public BigInteger getBase() {
            return new BigInteger(1, this.c);
        }

        public BigInteger getModulus() {
            return new BigInteger(1, this.b);
        }

        public BigInteger getServerPublicKey() {
            return new BigInteger(1, this.d);
        }

        private void a(Signature signature, byte[] byArray, byte[] byArray2) throws SignatureException {
            signature.update(byArray);
            signature.update(byArray2);
            int n = this.b.length;
            signature.update((byte)(n >> 8));
            signature.update((byte)(n & 0xFF));
            signature.update(this.b);
            n = this.c.length;
            signature.update((byte)(n >> 8));
            signature.update((byte)(n & 0xFF));
            signature.update(this.c);
            n = this.d.length;
            signature.update((byte)(n >> 8));
            signature.update((byte)(n & 0xFF));
            signature.update(this.d);
        }

        DH_ServerKeyExchange(HandshakeInStream handshakeInStream, PublicKey publicKey, byte[] byArray, byte[] byArray2, int n) throws IOException, GeneralSecurityException {
            Signature signature;
            byte[] byArray3;
            this.b = handshakeInStream.g();
            this.c = handshakeInStream.g();
            this.d = handshakeInStream.g();
            if (a) {
                byArray3 = handshakeInStream.g();
            } else {
                n -= this.b.length + 2;
                n -= this.c.length + 2;
                byArray3 = new byte[n -= this.d.length + 2];
                handshakeInStream.read(byArray3);
            }
            if (publicKey instanceof DSAPublicKey) {
                signature = Signature.getInstance("DSA");
            } else if (publicKey instanceof RSAPublicKey) {
                signature = RSASignature.a();
            } else {
                throw new SSLKeyException("neither an RSA or a DSA key");
            }
            signature.initVerify(publicKey);
            this.a(signature, byArray, byArray2);
            if (!signature.verify(byArray3)) {
                throw new SSLKeyException("Server D-H key verification failed");
            }
        }

        DH_ServerKeyExchange(SunJSSE_bd sunJSSE_bd, PrivateKey privateKey, byte[] byArray, byte[] byArray2, SecureRandom secureRandom) throws GeneralSecurityException {
            this.a(sunJSSE_bd);
            Signature signature = privateKey instanceof DSAPrivateKey ? Signature.getInstance("DSA") : RSASignature.a();
            signature.initSign(privateKey, secureRandom);
            this.a(signature, byArray, byArray2);
            this.e = signature.sign();
        }
    }
}

