/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReader;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

public class J2KImageReaderSpi
extends ImageReaderSpi {
    private static String[] writerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriterSpi"};
    private static String[] formatNames = new String[]{"jpeg 2000", "JPEG 2000", "jpeg2000", "JPEG2000"};
    private static String[] extensions = new String[]{"jp2"};
    private static String[] mimeTypes = new String[]{"image/jp2", "image/jpeg2000"};

    public J2KImageReaderSpi() {
        super(PackageUtil.getVendor(), PackageUtil.getVersion(), formatNames, extensions, mimeTypes, "com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReader", ImageReaderSpi.STANDARD_INPUT_TYPE, writerSpiNames, false, null, null, null, null, true, "com_sun_media_imageio_plugins_jpeg2000_image_1.0", "com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadataFormat", null, null);
    }

    public void onRegistration(ServiceRegistry registry, Class category) {
        Object codecLibReaderSPI;
        Class<?> codecLibReaderSPIClass = null;
        try {
            codecLibReaderSPIClass = Class.forName("com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReaderCodecLibSpi");
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (codecLibReaderSPIClass != null && (codecLibReaderSPI = registry.getServiceProviderByClass(codecLibReaderSPIClass)) != null) {
            registry.setOrdering(category, codecLibReaderSPI, this);
        }
    }

    public String getDescription(Locale locale) {
        return "Standard JPEG 2000 Image Reader";
    }

    public boolean canDecodeInput(Object source) throws IOException {
        if (!(source instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream stream = (ImageInputStream)source;
        stream.mark();
        int marker = stream.read() << 8 | stream.read();
        if (marker == 65359) {
            stream.reset();
            return true;
        }
        stream.reset();
        stream.mark();
        byte[] b = new byte[12];
        stream.readFully(b);
        stream.reset();
        if (b[0] != 0 || b[1] != 0 || b[2] != 0 || b[3] != 12) {
            return false;
        }
        if ((b[4] & 0xFF) != 106 || (b[5] & 0xFF) != 80 || (b[6] & 0xFF) != 32 || (b[7] & 0xFF) != 32) {
            return false;
        }
        return (b[8] & 0xFF) == 13 && (b[9] & 0xFF) == 10 && (b[10] & 0xFF) == 135 && (b[11] & 0xFF) == 10;
    }

    public ImageReader createReaderInstance(Object extension) throws IIOException {
        return new J2KImageReader(this);
    }
}

