/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageio.plugins.jpeg2000.J2KImageReadParam;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.SimpleRenderedImage;
import com.sun.media.imageioimpl.plugins.jpeg2000.BitsPerComponentBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import com.sun.media.imageioimpl.plugins.jpeg2000.ChannelDefinitionBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.ColorSpecificationBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.ComponentMappingBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.HeaderBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReadParamJava;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReader;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReaderCodecLib;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadata;
import com.sun.media.imageioimpl.plugins.jpeg2000.MediaLibAccessor;
import com.sun.media.imageioimpl.plugins.jpeg2000.PaletteBox;
import com.sun.medialib.codec.jiio.mediaLibImage;
import com.sun.medialib.codec.jp2k.CompParams;
import com.sun.medialib.codec.jp2k.Decoder;
import com.sun.medialib.codec.jp2k.Size;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.imageio.ImageReadParam;
import javax.imageio.stream.ImageInputStream;

public class J2KRenderedImageCodecLib
extends SimpleRenderedImage {
    private SampleModel originalSampleModel;
    private Raster currentTile;
    private Point currentTileGrid;
    private J2KMetadata metadata;
    private ImageInputStream iis = null;
    private J2KImageReaderCodecLib reader;
    private J2KImageReadParam param = null;
    private Decoder decoder;
    private Size size;
    Rectangle destinationRegion;
    Rectangle originalRegion;
    Point sourceOrigin;
    private int scaleX;
    private int scaleY;
    private int xOffset;
    private int yOffset;
    private int[] destinationBands = null;
    private int[] sourceBands = null;
    private int nComp;
    private int[] channelMap;
    private boolean noTransform = true;
    private WritableRaster rasForATile;
    private BufferedImage destImage;
    static /* synthetic */ Class array$B;

    public J2KRenderedImageCodecLib(ImageInputStream iis, J2KImageReaderCodecLib reader, ImageReadParam param) throws IOException {
        int i;
        this.iis = iis;
        this.reader = reader;
        boolean allowZeroDestOffset = true;
        if (param == null) {
            param = (J2KImageReadParam)reader.getDefaultReadParam();
            allowZeroDestOffset = false;
        } else if (!(param instanceof J2KImageReadParam)) {
            param = new J2KImageReadParamJava(param);
            allowZeroDestOffset = false;
        }
        this.param = (J2KImageReadParam)param;
        this.decoder = new Decoder(iis);
        this.decoder.setMode(2);
        int resolution = ((J2KImageReadParam)param).getResolution();
        if (resolution != -1) {
            this.decoder.setMaxLevels(resolution);
        }
        this.size = this.decoder.decodeSize(null);
        this.sourceBands = param.getSourceBands();
        if (this.sourceBands == null) {
            this.nComp = this.size.csize;
            this.sourceBands = new int[this.nComp];
            i = 0;
            while (i < this.nComp) {
                this.sourceBands[i] = i;
                ++i;
            }
        }
        this.nComp = this.sourceBands.length;
        this.destinationBands = param.getDestinationBands();
        if (this.destinationBands == null) {
            this.destinationBands = new int[this.nComp];
            i = 0;
            while (i < this.nComp) {
                this.destinationBands[i] = i;
                ++i;
            }
        }
        this.width = this.size.xsize - this.size.xosize;
        this.height = this.size.ysize - this.size.yosize;
        Rectangle sourceRegion = new Rectangle(this.size.xosize, this.size.yosize, this.width, this.height);
        this.originalRegion = (Rectangle)sourceRegion.clone();
        this.destinationRegion = (Rectangle)sourceRegion.clone();
        J2KImageReader.computeRegionsWrapper(param, allowZeroDestOffset, this.width, this.height, param.getDestination(), sourceRegion, this.destinationRegion);
        this.scaleX = param.getSourceXSubsampling();
        this.scaleY = param.getSourceYSubsampling();
        this.xOffset = param.getSubsamplingXOffset();
        this.yOffset = param.getSubsamplingYOffset();
        this.sourceOrigin = new Point(sourceRegion.x, sourceRegion.y);
        if (!this.destinationRegion.equals(this.originalRegion)) {
            this.noTransform = false;
        }
        this.tileWidth = this.size.xtsize;
        this.tileHeight = this.size.ytsize;
        this.tileGridXOffset = this.size.xtosize;
        this.tileGridYOffset = this.size.ytosize;
        this.width = this.destinationRegion.width;
        this.height = this.destinationRegion.height;
        this.minX = this.destinationRegion.x;
        this.minY = this.destinationRegion.y;
        this.originalSampleModel = this.createOriginalSampleModel();
        this.sampleModel = this.createSampleModel();
        this.colorModel = this.createColorModel();
        this.tileGridXOffset += (this.XToTileX(this.minX) - this.XToTileX(this.tileGridXOffset)) * this.tileWidth;
        this.tileGridYOffset += (this.YToTileY(this.minY) - this.YToTileY(this.tileGridYOffset)) * this.tileHeight;
        double rate = ((J2KImageReadParam)param).getDecodingRate();
        if (rate != Double.MAX_VALUE) {
            this.decoder.setRate(rate /= (double)ImageUtil.getElementSize(this.sampleModel), 0);
        }
    }

    public synchronized Raster getTile(int tileX, int tileY) {
        if (this.currentTile != null && this.currentTileGrid.x == tileX && this.currentTileGrid.y == tileY) {
            return this.currentTile;
        }
        if (tileX >= this.getNumXTiles() || tileY >= this.getNumYTiles()) {
            throw new IllegalArgumentException(I18N.getString("J2KReadState1"));
        }
        try {
            int x = this.tileXToX(tileX);
            int y = this.tileYToY(tileY);
            this.currentTile = Raster.createWritableRaster(this.sampleModel, new Point(x, y));
            if (this.noTransform) {
                int sourceFormatTag = MediaLibAccessor.findCompatibleTag(this.currentTile);
                MediaLibAccessor accessor = new MediaLibAccessor(this.currentTile, this.currentTile.getBounds().intersection(this.originalRegion), sourceFormatTag, true);
                mediaLibImage[] mlImage = accessor.getMediaLibImages();
                int tileNo = (x - this.size.xtosize) / this.size.xtsize + (y - this.size.ytosize) / this.size.ytsize * this.size.nxtiles;
                this.decoder.decode(mlImage, tileNo);
            } else {
                this.currentTile = this.readSubsampledRaster((WritableRaster)this.currentTile);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.currentTileGrid == null) {
            this.currentTileGrid = new Point(tileX, tileY);
        } else {
            this.currentTileGrid.x = tileX;
            this.currentTileGrid.y = tileY;
        }
        return this.currentTile;
    }

    public synchronized void readAsRaster(WritableRaster raster) throws IOException {
        if (this.noTransform) {
            this.decoder.setMode(2);
            int sourceFormatTag = MediaLibAccessor.findCompatibleTag(raster);
            MediaLibAccessor accessor = new MediaLibAccessor(raster, this.destinationRegion, sourceFormatTag, true);
            mediaLibImage[] mlImage = accessor.getMediaLibImages();
            this.decoder.decode(mlImage, 0);
            if (accessor.isDataCopy()) {
                accessor.copyDataToRaster(this.channelMap);
            }
        } else {
            this.readSubsampledRaster(raster);
        }
    }

    private Raster readSubsampledRaster(WritableRaster raster) throws IOException {
        if (raster == null) {
            raster = Raster.createWritableRaster(this.sampleModel.createCompatibleSampleModel(this.destinationRegion.x + this.destinationRegion.width, this.destinationRegion.y + this.destinationRegion.height), new Point(this.destinationRegion.x, this.destinationRegion.y));
        }
        int numBands = this.sourceBands.length;
        Rectangle destRect = raster.getBounds().intersection(this.destinationRegion);
        int offx = this.destinationRegion.x;
        int offy = this.destinationRegion.y;
        int sourceSX = (destRect.x - offx) * this.scaleX + this.sourceOrigin.x;
        int sourceSY = (destRect.y - offy) * this.scaleY + this.sourceOrigin.y;
        int sourceEX = (destRect.width - 1) * this.scaleX + sourceSX;
        int sourceEY = (destRect.height - 1) * this.scaleY + sourceSY;
        int startXTile = (sourceSX - this.size.xtosize) / this.tileWidth;
        int startYTile = (sourceSY - this.size.ytosize) / this.tileHeight;
        int endXTile = (sourceEX - this.size.xtosize) / this.tileWidth;
        int endYTile = (sourceEY - this.size.ytosize) / this.tileHeight;
        startXTile = this.clip(startXTile, 0, this.size.nxtiles - 1);
        startYTile = this.clip(startYTile, 0, this.size.nytiles - 1);
        endXTile = this.clip(endXTile, 0, this.size.nxtiles - 1);
        endYTile = this.clip(endYTile, 0, this.size.nytiles - 1);
        int toltaXTiles = endXTile - startXTile + 1;
        int totalYTiles = endYTile - startYTile + 1;
        int totalTiles = toltaXTiles * totalYTiles;
        int[] pixbuf = null;
        int y = startYTile;
        while (y <= endYTile) {
            if (this.reader.getAbortRequest()) break;
            int x = startXTile;
            while (x <= endXTile) {
                if (this.reader.getAbortRequest()) break;
                float percentage = ((float)(x - startXTile) + 1.0f + (float)(y * toltaXTiles)) / (float)totalTiles;
                int startX = x * this.size.xtsize + this.size.xtosize;
                int startY = y * this.size.ytsize + this.size.ytosize;
                this.rasForATile = this.rasForATile == null ? Raster.createWritableRaster(this.originalSampleModel, new Point(startX, startY)) : this.rasForATile.createWritableTranslatedChild(startX, startY);
                int sourceFormatTag = MediaLibAccessor.findCompatibleTag(this.rasForATile);
                MediaLibAccessor accessor = new MediaLibAccessor(this.rasForATile, this.rasForATile.getBounds().intersection(this.originalRegion), sourceFormatTag, true);
                mediaLibImage[] mlImage = accessor.getMediaLibImages();
                this.decoder.decode(mlImage, x + y * this.size.nxtiles);
                if (accessor.isDataCopy()) {
                    accessor.copyDataToRaster(this.channelMap);
                }
                accessor.copyDataToRaster(this.channelMap);
                int cTileHeight = this.size.ytsize;
                int cTileWidth = this.size.xtsize;
                if (startY + cTileHeight >= this.size.ysize) {
                    cTileHeight = this.size.ysize - startY;
                }
                if (startX + cTileWidth >= this.size.xsize) {
                    cTileWidth = this.size.xsize - startX;
                }
                int tx = startX;
                int ty = startY;
                if (sourceSX > startX) {
                    cTileWidth += startX - sourceSX;
                    tx = sourceSX;
                    startX = sourceSX;
                }
                if (sourceSY > startY) {
                    cTileHeight += startY - sourceSY;
                    ty = sourceSY;
                    startY = sourceSY;
                }
                if (sourceEX < startX + cTileWidth - 1) {
                    cTileWidth += sourceEX - startX - cTileWidth + 1;
                }
                if (sourceEY < startY + cTileHeight - 1) {
                    cTileHeight += sourceEY - startY - cTileHeight + 1;
                }
                int x1 = (startX + this.scaleX - 1 - this.sourceOrigin.x) / this.scaleX;
                int x2 = (startX + this.scaleX - 1 + cTileWidth - this.sourceOrigin.x) / this.scaleX;
                int lineLength = x2 - x1;
                x2 = (x2 - 1) * this.scaleX + this.sourceOrigin.x;
                int y1 = (startY + this.scaleY - 1 - this.sourceOrigin.y) / this.scaleY;
                startY = y1 * this.scaleY + this.sourceOrigin.y;
                startX = x1 * this.scaleX + this.sourceOrigin.x;
                x1 += offx;
                y1 += offy;
                if (pixbuf == null || pixbuf.length < lineLength) {
                    pixbuf = new int[lineLength];
                }
                int l = startY;
                int m = y1;
                while (l < ty + cTileHeight) {
                    if (this.reader.getAbortRequest()) break;
                    int i = 0;
                    while (i < numBands) {
                        int j = lineLength - 1;
                        int k1 = x2;
                        while (j >= 0) {
                            pixbuf[j] = this.rasForATile.getSample(k1, l, i);
                            --j;
                            k1 -= this.scaleX;
                        }
                        raster.setSamples(x1, m, lineLength, 1, this.destinationBands[i], pixbuf);
                        ++i;
                    }
                    if (this.destImage != null) {
                        this.reader.processImageUpdateWrapper(this.destImage, x1, m, cTileWidth, 1, 1, 1, this.destinationBands);
                    }
                    this.reader.processImageProgressWrapper(percentage + ((float)(l - startY) + 1.0f) / (float)cTileHeight / (float)totalTiles);
                    l += this.scaleY;
                    ++m;
                }
                ++x;
            }
            ++y;
        }
        return raster;
    }

    public void setDestImage(BufferedImage image) {
        this.destImage = image;
    }

    public void clearDestImage() {
        this.destImage = null;
    }

    private int getTileNum(int x, int y) {
        int num = (y - this.getMinTileY()) * this.getNumXTiles() + x - this.getMinTileX();
        if (num < 0 || num >= this.getNumXTiles() * this.getNumYTiles()) {
            throw new IllegalArgumentException(I18N.getString("J2KReadState1"));
        }
        return num;
    }

    private int clip(int value, int min, int max) {
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        return value;
    }

    private SampleModel createSampleModel() throws IOException {
        int i;
        if (this.sampleModel != null) {
            return this.sampleModel;
        }
        if (this.metadata == null) {
            this.readImageMetadata();
        }
        HeaderBox header = (HeaderBox)this.metadata.getElement("JPEG2000HeaderBox");
        int maxDepth = 0;
        boolean isSigned = false;
        if (header != null) {
            maxDepth = header.getBitDepth();
            isSigned = (maxDepth & 0x80) > 0;
            maxDepth = (maxDepth & 0x7F) + 1;
        } else {
            CompParams compParam = new CompParams();
            int i2 = 0;
            while (i2 < this.size.csize) {
                this.decoder.decodeCompParams(compParam, i2);
                maxDepth = (compParam.depth & 0x7F) + 1;
                isSigned = (compParam.depth & 0x80) > 0;
                ++i2;
            }
        }
        BitsPerComponentBox bits = (BitsPerComponentBox)this.metadata.getElement("JPEG2000BitsPerComponentBox");
        if (bits != null) {
            byte[] depths = bits.getBitDepth();
            maxDepth = (depths[0] & 0x7F) + 1;
            isSigned = (depths[0] & 0x80) > 0;
            i = 1;
            while (i < this.nComp) {
                if (maxDepth > depths[this.sourceBands[i]]) {
                    maxDepth = (depths[this.sourceBands[i]] & 0x7F) + 1;
                }
                ++i;
            }
        }
        int[] bandOffsets = new int[this.nComp];
        i = 0;
        while (i < this.nComp) {
            bandOffsets[i] = i;
            ++i;
        }
        ChannelDefinitionBox cdb = (ChannelDefinitionBox)this.metadata.getElement("JPEG2000ChannelDefinitionBox");
        if (cdb != null && this.metadata.getElement("JPEG2000PaletteBox") == null) {
            short[] assoc = cdb.getAssociation();
            short[] types = cdb.getTypes();
            short[] channels = cdb.getChannel();
            int i3 = 0;
            while (i3 < types.length) {
                if (types[i3] == 0) {
                    bandOffsets[this.sourceBands[channels[i3]]] = assoc[i3] - 1;
                } else if (types[i3] == 1 || types[i3] == 2) {
                    bandOffsets[this.sourceBands[channels[i3]]] = channels[i3];
                }
                ++i3;
            }
        }
        return this.createSampleModel(this.nComp, maxDepth, bandOffsets, isSigned, this.tileWidth, this.tileHeight);
    }

    private SampleModel createOriginalSampleModel() throws IOException {
        int i;
        if (this.originalSampleModel != null) {
            return this.originalSampleModel;
        }
        if (this.metadata == null) {
            this.readImageMetadata();
        }
        HeaderBox header = (HeaderBox)this.metadata.getElement("JPEG2000HeaderBox");
        int maxDepth = 0;
        boolean isSigned = false;
        int nc = this.size.csize;
        if (header != null) {
            maxDepth = header.getBitDepth();
            isSigned = (maxDepth & 0x80) > 0;
            maxDepth = (maxDepth & 0x7F) + 1;
        } else {
            CompParams compParam = new CompParams();
            int i2 = 0;
            while (i2 < this.size.csize) {
                this.decoder.decodeCompParams(compParam, i2);
                maxDepth = (compParam.depth & 0x7F) + 1;
                isSigned = (compParam.depth & 0x80) > 0;
                ++i2;
            }
        }
        BitsPerComponentBox bits = (BitsPerComponentBox)this.metadata.getElement("JPEG2000BitsPerComponentBox");
        if (bits != null) {
            byte[] depths = bits.getBitDepth();
            maxDepth = (depths[0] & 0x7F) + 1;
            isSigned = (depths[0] & 0x80) > 0;
            i = 1;
            while (i < nc) {
                if (maxDepth > depths[i]) {
                    maxDepth = (depths[i] & 0x7F) + 1;
                }
                ++i;
            }
        }
        int[] bandOffsets = new int[nc];
        i = 0;
        while (i < nc) {
            bandOffsets[i] = i;
            ++i;
        }
        ChannelDefinitionBox cdb = (ChannelDefinitionBox)this.metadata.getElement("JPEG2000ChannelDefinitionBox");
        if (cdb != null && this.metadata.getElement("JPEG2000PaletteBox") == null) {
            short[] assoc = cdb.getAssociation();
            short[] types = cdb.getTypes();
            short[] channels = cdb.getChannel();
            this.channelMap = new int[nc];
            int i3 = 0;
            while (i3 < types.length) {
                if (types[i3] == 0) {
                    bandOffsets[channels[i3]] = assoc[i3] - 1;
                    this.channelMap[assoc[i3] - 1] = channels[i3];
                } else if (types[i3] == 1 || types[i3] == 2) {
                    bandOffsets[channels[i3]] = channels[i3];
                    this.channelMap[channels[i3]] = channels[i3];
                }
                ++i3;
            }
        }
        return this.createSampleModel(nc, maxDepth, bandOffsets, isSigned, this.size.xtsize, this.size.ytsize);
    }

    private SampleModel createSampleModel(int nc, int maxDepth, int[] bandOffsets, boolean isSigned, int tw, int th) {
        SampleModel sm = null;
        if (nc == 1 && (maxDepth == 1 || maxDepth == 2 || maxDepth == 4)) {
            sm = new MultiPixelPackedSampleModel(0, tw, th, maxDepth);
        } else if (maxDepth <= 8) {
            sm = new PixelInterleavedSampleModel(0, tw, th, nc, tw * nc, bandOffsets);
        } else if (maxDepth <= 16) {
            sm = new PixelInterleavedSampleModel(isSigned ? 2 : 1, tw, th, nc, tw * nc, bandOffsets);
        } else if (maxDepth <= 32) {
            sm = new PixelInterleavedSampleModel(3, tw, th, this.nComp, tw * this.nComp, bandOffsets);
        } else {
            throw new IllegalArgumentException(I18N.getString("J2KReadState11") + " " + maxDepth);
        }
        return sm;
    }

    private ColorModel createColorModel() throws IOException {
        if (this.colorModel != null) {
            return this.colorModel;
        }
        PaletteBox pBox = (PaletteBox)this.metadata.getElement("JPEG2000PaletteBox");
        ChannelDefinitionBox cdef = (ChannelDefinitionBox)this.metadata.getElement("JPEG2000ChannelDefinitionBox");
        if (pBox != null && this.nComp == 1) {
            byte[][] lut = pBox.getLUT();
            int numComp = pBox.getNumComp();
            int[] mapping = new int[numComp];
            int i = 0;
            while (i < numComp) {
                mapping[i] = i;
                ++i;
            }
            ComponentMappingBox cmap = (ComponentMappingBox)this.metadata.getElement("JPEG2000ComponentMappingBox");
            short[] comps = null;
            byte[] type = null;
            byte[] maps = null;
            if (cmap != null) {
                comps = cmap.getComponent();
                type = cmap.getComponentType();
                maps = cmap.getComponentAssociation();
            }
            if (comps != null) {
                int i2 = 0;
                while (i2 < numComp) {
                    if (type[i2] == 1) {
                        mapping[i2] = maps[i2];
                    }
                    ++i2;
                }
            }
            if (numComp == 3) {
                this.colorModel = new IndexColorModel(this.sampleModel.getSampleSize(0), lut[0].length, lut[mapping[0]], lut[mapping[1]], lut[mapping[2]]);
            } else if (numComp == 4) {
                this.colorModel = new IndexColorModel(this.sampleModel.getSampleSize(0), lut[0].length, lut[mapping[0]], lut[mapping[1]], lut[mapping[2]], lut[mapping[3]]);
            }
        } else if (cdef != null) {
            HeaderBox header = (HeaderBox)this.metadata.getElement("JPEG2000HeaderBox");
            int numComp = header.getNumComponents();
            byte bitDepth = header.getBitDepth();
            boolean hasAlpha = false;
            int alphaChannel = numComp - 1;
            short[] channels = cdef.getChannel();
            short[] cType = cdef.getTypes();
            short[] associations = cdef.getAssociation();
            int i = 0;
            while (i < channels.length) {
                if (cType[i] == 1 && channels[i] == alphaChannel) {
                    hasAlpha = true;
                }
                ++i;
            }
            boolean[] isPremultiplied = new boolean[]{false};
            if (hasAlpha) {
                isPremultiplied = new boolean[alphaChannel];
                int i3 = 0;
                while (i3 < alphaChannel) {
                    isPremultiplied[i3] = false;
                    ++i3;
                }
                int i4 = 0;
                while (i4 < channels.length) {
                    if (cType[i4] == 2) {
                        isPremultiplied[associations[i4] - 1] = true;
                    }
                    ++i4;
                }
                int i5 = 1;
                while (i5 < alphaChannel) {
                    isPremultiplied[0] = isPremultiplied[0] & isPremultiplied[i5];
                    ++i5;
                }
            }
            ColorSpecificationBox cBox = (ColorSpecificationBox)this.metadata.getElement("JPEG2000ColorSpecificationBox");
            ICC_Profile profile = null;
            int colorSpaceType = 0;
            if (cBox != null) {
                profile = cBox.getICCProfile();
                colorSpaceType = cBox.getEnumeratedColorSpace();
            }
            ColorSpace cs = null;
            if (profile != null) {
                cs = new ICC_ColorSpace(profile);
            } else if (colorSpaceType == 16) {
                cs = ColorSpace.getInstance(1000);
            } else if (colorSpaceType == 17) {
                cs = ColorSpace.getInstance(1003);
            } else if (colorSpaceType == 18) {
                cs = ColorSpace.getInstance(1002);
            }
            byte[] bitDepths = null;
            boolean isSigned = (bitDepth & 0x80) == 128;
            BitsPerComponentBox bitBox = (BitsPerComponentBox)this.metadata.getElement("JPEG2000BitsPerComponentBox");
            if (bitBox != null) {
                bitDepths = bitBox.getBitDepth();
            }
            int[] bits = new int[numComp];
            int i6 = 0;
            while (i6 < numComp) {
                bits[i6] = bitDepths != null ? (bitDepths[i6] & 0x7F) + 1 : (bitDepth & 0x7F) + 1;
                ++i6;
            }
            int maxBitDepth = 1 + (bitDepth & 0x7F);
            if (bitDepths != null) {
                int i7 = 0;
                while (i7 < numComp) {
                    if (bits[i7] > maxBitDepth) {
                        maxBitDepth = bits[i7];
                    }
                    ++i7;
                }
            }
            int type = -1;
            if (maxBitDepth <= 8) {
                type = 0;
            } else if (maxBitDepth <= 16) {
                type = isSigned ? 2 : 1;
            } else if (maxBitDepth <= 32) {
                type = 3;
            }
            if (type == -1) {
                return null;
            }
            if (cs != null) {
                this.colorModel = new ComponentColorModel(cs, bits, hasAlpha, isPremultiplied[0], hasAlpha ? 3 : 1, type);
            }
        }
        if (this.colorModel != null) {
            return this.colorModel;
        }
        return ImageUtil.createColorModel(null, this.getSampleModel());
    }

    public J2KMetadata readImageMetadata() throws IOException {
        if (this.metadata == null) {
            this.metadata = new J2KMetadata();
            com.sun.medialib.codec.jp2k.Box mlibBox = null;
            Box box = null;
            while ((mlibBox = this.decoder.decodeBox()) != null) {
                box = null;
                Class c = Box.getBoxClass(mlibBox.type);
                if (c != null) {
                    try {
                        Constructor cons = c.getConstructor(array$B == null ? J2KRenderedImageCodecLib.class$("[B") : array$B);
                        if (cons != null) {
                            box = (Box)cons.newInstance(new Object[]{mlibBox.data});
                        }
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            Constructor cons = c.getConstructor(Integer.TYPE, array$B == null ? J2KRenderedImageCodecLib.class$("[B") : array$B);
                            if (cons != null) {
                                box = (Box)cons.newInstance(new Integer(mlibBox.type), mlibBox.data);
                            }
                        }
                        catch (NoSuchMethodException e1) {
                            box = this.createUnknowBox(mlibBox);
                        }
                        catch (InvocationTargetException e1) {
                            box = this.createUnknowBox(mlibBox);
                        }
                        catch (IllegalAccessException e1) {
                            box = this.createUnknowBox(mlibBox);
                        }
                        catch (InstantiationException e1) {
                            box = this.createUnknowBox(mlibBox);
                        }
                    }
                    catch (InvocationTargetException e) {
                        box = this.createUnknowBox(mlibBox);
                    }
                    catch (IllegalAccessException e) {
                        box = this.createUnknowBox(mlibBox);
                    }
                    catch (InstantiationException e) {
                        box = this.createUnknowBox(mlibBox);
                    }
                } else if (mlibBox.data != null) {
                    box = this.createUnknowBox(mlibBox);
                }
                if (box == null) continue;
                this.metadata.addNode(box);
            }
        }
        return this.metadata;
    }

    private Box createUnknowBox(com.sun.medialib.codec.jp2k.Box mlibBox) {
        return new Box(8 + mlibBox.data.length, mlibBox.type, mlibBox.data);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

