/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.png;

import com.sun.media.imageioimpl.plugins.clib.CLibImageReader;
import com.sun.media.imageioimpl.plugins.png.CLibPNGMetadata;
import com.sun.media.imageioimpl.plugins.png.I18N;
import com.sun.medialib.codec.jiio.mediaLibImage;
import com.sun.medialib.codec.png.Decoder;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.IIOException;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;

final class CLibPNGImageReader
extends CLibImageReader {
    private Decoder decoder;
    private ImageTypeSpecifier imageType = null;

    CLibPNGImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    protected final synchronized mediaLibImage decode(InputStream stream) throws IOException {
        try {
            this.decoder = new Decoder(stream);
            this.decoder.decode();
        }
        catch (Throwable t) {
            throw new IIOException("codecLib error", t);
        }
        mediaLibImage mlImage = null;
        try {
            mlImage = this.decoder.getImage();
        }
        catch (Throwable t) {
            throw new IIOException("codecLib error", t);
        }
        if (mlImage == null) {
            throw new IIOException(I18N.getString("CLibPNGImageReader0"));
        }
        return mlImage;
    }

    public synchronized ImageTypeSpecifier getRawImageType(int imageIndex) throws IOException {
        if (imageIndex != 0) {
            throw new IndexOutOfBoundsException("imageIndex != 0");
        }
        if (this.imageType == null) {
            mediaLibImage image = this.getImage();
            byte[] rgbPalette = null;
            try {
                rgbPalette = this.decoder.getPalette();
            }
            catch (Throwable t) {
                throw new IIOException("codecLib error", t);
            }
            if (rgbPalette != null) {
                int paletteLength = rgbPalette.length / 3;
                byte[] r = new byte[paletteLength];
                byte[] g = new byte[paletteLength];
                byte[] b = new byte[paletteLength];
                int i = 0;
                int j = 0;
                while (i < paletteLength) {
                    r[i] = rgbPalette[j++];
                    g[i] = rgbPalette[j++];
                    b[i] = rgbPalette[j++];
                    ++i;
                }
                int[] alphaPalette = null;
                try {
                    alphaPalette = this.decoder.getTransparency();
                }
                catch (Throwable t) {
                    throw new IIOException("codecLib error", t);
                }
                byte[] a = null;
                if (alphaPalette != null) {
                    a = new byte[paletteLength];
                    int i2 = 0;
                    while (i2 < alphaPalette.length) {
                        a[i2] = (byte)(alphaPalette[i2] & 0xFF);
                        ++i2;
                    }
                    int i3 = alphaPalette.length;
                    while (i3 < paletteLength) {
                        a[i3] = -1;
                        ++i3;
                    }
                }
                this.imageType = CLibImageReader.createImageType(image, 8, r, g, b, a);
            } else {
                int bitDepth;
                switch (image.getType()) {
                    case 0: {
                        bitDepth = 1;
                        break;
                    }
                    case 1: {
                        bitDepth = 8;
                        break;
                    }
                    default: {
                        bitDepth = 16;
                    }
                }
                this.imageType = CLibImageReader.createImageType(image, bitDepth, null, null, null, null);
            }
        }
        return this.imageType;
    }

    protected void resetLocal() {
        this.decoder = null;
        this.imageType = null;
        super.resetLocal();
    }

    public synchronized IIOMetadata getImageMetadata(int imageIndex) throws IIOException {
        if (this.input == null) {
            throw new IllegalStateException("input == null");
        }
        if (imageIndex != 0) {
            throw new IndexOutOfBoundsException("imageIndex != 0");
        }
        CLibPNGMetadata im = new CLibPNGMetadata();
        try {
            this.getImage();
        }
        catch (IOException e) {
            throw new IIOException("codecLib error", e);
        }
        im.readMetadata(this, this.decoder);
        return im;
    }

    void forwardWarningMessage(String warning) {
        this.processWarningOccurred(warning);
    }
}

