/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.sql.Timestamp;
import org.apache.derby.catalog.ReferencedColumns;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.FileInfoDescriptor;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;

public class DataDescriptorGenerator {
    private UUIDFactory uuidf;
    protected final DataDictionary dataDictionary;

    public SchemaDescriptor newSchemaDescriptor(String string, String string2, UUID uUID) throws StandardException {
        return new SchemaDescriptor(this.dataDictionary, string, string2, uUID, this.dataDictionary.isSystemSchemaName(string));
    }

    public TableDescriptor newTableDescriptor(String string, SchemaDescriptor schemaDescriptor, int n, char c) {
        return new TableDescriptor(this.dataDictionary, string, schemaDescriptor, n, c);
    }

    public TableDescriptor newTableDescriptor(String string, SchemaDescriptor schemaDescriptor, int n, boolean bl, boolean bl2) {
        return new TableDescriptor(this.dataDictionary, string, schemaDescriptor, n, bl, bl2);
    }

    public ViewDescriptor newViewDescriptor(UUID uUID, String string, String string2, int n, UUID uUID2) {
        return new ViewDescriptor(this.dataDictionary, uUID, string, string2, n, uUID2);
    }

    public ReferencedKeyConstraintDescriptor newUniqueConstraintDescriptor(TableDescriptor tableDescriptor, String string, boolean bl, boolean bl2, int[] nArray, UUID uUID, UUID uUID2, SchemaDescriptor schemaDescriptor, boolean bl3, int n) {
        return new ReferencedKeyConstraintDescriptor(3, this.dataDictionary, tableDescriptor, string, bl, bl2, nArray, uUID, uUID2, schemaDescriptor, bl3, n);
    }

    public ReferencedKeyConstraintDescriptor newPrimaryKeyConstraintDescriptor(TableDescriptor tableDescriptor, String string, boolean bl, boolean bl2, int[] nArray, UUID uUID, UUID uUID2, SchemaDescriptor schemaDescriptor, boolean bl3, int n) {
        return new ReferencedKeyConstraintDescriptor(2, this.dataDictionary, tableDescriptor, string, bl, bl2, nArray, uUID, uUID2, schemaDescriptor, bl3, n);
    }

    public ForeignKeyConstraintDescriptor newForeignKeyConstraintDescriptor(TableDescriptor tableDescriptor, String string, boolean bl, boolean bl2, int[] nArray, UUID uUID, UUID uUID2, SchemaDescriptor schemaDescriptor, ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor, boolean bl3, int n, int n2) {
        return new ForeignKeyConstraintDescriptor(this.dataDictionary, tableDescriptor, string, bl, bl2, nArray, uUID, uUID2, schemaDescriptor, referencedKeyConstraintDescriptor, bl3, n, n2);
    }

    public ForeignKeyConstraintDescriptor newForeignKeyConstraintDescriptor(TableDescriptor tableDescriptor, String string, boolean bl, boolean bl2, int[] nArray, UUID uUID, UUID uUID2, SchemaDescriptor schemaDescriptor, UUID uUID3, boolean bl3, int n, int n2) {
        return new ForeignKeyConstraintDescriptor(this.dataDictionary, tableDescriptor, string, bl, bl2, nArray, uUID, uUID2, schemaDescriptor, uUID3, bl3, n, n2);
    }

    public CheckConstraintDescriptor newCheckConstraintDescriptor(TableDescriptor tableDescriptor, String string, boolean bl, boolean bl2, UUID uUID, String string2, ReferencedColumns referencedColumns, SchemaDescriptor schemaDescriptor, boolean bl3) {
        return new CheckConstraintDescriptor(this.dataDictionary, tableDescriptor, string, bl, bl2, uUID, string2, referencedColumns, schemaDescriptor, bl3);
    }

    public CheckConstraintDescriptor newCheckConstraintDescriptor(TableDescriptor tableDescriptor, String string, boolean bl, boolean bl2, UUID uUID, String string2, int[] nArray, SchemaDescriptor schemaDescriptor, boolean bl3) {
        ReferencedColumnsDescriptorImpl referencedColumnsDescriptorImpl = new ReferencedColumnsDescriptorImpl(nArray);
        return new CheckConstraintDescriptor(this.dataDictionary, tableDescriptor, string, bl, bl2, uUID, string2, referencedColumnsDescriptorImpl, schemaDescriptor, bl3);
    }

    public ConglomerateDescriptor newConglomerateDescriptor(long l, String string, boolean bl, IndexRowGenerator indexRowGenerator, boolean bl2, UUID uUID, UUID uUID2, UUID uUID3) {
        return new ConglomerateDescriptor(this.dataDictionary, l, string, bl, indexRowGenerator, bl2, uUID, uUID2, uUID3);
    }

    public TriggerDescriptor newTriggerDescriptor(SchemaDescriptor schemaDescriptor, UUID uUID, String string, int n, boolean bl, boolean bl2, boolean bl3, TableDescriptor tableDescriptor, UUID uUID2, UUID uUID3, Timestamp timestamp, int[] nArray, String string2, boolean bl4, boolean bl5, String string3, String string4) throws StandardException {
        return new TriggerDescriptor(this.dataDictionary, schemaDescriptor, uUID, string, n, bl, bl2, bl3, tableDescriptor, uUID2, uUID3, timestamp, nArray, string2, bl4, bl5, string3, string4);
    }

    protected UUIDFactory getUUIDFactory() {
        if (this.uuidf == null) {
            this.uuidf = Monitor.getMonitor().getUUIDFactory();
        }
        return this.uuidf;
    }

    public FileInfoDescriptor newFileInfoDescriptor(UUID uUID, SchemaDescriptor schemaDescriptor, String string, long l) {
        if (uUID == null) {
            uUID = this.getUUIDFactory().createUUID();
        }
        return new FileInfoDescriptor(this.dataDictionary, uUID, schemaDescriptor, string, l);
    }

    public DataDescriptorGenerator(DataDictionary dataDictionary) {
        this.dataDictionary = dataDictionary;
    }
}

