/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.util;

import com.belenus.util.CharArray;
import com.belenus.util.Configurator;
import com.belenus.util.StringUtil;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;

public class HtmlInfo {
    public static final String RED = "\"#FF2020\"";
    public static final String GREEN = "\"#A0D600\"";
    public static final String WHITE = "\"#FFFFFF\"";
    public static final String GRAY = "\"#D0D0D0\"";
    public static final String BLACK = "\"#000000\"";
    private PrintWriter m_printWriter;
    private String[] lineColours = new String[]{"\"#FFFFFF\"", "\"#D0D0D0\""};
    private int currentLineColour = 0;

    public HtmlInfo(PrintWriter printWriter) {
        this.m_printWriter = printWriter;
    }

    public void showHeader(String header, int headerlevel) {
        this.showDelim();
        this.m_printWriter.println("<tr bgcolor=\"#A0D600\" background=\"server?command=resource&amp;file=background.gif\" style=\"background-image:url(server?command=resource&amp;file=background.gif)\"><td colspan=\"2\"><font face=\"Helvetica,Arial,sans-serif\" size=\"" + (7 - headerlevel) + "\"><b>" + header + "</b></font></td></tr>");
        this.currentLineColour = 0;
    }

    public void showLine(String line) {
        this.m_printWriter.println("<tr bgcolor=" + this.lineColours[this.currentLineColour] + "><td colspan=\"2\"><tt>" + line + "</tt></td></tr>");
        this.currentLineColour = (this.currentLineColour + 1) % this.lineColours.length;
    }

    public void showText(String text) {
        this.m_printWriter.println("<tr><td colspan=\"2\">" + text + "</td></tr>");
    }

    public void showValue(String valuename, Object value) {
        value = value == null ? "<font face=\"Helvetica,Arial,sans-serif\" size=\"-1\"><i>empty</i></font>" : (value.equals("") ? "<tt>&nbsp;</tt>" : "<tt>" + StringUtil.replaceAll(StringUtil.encodeForSGML(value.toString()), "\n", "<br>") + "</tt>");
        valuename = new String(CharArray.encodeForSGML(valuename.toCharArray()));
        this.m_printWriter.println("<tr bgcolor=" + this.lineColours[this.currentLineColour] + "><td><nobr><tt>" + valuename + "&nbsp;</tt></nobr></td><td>" + value + "</td></tr>");
        this.currentLineColour = (this.currentLineColour + 1) % this.lineColours.length;
    }

    public void showValues(String valuename, Object[] values) {
        if (values == null) {
            this.showValue(valuename + "[null]", null);
        } else if (values.length == 0) {
            this.showValue(valuename + "[]", null);
        } else {
            for (int i = 0; i < values.length; ++i) {
                this.showValue(valuename + "[" + i + "]", values[i]);
            }
        }
    }

    public void showDelim() {
        this.m_printWriter.println("<tr bgcolor=\"#FFFFFF\" height=\"1\"><td colspan=\"2\"><img height=\"1\" src=\"server?command=resource&amp;file=transparent.gif\"></td></tr>");
        this.currentLineColour = 0;
    }

    public void showProperties(PrintStream out, Properties properties) {
        ArrayList<Object> propertyKeys = new ArrayList<Object>(properties.keySet());
        Collections.sort(propertyKeys, new Comparator(){

            public int compare(Object object1, Object object2) {
                return ((String)object1).compareTo((String)object2);
            }
        });
        for (int propertyKeysIndex = 0; propertyKeysIndex < propertyKeys.size(); ++propertyKeysIndex) {
            String key = (String)propertyKeys.get(propertyKeysIndex);
            this.showValue(key, properties.getProperty(key));
        }
    }

    public void showLeadin(String serverType, String version, String revision) {
        this.m_printWriter.println("<html>\n<head><title>" + serverType + "</title></head>\n" + "<body bgcolor=" + WHITE + " text=" + BLACK + ">\n" + "<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
        this.showHeader("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr height=\"42\"><td width=\"131\"><img src=\"server?command=resource&amp;file=belenus.gif\" width=\"131\" height=\"42\"></td><td align=\"middle\"><font face=\"Helvetica,Arial,sans-serif\" size=\"6\"><b>" + serverType + "</b></td>" + "<td align=\"right\" valign=\"bottom\"><font face=\"Helvetica,Arial,sans-serif\" size=\"2\">Version " + version + " - Revision " + revision + "</font></td>" + "</tr></table>", 1);
    }

    public void showLeadout() {
        this.showDelim();
        this.m_printWriter.print("</table>\n</body>\n</html>\n");
    }

    public void showException(String caption, Throwable throwable) {
        if (throwable != null) {
            this.showHeader("<font color=\"#FF2020\">" + caption + "</font>", 2);
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            this.showProblem(stringWriter.toString());
        }
    }

    public void showProblem(String problem) {
        this.showText("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td bgcolor=\"#FF2020\" width=\"20\">&nbsp;</td><td bgcolor=\"#FFFFFF\" width=\"20\">&nbsp;</td><td><font color=\"#FF2020\"><pre>" + StringUtil.encodeForSGML(problem) + "</pre></font></td>" + "</tr></table>");
    }

    public void showLog() {
        this.showHeader("Log", 2);
        this.showLine("<a href=\"server?command=log\">Server Log</a>");
        this.showLine("<a href=\"server?command=systeminfo\">System Info</a>");
    }

    public void showRequestInformation(HttpServletRequest httpServletRequest) {
        this.showHeader("Request Information", 3);
        this.showValue("Servlet Path", httpServletRequest.getServletPath());
        this.showValue("Request URI", httpServletRequest.getRequestURI());
        Enumeration headerNamesEnumeration = httpServletRequest.getHeaderNames();
        while (headerNamesEnumeration.hasMoreElements()) {
            String headerName = (String)headerNamesEnumeration.nextElement();
            String headerValue = httpServletRequest.getHeader(headerName);
            this.showValue("HTTP Header " + headerName, headerValue);
        }
    }

    public void showServletContainer(HttpServlet httpServlet) {
        this.showHeader("Servlet Container", 3);
        String javaVmVersion = System.getProperty("java.vm.version");
        this.showValue("Java VM Version", javaVmVersion);
        String javaVmVendor = System.getProperty("java.vm.vendor");
        this.showValue("Java VM Vendor", javaVmVendor);
        String javaVmName = System.getProperty("java.vm.name");
        this.showValue("Java VM Name", javaVmName);
        String javaSpecificationVersion = System.getProperty("java.specification.version");
        this.showValue("Java Specification Version", javaSpecificationVersion);
        String javaSpecificationVendor = System.getProperty("java.specification.vendor");
        this.showValue("Java Specification Vendor", javaSpecificationVendor);
        String javaSpecificationName = System.getProperty("java.specification.name");
        this.showValue("Java Specification Name", javaSpecificationName);
        ServletContext servletContext = httpServlet.getServletConfig().getServletContext();
        String serverInfo = servletContext.getServerInfo();
        this.showValue("Servlet Container Info", serverInfo);
        String version = "" + servletContext.getMajorVersion() + "." + servletContext.getMinorVersion();
        this.showValue("Servlet Container Version", version);
        String realPath = servletContext.getRealPath("/");
        this.showValue("Deploy Directory", realPath);
    }

    public void showServerState(String serverName, String webAppBase, Date startupDate, String contentcoding) {
        this.showHeader("Server State", 3);
        this.showValue("Server Name", serverName);
        this.showValue("Startup Date", startupDate + " (running for " + (new Date().getTime() - startupDate.getTime()) / 1000L + " seconds)");
        this.showValue("Web Application Base", webAppBase);
        long freemem = Runtime.getRuntime().freeMemory();
        long totalmem = Runtime.getRuntime().totalMemory();
        this.showLine(String.valueOf(freemem) + " of " + totalmem + " bytes available");
        if (contentcoding == null) {
            this.showLine("Communication with client does not use compression.");
        } else {
            this.showLine("Communication with client uses compression '" + contentcoding + "'.");
        }
    }

    public void showSettings(Configurator configurator) {
        for (int scopeIndex = 0; scopeIndex < configurator.getScopeCount(); ++scopeIndex) {
            String scopeName = configurator.getScopeName(scopeIndex);
            int entryCount = configurator.getEntryCount(scopeName);
            this.showHeader(scopeName, 3);
            for (int entryIndex = 0; entryIndex < entryCount; ++entryIndex) {
                String entryName = configurator.getEntryName(scopeName, entryIndex);
                Object entryValue = configurator.getEntryValue(scopeName, entryIndex);
                this.showValue(entryName, entryValue);
            }
        }
    }

    public void showResponders(ArrayList responderNames, HashMap responderClassMap) {
        for (int responderNamesIndex = 0; responderNamesIndex < responderNames.size(); ++responderNamesIndex) {
            String responderName = (String)responderNames.get(responderNamesIndex);
            Class responderClass = (Class)responderClassMap.get(responderName);
            this.showValue(responderName, responderClass.getName());
        }
    }
}

